/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.pages;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconCompat;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BookSnippetPage
extends BookTextPage {
    private final ResourceLocation resourcePath;
    private final int resourceWidth;
    private final int resourceHeight;
    private final int textureX;
    private final int textureY;
    private final int textureWidth;
    private final int textureHeight;

    public BookSnippetPage(BookTextHolder title, BookTextHolder text, boolean useMarkdownInTitle, boolean showTitleSeparator, String anchor, BookCondition condition, ResourceLocation resourcePath, int resourceWidth, int resourceHeight, int textureX, int textureY, int textureWidth, int textureHeight) {
        super(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
        this.resourcePath = resourcePath;
        this.resourceWidth = resourceWidth;
        this.resourceHeight = resourceHeight;
        this.textureX = textureX;
        this.textureY = textureY;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public static BookSnippetPage fromJson(ResourceLocation entryId, JsonObject json, HolderLookup.Provider provider) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        boolean useMarkdownInTitle = GsonHelper.getAsBoolean((JsonObject)json, (String)"use_markdown_title", (boolean)false);
        boolean showTitleSeparator = GsonHelper.getAsBoolean((JsonObject)json, (String)"show_title_separator", (boolean)false);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((ResourceLocation)entryId, (JsonObject)json.getAsJsonObject("condition"), (HolderLookup.Provider)provider) : new BookNoneCondition();
        ResourceLocation resourcePath = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"resource_path"));
        int resourceWidth = GsonHelper.getAsInt((JsonObject)json, (String)"resource_width");
        int resourceHeight = GsonHelper.getAsInt((JsonObject)json, (String)"resource_height");
        int textureX = GsonHelper.getAsInt((JsonObject)json, (String)"texture_x");
        int textureY = GsonHelper.getAsInt((JsonObject)json, (String)"texture_y");
        int textureWidth = GsonHelper.getAsInt((JsonObject)json, (String)"texture_width");
        int textureHeight = GsonHelper.getAsInt((JsonObject)json, (String)"texture_height");
        return new BookSnippetPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, (BookCondition)condition, resourcePath, resourceWidth, resourceHeight, textureX, textureY, textureWidth, textureHeight);
    }

    public static BookSnippetPage fromNetwork(RegistryFriendlyByteBuf buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        boolean useMarkdownInTitle = buffer.readBoolean();
        boolean showTitleSeparator = buffer.readBoolean();
        BookTextHolder text = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork((RegistryFriendlyByteBuf)buffer);
        ResourceLocation resourcePath = buffer.readResourceLocation();
        int resourceWidth = buffer.readVarInt();
        int resourceHeight = buffer.readVarInt();
        int textureX = buffer.readVarInt();
        int textureY = buffer.readVarInt();
        int textureWidth = buffer.readVarInt();
        int textureHeight = buffer.readVarInt();
        return new BookSnippetPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition, resourcePath, resourceWidth, resourceHeight, textureX, textureY, textureWidth, textureHeight);
    }

    public ResourceLocation getResourcePath() {
        return this.resourcePath;
    }

    public int getResourceWidth() {
        return this.resourceWidth;
    }

    public int getResourceHeight() {
        return this.resourceHeight;
    }

    public int getTextureX() {
        return this.textureX;
    }

    public int getTextureY() {
        return this.textureY;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public ResourceLocation getType() {
        return ModonomiconCompat.SNIPPET_PAGE;
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        super.toNetwork(buffer);
        buffer.writeResourceLocation(this.resourcePath);
        buffer.writeVarInt(this.resourceWidth);
        buffer.writeVarInt(this.resourceHeight);
        buffer.writeVarInt(this.textureX);
        buffer.writeVarInt(this.textureY);
        buffer.writeVarInt(this.textureWidth);
        buffer.writeVarInt(this.textureHeight);
    }
}

