/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.client.pages;

import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.compat.modonomicon.client.pages.BookGatedRecipePageRenderer;
import earth.terrarium.pastel.compat.modonomicon.pages.BookGatedRecipePage;
import earth.terrarium.pastel.items.magic_items.KnowledgeGemItem;
import earth.terrarium.pastel.recipe.enchanter.EnchantmentUpgradeRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class BookEnchanterUpgradingPageRenderer
extends BookGatedRecipePageRenderer<EnchantmentUpgradeRecipe, BookGatedRecipePage<EnchantmentUpgradeRecipe>> {
    private static final ResourceLocation BACKGROUND_TEXTURE = PastelCommon.locate("textures/gui/modonomicon/enchanter_crafting.png");

    public BookEnchanterUpgradingPageRenderer(BookGatedRecipePage<EnchantmentUpgradeRecipe> page) {
        super(page);
    }

    protected int getRecipeHeight() {
        return 94;
    }

    protected void drawRecipe(GuiGraphics drawContext, RecipeHolder<EnchantmentUpgradeRecipe> recipeEntry, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        EnchantmentUpgradeRecipe recipe = (EnchantmentUpgradeRecipe)recipeEntry.value();
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        RenderSystem.enableBlend();
        drawContext.blit(BACKGROUND_TEXTURE, recipeX, recipeY, 0.0f, 0.0f, 100, 80, 256, 256);
        this.renderTitle(drawContext, recipeY, second);
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        int ingredientX = recipeX - 3;
        ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
        int requiredItemCountSplit = recipe.getBaseItemCost() / 8;
        int requiredItemCountModulo = recipe.getBaseItemCost() % 8;
        for (int i = 0; i < 8; ++i) {
            int addAmount = i < requiredItemCountModulo ? 1 : 0;
            inputStacks.add(new ItemStack((ItemLike)recipe.getBulkItem(), requiredItemCountSplit + addAmount));
        }
        this.parentScreen.renderItemStack(drawContext, ingredientX + 16, recipeY, mouseX, mouseY, (ItemStack)inputStacks.get(0));
        this.parentScreen.renderItemStack(drawContext, ingredientX + 40, recipeY, mouseX, mouseY, (ItemStack)inputStacks.get(1));
        this.parentScreen.renderItemStack(drawContext, ingredientX + 56, recipeY + 16, mouseX, mouseY, (ItemStack)inputStacks.get(2));
        this.parentScreen.renderItemStack(drawContext, ingredientX + 56, recipeY + 40, mouseX, mouseY, (ItemStack)inputStacks.get(3));
        this.parentScreen.renderItemStack(drawContext, ingredientX + 40, recipeY + 56, mouseX, mouseY, (ItemStack)inputStacks.get(4));
        this.parentScreen.renderItemStack(drawContext, ingredientX + 16, recipeY + 56, mouseX, mouseY, (ItemStack)inputStacks.get(5));
        this.parentScreen.renderItemStack(drawContext, ingredientX, recipeY + 40, mouseX, mouseY, (ItemStack)inputStacks.get(6));
        this.parentScreen.renderItemStack(drawContext, ingredientX, recipeY + 16, mouseX, mouseY, (ItemStack)inputStacks.get(7));
        this.parentScreen.renderIngredient(drawContext, ingredientX + 28, recipeY + 28, mouseX, mouseY, (Ingredient)ingredients.getFirst());
        ItemStack knowledgeDropStackWithXP = KnowledgeGemItem.getKnowledgeDropStackWithXP(recipe.getBaseXPCost(), true);
        this.parentScreen.renderItemStack(drawContext, recipeX + 81, recipeY + 9, mouseX, mouseY, knowledgeDropStackWithXP);
        this.parentScreen.renderItemStack(drawContext, recipeX + 81, recipeY + 46, mouseX, mouseY, ((Block)PastelBlocks.ENCHANTER.get()).asItem().getDefaultInstance());
        this.parentScreen.renderItemStack(drawContext, recipeX + 81, recipeY + 31, mouseX, mouseY, recipe.getResultItem((HolderLookup.Provider)world.registryAccess()));
    }
}

