/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.pastel.compat.emi.FluidIngredientEmi;
import earth.terrarium.pastel.compat.emi.GatedSpectrumEmiRecipe;
import earth.terrarium.pastel.compat.emi.PastelEmiRecipeCategories;
import earth.terrarium.pastel.recipe.titration_barrel.ITitrationBarrelRecipe;
import earth.terrarium.pastel.recipe.titration_barrel.TitrationBarrelRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TitrationBarrelEmiRecipeGated
extends GatedSpectrumEmiRecipe<ITitrationBarrelRecipe> {
    @Nullable
    protected final List<EmiStack> displayedStacks;

    public TitrationBarrelEmiRecipeGated(ITitrationBarrelRecipe recipe) {
        super(PastelEmiRecipeCategories.TITRATION_BARREL, recipe, 136, 50);
        this.inputs = new ArrayList();
        if (!recipe.getFluidInput().isEmpty()) {
            this.inputs.add(FluidIngredientEmi.into(recipe.getFluidInput()));
        }
        this.inputs.addAll(recipe.getIngredientStacks().stream().map(s -> EmiIngredient.of(s.getItems().map(EmiStack::of).toList())).toList());
        this.displayedStacks = TitrationBarrelEmiRecipeGated.buildFermentationOutputVariations(recipe);
    }

    private static List<EmiStack> buildFermentationOutputVariations(ITitrationBarrelRecipe recipe) {
        TitrationBarrelRecipe titrationBarrelRecipe;
        if (recipe instanceof TitrationBarrelRecipe && (titrationBarrelRecipe = (TitrationBarrelRecipe)recipe).getFermentationData() != null) {
            return titrationBarrelRecipe.getOutputVariations(TitrationBarrelRecipe.FERMENTATION_DURATION_DISPLAY_TIME_MULTIPLIERS).stream().map(EmiStack::of).toList();
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addUnlockedWidgets(WidgetHolder widgets) {
        int startX = Math.max(10, 40 - this.inputs.size() * 10);
        int startY = this.inputs.size() > 3 ? 0 : 10;
        for (int i = 0; i < this.inputs.size(); ++i) {
            int x = startX + i % 3 * 20;
            int y = startY + i / 3 * 20;
            widgets.addSlot((EmiIngredient)this.inputs.get(i), x, y);
        }
        EmiStack tapping = EmiStack.of((ItemLike)((ITitrationBarrelRecipe)this.recipe).getTappingItem());
        if (tapping.isEmpty()) {
            widgets.addFillingArrow(70, 10, ((ITitrationBarrelRecipe)this.recipe).getMinFermentationTimeHours() * 20 * 50);
        } else {
            widgets.addFillingArrow(70, 2, ((ITitrationBarrelRecipe)this.recipe).getMinFermentationTimeHours() * 20 * 50);
            widgets.addSlot((EmiIngredient)tapping, 74, 20);
        }
        if (this.displayedStacks == null) {
            widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 100, 5).large(true).recipeContext((EmiRecipe)this);
        } else if (Minecraft.getInstance().level != null) {
            widgets.addGeneratedSlot(random -> (EmiIngredient)this.displayedStacks.get((int)(Minecraft.getInstance().level.getGameTime() % (long)this.displayedStacks.size())), 1, 100, 5).large(true).recipeContext((EmiRecipe)this);
        }
        MutableComponent text = TitrationBarrelRecipe.getDurationText(((ITitrationBarrelRecipe)this.recipe).getMinFermentationTimeHours(), ((ITitrationBarrelRecipe)this.recipe).getFermentationData());
        widgets.addText((Component)text, this.width / 2, 40, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }
}

