/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.crystallarieum.CrystallarieumBlock;
import earth.terrarium.pastel.compat.emi.GatedSpectrumEmiRecipe;
import earth.terrarium.pastel.compat.emi.PastelEmiRecipeCategories;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumCatalyst;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class CrystallarieumEmiRecipeGated
extends GatedSpectrumEmiRecipe<CrystallarieumRecipe> {
    private static final ResourceLocation BACKGROUND_TEXTURE = PastelCommon.locate("textures/gui/modonomicon/crystallarieum.png");

    public CrystallarieumEmiRecipeGated(CrystallarieumRecipe recipe) {
        super(PastelEmiRecipeCategories.CRYSTALLARIEUM, recipe, 124, 100);
        this.inputs = List.of(EmiIngredient.of((Ingredient)recipe.getIngredientStack()), EmiStack.of((ItemLike)recipe.getGrowthStages().getFirst().getBlock()));
        this.outputs = Stream.concat(Stream.concat(Stream.of(recipe.getResultItem((HolderLookup.Provider)this.getRegistryManager())), recipe.getAdditionalResults().stream()).map(EmiStack::of), recipe.getGrowthStages().stream().map(s -> EmiStack.of((ItemLike)s.getBlock())).filter(s -> !s.isEmpty())).toList();
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 0, 0);
        widgets.addSlot((EmiIngredient)EmiStack.of((Fluid)((CrystallarieumRecipe)this.recipe).getFluidMedium().getFluid()), 0, 18);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)((CrystallarieumBlock)PastelBlocks.CRYSTALLARIEUM.get()).asStackWithColor(((CrystallarieumRecipe)this.recipe).getInkColor())), 20, 18).drawBack(false);
        widgets.addFillingArrow(40, 9, ((CrystallarieumRecipe)this.recipe).getSecondsPerGrowthStage() * 1000);
        List<EmiStack> states = ((CrystallarieumRecipe)this.recipe).getGrowthStages().stream().map(s -> EmiStack.of((ItemLike)s.getBlock())).toList();
        Iterator<EmiStack> it = states.iterator();
        widgets.addSlot((EmiIngredient)it.next(), 20, 0);
        int x = 66;
        while (it.hasNext()) {
            widgets.addSlot((EmiIngredient)it.next(), x, 8).recipeContext((EmiRecipe)this);
            x += 20;
        }
        widgets.addText((Component)Component.translatable((String)"container.pastel.rei.crystallarieum.catalyst"), 0, 42, 0x3F3F3F, false);
        widgets.addText((Component)Component.translatable((String)"container.pastel.rei.crystallarieum.accelerator"), 0, 58, 0x3F3F3F, false);
        widgets.addText((Component)Component.translatable((String)"container.pastel.rei.crystallarieum.ink_consumption"), 0, 68, 0x3F3F3F, false);
        widgets.addText((Component)Component.translatable((String)"container.pastel.rei.crystallarieum.used_up"), 0, 78, 0x3F3F3F, false);
        List<CrystallarieumCatalyst> catalysts = ((CrystallarieumRecipe)this.recipe).getCatalysts();
        for (int i = 0; i < catalysts.size(); ++i) {
            CrystallarieumCatalyst catalyst = catalysts.get(i);
            int xOff = 46 + 18 * i;
            widgets.addSlot(EmiIngredient.of((Ingredient)catalyst.ingredient()), xOff, 38);
            int offset = 0;
            float accel = catalyst.growthAccelerationMod();
            if ((double)accel > 0.2) {
                if (accel >= 5.0f) {
                    offset = 28;
                } else if (accel > 1.0f) {
                    offset = 21;
                } else if (accel == 1.0f) {
                    offset = 14;
                } else if (accel < 1.0f) {
                    offset = 7;
                }
            }
            widgets.addTexture(BACKGROUND_TEXTURE, xOff + 5, 59, 7, 7, 70 + offset, 0, 7, 7, 128, 128);
            float drain = catalyst.inkConsumptionMod();
            if (drain >= 5.0f) {
                offset = 0;
            } else if (drain > 1.0f) {
                offset = 7;
            } else if (drain == 1.0f) {
                offset = 14;
            } else if ((double)drain < 0.2) {
                offset = 28;
            } else if (drain < 1.0f) {
                offset = 21;
            }
            widgets.addTexture(BACKGROUND_TEXTURE, xOff + 5, 69, 7, 7, 70 + offset, 7, 7, 7, 128, 128);
            float chance = catalyst.consumeChancePerSecond();
            if ((double)chance >= 0.25) {
                offset = 0;
            } else if ((double)chance < 1.0E-4) {
                offset = 28;
            } else if ((double)chance <= 0.02) {
                offset = 21;
            } else if ((double)chance < 0.05) {
                offset = 14;
            } else if ((double)chance < 0.25) {
                offset = 7;
            }
            widgets.addTexture(BACKGROUND_TEXTURE, xOff + 5, 79, 7, 7, 70 + offset, 14, 7, 7, 128, 128);
        }
        if (((CrystallarieumRecipe)this.recipe).growsWithoutCatalyst()) {
            widgets.addText((Component)Component.translatable((String)"container.pastel.rei.crystallarieum.crafting_time_per_stage_seconds_catalyst_optional", (Object[])new Object[]{((CrystallarieumRecipe)this.recipe).getSecondsPerGrowthStage()}), 0, 90, 0x3F3F3F, false);
        } else {
            widgets.addText((Component)Component.translatable((String)"container.pastel.rei.crystallarieum.crafting_time_per_stage_seconds", (Object[])new Object[]{((CrystallarieumRecipe)this.recipe).getSecondsPerGrowthStage()}), 0, 90, 0x3F3F3F, false);
        }
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }
}

