/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.compat.emi.GatedSpectrumEmiRecipe;
import earth.terrarium.pastel.compat.emi.PastelEmiRecipeCategories;
import earth.terrarium.pastel.recipe.anvil_crushing.AnvilCrushingRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AnvilCrushingEmiRecipeGated
extends GatedSpectrumEmiRecipe<AnvilCrushingRecipe> {
    private static final ResourceLocation WALL_TEXTURE = PastelCommon.locate("textures/gui/container/anvil_crushing.png");

    public AnvilCrushingEmiRecipeGated(AnvilCrushingRecipe recipe) {
        super(PastelEmiRecipeCategories.ANVIL_CRUSHING, recipe, 116, 64);
        this.inputs = recipe.getIngredients().stream().map(EmiIngredient::of).toList();
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 21, 30);
        widgets.addTexture(WALL_TEXTURE, 0, 0, 16, 48, 0, 0);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)Items.ANVIL), 21, 10).drawBack(false);
        widgets.addTexture(WALL_TEXTURE, 22, 1, 16, 16, 16, 1);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 50, 16);
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 90, 11).large(true).recipeContext((EmiRecipe)this);
        widgets.addText((Component)Component.translatable((String)"container.pastel.rei.anvil_crushing.plus_xp", (Object[])new Object[]{Float.valueOf(((AnvilCrushingRecipe)this.recipe).getExperience())}), this.width, 40, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.END);
        widgets.addText(this.getForceText(), this.width / 2, 54, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }

    public Component getForceText() {
        if (((AnvilCrushingRecipe)this.recipe).getCrushedItemsPerPointOfDamage() >= 1.0f) {
            return Component.translatable((String)"container.pastel.rei.anvil_crushing.low_force_required");
        }
        if ((double)((AnvilCrushingRecipe)this.recipe).getCrushedItemsPerPointOfDamage() >= 0.5) {
            return Component.translatable((String)"container.pastel.rei.anvil_crushing.medium_force_required");
        }
        return Component.translatable((String)"container.pastel.rei.anvil_crushing.high_force_required");
    }
}

