/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi;

import com.cmdpro.databank.DatabankUtils;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public abstract class PastelEmiRecipe
implements EmiRecipe {
    public static final Component HIDDEN_LINE_1 = Component.translatable((String)"container.pastel.rei.pedestal_crafting.recipe_not_unlocked_line_1");
    public static final Component HIDDEN_LINE_2 = Component.translatable((String)"container.pastel.rei.pedestal_crafting.recipe_not_unlocked_line_2");
    public final EmiRecipeCategory category;
    public final ResourceLocation recipeTypeUnlockIdentifier;
    public final ResourceLocation recipeIdentifier;
    public final int width;
    public final int height;
    public List<EmiIngredient> inputs = List.of();
    public List<EmiStack> outputs = List.of();

    public PastelEmiRecipe(EmiRecipeCategory category, ResourceLocation recipeTypeUnlockIdentifier, ResourceLocation recipeIdentifier, int width, int height) {
        this.category = category;
        this.recipeTypeUnlockIdentifier = recipeTypeUnlockIdentifier;
        this.recipeIdentifier = recipeIdentifier;
        this.width = width;
        this.height = height;
    }

    public RegistryAccess getRegistryManager() {
        return Minecraft.getInstance().level.registryAccess();
    }

    public boolean isUnlocked() {
        return this.recipeTypeUnlockIdentifier == null || this.hasAdvancement(this.recipeTypeUnlockIdentifier);
    }

    public boolean hasAdvancement(ResourceLocation advancement) {
        Minecraft client = Minecraft.getInstance();
        return DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)advancement);
    }

    protected static Component getCraftingTimeText(int time) {
        if (time == 20) {
            return Component.translatable((String)"container.pastel.rei.crafting_time_one_second", (Object[])new Object[]{1});
        }
        return Component.translatable((String)"container.pastel.rei.crafting_time", (Object[])new Object[]{time / 20});
    }

    protected static Component getCraftingTimeText(int time, float experience) {
        if (time == 20) {
            return Component.translatable((String)"container.pastel.rei.crafting_time_one_second_and_xp", (Object[])new Object[]{1, Float.valueOf(experience)});
        }
        return Component.translatable((String)"container.pastel.rei.crafting_time_and_xp", (Object[])new Object[]{time / 20, Float.valueOf(experience)});
    }

    public abstract void addUnlockedWidgets(WidgetHolder var1);

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipeIdentifier;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        if (this.isUnlocked()) {
            return this.width;
        }
        Minecraft client = Minecraft.getInstance();
        return Math.max(client.font.width((FormattedText)HIDDEN_LINE_1), client.font.width((FormattedText)HIDDEN_LINE_2)) + 8;
    }

    public int getDisplayHeight() {
        if (this.isUnlocked()) {
            return this.height;
        }
        return 32;
    }

    public void addWidgets(WidgetHolder widgets) {
        if (!this.isUnlocked()) {
            widgets.addText(HIDDEN_LINE_1, this.getDisplayWidth() / 2, this.getDisplayHeight() / 2 - 8, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
            widgets.addText(HIDDEN_LINE_2, this.getDisplayWidth() / 2, this.getDisplayHeight() / 2 + 2, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
        } else {
            this.addUnlockedWidgets(widgets);
        }
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree() && this.isUnlocked();
    }
}

