/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.config.FluidUnit;
import dev.emi.emi.runtime.EmiReloadLog;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.FilterConfigurable;
import earth.terrarium.pastel.blocks.idols.FirestarterIdolBlock;
import earth.terrarium.pastel.blocks.idols.FreezingIdolBlock;
import earth.terrarium.pastel.compat.emi.PastelEmiRecipeCategories;
import earth.terrarium.pastel.compat.emi.handlers.CinderhearthRecipeHandler;
import earth.terrarium.pastel.compat.emi.handlers.CraftingTabletRecipeHandler;
import earth.terrarium.pastel.compat.emi.handlers.PedestalRecipeHandler;
import earth.terrarium.pastel.compat.emi.handlers.PotionWorkshopRecipeHandler;
import earth.terrarium.pastel.compat.emi.recipes.AnvilCrushingEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.BlockToBlockWithChanceEmiRecipe;
import earth.terrarium.pastel.compat.emi.recipes.CinderhearthEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.CrystallarieumEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.EnchanterEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.EnchantmentUpgradeEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.FluidConvertingEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.FusionShrineEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.InkConvertingEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.PastelWorldInteractionRecipe;
import earth.terrarium.pastel.compat.emi.recipes.PedestalCraftingEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.PotionWorkshopEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.PotionWorkshopReactingEmiRecipe;
import earth.terrarium.pastel.compat.emi.recipes.PrimordialFireBurningEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.SpiritInstillingEmiRecipeGated;
import earth.terrarium.pastel.compat.emi.recipes.TitrationBarrelEmiRecipeGated;
import earth.terrarium.pastel.data_loaders.NaturesStaffConversionDataLoader;
import earth.terrarium.pastel.inventories.BlackHoleChestScreen;
import earth.terrarium.pastel.inventories.FilteringScreen;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.slots.ShadowSlot;
import earth.terrarium.pastel.recipe.enchanter.EnchanterCraftingRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchantmentUpgradeRecipe;
import earth.terrarium.pastel.recipe.fluid_converting.DragonrotConvertingRecipe;
import earth.terrarium.pastel.recipe.fluid_converting.FluidConvertingRecipe;
import earth.terrarium.pastel.recipe.fluid_converting.HumusConvertingRecipe;
import earth.terrarium.pastel.recipe.fluid_converting.LiquidCrystalConvertingRecipe;
import earth.terrarium.pastel.recipe.fluid_converting.MidnightSolutionConvertingRecipe;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopRecipe;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelFluids;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@EmiEntrypoint
public class PastelEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        this.registerCategories(registry);
        this.registerRecipes(registry);
        this.registerRecipeHandlers(registry);
        this.registerDragDropHandlers(registry);
    }

    public void registerDragDropHandlers(EmiRegistry registry) {
        EmiDragDropHandler.SlotBased handlerOne = new EmiDragDropHandler.SlotBased((_ignored, slot) -> slot instanceof ShadowSlot && slot.container instanceof FilterConfigurable.FilterInventory, (screen, slot, ingredient) -> {
            if (ingredient instanceof ItemEmiStack) {
                ItemEmiStack stack = (ItemEmiStack)ingredient;
                ((FilterConfigurable.FilterInventory)slot.container).getClicker().clickShadowSlot(screen.getMenu().containerId, (Slot)slot, stack.getItemStack());
            }
        });
        this.registerDragDropHandler(registry, (Class<? extends AbstractContainerScreen<?>>)BlackHoleChestScreen.class, (EmiDragDropHandler<AbstractContainerScreen<?>>)handlerOne);
        this.registerDragDropHandler(registry, (Class<? extends AbstractContainerScreen<?>>)FilteringScreen.class, (EmiDragDropHandler<AbstractContainerScreen<?>>)handlerOne);
    }

    private void registerDragDropHandler(EmiRegistry registry, Class<? extends AbstractContainerScreen<?>> clazz, EmiDragDropHandler<AbstractContainerScreen<?>> handler) {
        registry.addDragDropHandler(clazz, handler);
    }

    public void registerCategories(EmiRegistry registry) {
        registry.addCategory(PastelEmiRecipeCategories.PEDESTAL_CRAFTING);
        registry.addCategory(PastelEmiRecipeCategories.ANVIL_CRUSHING);
        registry.addCategory(PastelEmiRecipeCategories.FUSION_SHRINE);
        registry.addCategory(PastelEmiRecipeCategories.NATURES_STAFF);
        registry.addCategory(PastelEmiRecipeCategories.ENCHANTER);
        registry.addCategory(PastelEmiRecipeCategories.ENCHANTMENT_UPGRADE);
        registry.addCategory(PastelEmiRecipeCategories.POTION_WORKSHOP_BREWING);
        registry.addCategory(PastelEmiRecipeCategories.POTION_WORKSHOP_CRAFTING);
        registry.addCategory(PastelEmiRecipeCategories.POTION_WORKSHOP_REACTING);
        registry.addCategory(PastelEmiRecipeCategories.SPIRIT_INSTILLER);
        registry.addCategory(PastelEmiRecipeCategories.HUMUS_CONVERTING);
        registry.addCategory(PastelEmiRecipeCategories.LIQUID_CRYSTAL_CONVERTING);
        registry.addCategory(PastelEmiRecipeCategories.MIDNIGHT_SOLUTION_CONVERTING);
        registry.addCategory(PastelEmiRecipeCategories.DRAGONROT_CONVERTING);
        registry.addCategory(PastelEmiRecipeCategories.HEATING);
        registry.addCategory(PastelEmiRecipeCategories.FREEZING);
        registry.addCategory(PastelEmiRecipeCategories.INK_CONVERTING);
        registry.addCategory(PastelEmiRecipeCategories.CRYSTALLARIEUM);
        registry.addCategory(PastelEmiRecipeCategories.CINDERHEARTH);
        registry.addCategory(PastelEmiRecipeCategories.TITRATION_BARREL);
        registry.addCategory(PastelEmiRecipeCategories.PRIMORDIAL_FIRE_BURNING);
        EmiIngredient pedestals = EmiIngredient.of(List.of(EmiStack.of((ItemLike)((ItemLike)PastelBlocks.PEDESTAL_BASIC_TOPAZ.get())), EmiStack.of((ItemLike)((ItemLike)PastelBlocks.PEDESTAL_BASIC_AMETHYST.get())), EmiStack.of((ItemLike)((ItemLike)PastelBlocks.PEDESTAL_BASIC_CITRINE.get())), EmiStack.of((ItemLike)((ItemLike)PastelBlocks.PEDESTAL_ALL_BASIC.get())), EmiStack.of((ItemLike)((ItemLike)PastelBlocks.PEDESTAL_ONYX.get())), EmiStack.of((ItemLike)((ItemLike)PastelBlocks.PEDESTAL_MOONSTONE.get()))));
        registry.addWorkstation(PastelEmiRecipeCategories.PEDESTAL_CRAFTING, pedestals);
        if (PastelCommon.CONFIG.canPedestalCraftVanillaRecipes()) {
            registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, pedestals);
        }
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelItems.CRAFTING_TABLET.get())));
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.FABRICATION_CHEST.get())));
        registry.addWorkstation(VanillaEmiRecipeCategories.BLASTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.CINDERHEARTH.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.ANVIL_CRUSHING, (EmiIngredient)EmiStack.of((ItemLike)Blocks.ANVIL));
        registry.addWorkstation(PastelEmiRecipeCategories.ANVIL_CRUSHING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.BEDROCK_ANVIL.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.ANVIL_CRUSHING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.STRATINE_FLOATBLOCK.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.ANVIL_CRUSHING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.PALTAERIA_FLOATBLOCK.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.FUSION_SHRINE, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.FUSION_SHRINE_BASALT.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.FUSION_SHRINE, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.FUSION_SHRINE_CALCITE.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.NATURES_STAFF, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelItems.NATURES_STAFF.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.HEATING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.BLAZE_IDOL.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.FREEZING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.POLAR_BEAR_IDOL.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.ENCHANTER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.ENCHANTER.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.ENCHANTMENT_UPGRADE, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.ENCHANTER.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.HUMUS_CONVERTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelItems.HUMUS_BUCKET.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.LIQUID_CRYSTAL_CONVERTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelItems.LIQUID_CRYSTAL_BUCKET.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.MIDNIGHT_SOLUTION_CONVERTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelItems.MIDNIGHT_SOLUTION_BUCKET.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.DRAGONROT_CONVERTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelItems.DRAGONROT_BUCKET.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.SPIRIT_INSTILLER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.SPIRIT_INSTILLER.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.INK_CONVERTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.COLOR_PICKER.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.CRYSTALLARIEUM, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.CRYSTALLARIEUM.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.POTION_WORKSHOP_BREWING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.POTION_WORKSHOP.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.POTION_WORKSHOP_CRAFTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.POTION_WORKSHOP.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.POTION_WORKSHOP_REACTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.POTION_WORKSHOP.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.CINDERHEARTH, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.CINDERHEARTH.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.TITRATION_BARREL, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.TITRATION_BARREL.get())));
        registry.addWorkstation(PastelEmiRecipeCategories.PRIMORDIAL_FIRE_BURNING, EmiIngredient.of(List.of(EmiStack.of((ItemLike)((ItemLike)PastelItems.DOOMBLOOM_SEED.get())), EmiStack.of((ItemLike)((ItemLike)PastelItems.PRIMORDIAL_LIGHTER.get())), EmiStack.of((ItemLike)((ItemLike)PastelBlocks.INCANDESCENT_AMALGAM.get())), EmiStack.of((ItemLike)((ItemLike)PastelItems.PIPE_BOMB.get())))));
    }

    public void registerRecipes(EmiRegistry registry) {
        this.addAll(registry, PastelRecipeTypes.ANVIL_CRUSHING, AnvilCrushingEmiRecipeGated::new);
        this.addAll(registry, PastelRecipeTypes.PEDESTAL, PedestalCraftingEmiRecipeGated::new);
        this.addAll(registry, PastelRecipeTypes.FUSION_SHRINE, FusionShrineEmiRecipeGated::new);
        this.addAll(registry, PastelRecipeTypes.ENCHANTER, r -> new EnchanterEmiRecipeGated(PastelEmiRecipeCategories.ENCHANTER, (EnchanterCraftingRecipe)r));
        this.addAll(registry, PastelRecipeTypes.ENCHANTMENT_UPGRADE, r -> new EnchantmentUpgradeEmiRecipeGated(PastelEmiRecipeCategories.ENCHANTMENT_UPGRADE, (EnchantmentUpgradeRecipe)r));
        this.addAll(registry, PastelRecipeTypes.POTION_WORKSHOP_BREWING, r -> new PotionWorkshopEmiRecipeGated(PastelEmiRecipeCategories.POTION_WORKSHOP_BREWING, (PotionWorkshopRecipe)r));
        this.addAll(registry, PastelRecipeTypes.POTION_WORKSHOP_CRAFTING, r -> new PotionWorkshopEmiRecipeGated(PastelEmiRecipeCategories.POTION_WORKSHOP_CRAFTING, (PotionWorkshopRecipe)r));
        this.addAll(registry, PastelRecipeTypes.POTION_WORKSHOP_REACTING, PotionWorkshopReactingEmiRecipe::new);
        this.addAll(registry, PastelRecipeTypes.SPIRIT_INSTILLING, SpiritInstillingEmiRecipeGated::new);
        this.addAll(registry, PastelRecipeTypes.HUMUS_CONVERTING, r -> new FluidConvertingEmiRecipeGated(PastelEmiRecipeCategories.HUMUS_CONVERTING, (FluidConvertingRecipe)r));
        this.addAll(registry, PastelRecipeTypes.LIQUID_CRYSTAL_CONVERTING, r -> new FluidConvertingEmiRecipeGated(PastelEmiRecipeCategories.LIQUID_CRYSTAL_CONVERTING, (FluidConvertingRecipe)r));
        this.addAll(registry, PastelRecipeTypes.MIDNIGHT_SOLUTION_CONVERTING, r -> new FluidConvertingEmiRecipeGated(PastelEmiRecipeCategories.MIDNIGHT_SOLUTION_CONVERTING, (FluidConvertingRecipe)r));
        this.addAll(registry, PastelRecipeTypes.DRAGONROT_CONVERTING, r -> new FluidConvertingEmiRecipeGated(PastelEmiRecipeCategories.DRAGONROT_CONVERTING, (FluidConvertingRecipe)r));
        this.addAll(registry, PastelRecipeTypes.INK_CONVERTING, InkConvertingEmiRecipeGated::new);
        this.addAll(registry, PastelRecipeTypes.CRYSTALLARIEUM, CrystallarieumEmiRecipeGated::new);
        this.addAll(registry, PastelRecipeTypes.CINDERHEARTH, CinderhearthEmiRecipeGated::new);
        this.addAll(registry, PastelRecipeTypes.TITRATION_BARREL, TitrationBarrelEmiRecipeGated::new);
        this.addAll(registry, PastelRecipeTypes.PRIMORDIAL_FIRE_BURNING, PrimordialFireBurningEmiRecipeGated::new);
        FreezingIdolBlock.FREEZING_STATE_MAP.forEach((key, value) -> {
            EmiStack in = EmiStack.of((ItemLike)key.getBlock());
            EmiStack out = EmiStack.of((ItemLike)((BlockState)value.getA()).getBlock()).setChance(((Float)value.getB()).floatValue());
            if (in.isEmpty() || out.isEmpty()) {
                return;
            }
            ResourceLocation id = PastelEmiPlugin.syntheticId("freezing", key.getBlock());
            registry.addRecipe((EmiRecipe)new BlockToBlockWithChanceEmiRecipe(PastelEmiRecipeCategories.FREEZING, id, (EmiIngredient)in, out, PastelAdvancements.Unlocks.Blocks.IDOLS));
        });
        FreezingIdolBlock.FREEZING_MAP.forEach((key, value) -> {
            EmiStack in = EmiStack.of((ItemLike)key);
            EmiStack out = EmiStack.of((ItemLike)((BlockState)value.getA()).getBlock()).setChance(((Float)value.getB()).floatValue());
            if (in.isEmpty() || out.isEmpty()) {
                return;
            }
            ResourceLocation id = PastelEmiPlugin.syntheticId("freezing", key);
            registry.addRecipe((EmiRecipe)new BlockToBlockWithChanceEmiRecipe(PastelEmiRecipeCategories.FREEZING, id, (EmiIngredient)in, out, PastelAdvancements.Unlocks.Blocks.IDOLS));
        });
        FirestarterIdolBlock.BURNING_MAP.forEach((key, value) -> {
            EmiStack in = EmiStack.of((ItemLike)key);
            EmiStack out = EmiStack.of((ItemLike)((BlockState)value.getA()).getBlock()).setChance(((Float)value.getB()).floatValue());
            if (in.isEmpty() || out.isEmpty()) {
                return;
            }
            ResourceLocation id = PastelEmiPlugin.syntheticId("heating", key);
            registry.addRecipe((EmiRecipe)new BlockToBlockWithChanceEmiRecipe(PastelEmiRecipeCategories.HEATING, id, (EmiIngredient)in, out, PastelAdvancements.Unlocks.Blocks.IDOLS));
        });
        NaturesStaffConversionDataLoader.CONVERSIONS.forEach((key, value) -> {
            EmiStack in = EmiStack.of((ItemLike)key);
            EmiStack out = EmiStack.of((ItemLike)value.getBlock());
            if (in.isEmpty() || out.isEmpty()) {
                return;
            }
            ResourceLocation id = PastelEmiPlugin.syntheticId("natures_staff", key);
            registry.addRecipe((EmiRecipe)new BlockToBlockWithChanceEmiRecipe(PastelEmiRecipeCategories.NATURES_STAFF, id, (EmiIngredient)in, out, PastelAdvancements.Unlocks.Items.NATURES_STAFF));
        });
        EmiStack water = EmiStack.of((Fluid)Fluids.WATER, (long)FluidUnit.BUCKET);
        EmiStack lava = EmiStack.of((Fluid)Fluids.LAVA, (long)FluidUnit.BUCKET);
        EmiStack dragonrot = EmiStack.of((Fluid)((Fluid)PastelFluids.DRAGONROT.get()), (long)FluidUnit.BUCKET);
        EmiStack liquidCrystal = EmiStack.of((Fluid)((Fluid)PastelFluids.LIQUID_CRYSTAL.get()), (long)FluidUnit.BUCKET);
        EmiStack midnightSolution = EmiStack.of((Fluid)((Fluid)PastelFluids.MIDNIGHT_SOLUTION.get()), (long)FluidUnit.BUCKET);
        EmiStack mud = EmiStack.of((Fluid)((Fluid)PastelFluids.HUMUS.get()), (long)FluidUnit.BUCKET);
        EmiStack waterCatalyst = water.copy().setRemainder(water);
        EmiStack lavaCatalyst = lava.copy().setRemainder(lava);
        EmiStack dragonrotCatalyst = dragonrot.copy().setRemainder(dragonrot);
        EmiStack liquidCrystalCatalyst = liquidCrystal.copy().setRemainder(liquidCrystal);
        EmiStack midnightSolutionCatalyst = midnightSolution.copy().setRemainder(midnightSolution);
        EmiStack mudCatalyst = mud.copy().setRemainder(mud);
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", (Block)PastelBlocks.SLUSH.get())).leftInput((EmiIngredient)dragonrotCatalyst).rightInput((EmiIngredient)waterCatalyst, false).output(EmiStack.of((ItemLike)((ItemLike)PastelBlocks.SLUSH.get()))).requiredAdvancement(DragonrotConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", Blocks.BLACKSTONE)).leftInput((EmiIngredient)dragonrotCatalyst).rightInput((EmiIngredient)lavaCatalyst, false).output(EmiStack.of((ItemLike)Blocks.BLACKSTONE)).requiredAdvancement(DragonrotConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", Blocks.COARSE_DIRT)).leftInput((EmiIngredient)dragonrotCatalyst).rightInput((EmiIngredient)mudCatalyst, false).output(EmiStack.of((ItemLike)Blocks.COARSE_DIRT)).requiredAdvancement(DragonrotConvertingRecipe.UNLOCK_IDENTIFIER).requiredAdvancement(HumusConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", (Block)PastelBlocks.FLAYED_EARTH.get())).leftInput((EmiIngredient)dragonrotCatalyst).rightInput((EmiIngredient)liquidCrystalCatalyst, false).output(EmiStack.of((ItemLike)((ItemLike)PastelBlocks.FLAYED_EARTH.get()))).requiredAdvancement(DragonrotConvertingRecipe.UNLOCK_IDENTIFIER).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", (Block)PastelBlocks.HORNSLAKE.get())).leftInput((EmiIngredient)dragonrotCatalyst).rightInput((EmiIngredient)midnightSolutionCatalyst, false).output(EmiStack.of((ItemLike)((ItemLike)PastelBlocks.HORNSLAKE.get()))).requiredAdvancement(DragonrotConvertingRecipe.UNLOCK_IDENTIFIER).requiredAdvancement(MidnightSolutionConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", (Block)PastelBlocks.FROSTBITE_CRYSTAL.get())).leftInput((EmiIngredient)liquidCrystal).rightInput((EmiIngredient)waterCatalyst, false).output(EmiStack.of((ItemLike)((ItemLike)PastelBlocks.FROSTBITE_CRYSTAL.get()))).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", Blocks.CALCITE)).leftInput((EmiIngredient)liquidCrystalCatalyst).rightInput((EmiIngredient)waterCatalyst, false).output(EmiStack.of((ItemLike)Blocks.CALCITE)).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", (Block)PastelBlocks.BLAZING_CRYSTAL.get())).leftInput((EmiIngredient)liquidCrystal).rightInput((EmiIngredient)lavaCatalyst, false).output(EmiStack.of((ItemLike)((ItemLike)PastelBlocks.BLAZING_CRYSTAL.get()))).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", Blocks.COBBLED_DEEPSLATE)).leftInput((EmiIngredient)liquidCrystalCatalyst).rightInput((EmiIngredient)lavaCatalyst, false).output(EmiStack.of((ItemLike)Blocks.COBBLED_DEEPSLATE)).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", Blocks.CLAY)).leftInput((EmiIngredient)liquidCrystalCatalyst).rightInput((EmiIngredient)mudCatalyst, false).output(EmiStack.of((ItemLike)Blocks.CLAY)).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).requiredAdvancement(HumusConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", Blocks.TERRACOTTA)).leftInput((EmiIngredient)midnightSolutionCatalyst).rightInput((EmiIngredient)lavaCatalyst, false).output(EmiStack.of((ItemLike)Blocks.TERRACOTTA)).requiredAdvancement(MidnightSolutionConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", Blocks.DIRT)).leftInput((EmiIngredient)mudCatalyst).rightInput((EmiIngredient)waterCatalyst, false).output(EmiStack.of((ItemLike)Blocks.DIRT)).requiredAdvancement(HumusConvertingRecipe.UNLOCK_IDENTIFIER).build());
        PastelEmiPlugin.addRecipeSafe(registry, () -> PastelWorldInteractionRecipe.customBuilder().id(PastelEmiPlugin.syntheticId("world/fluid_interaction", Blocks.MUD)).leftInput((EmiIngredient)mudCatalyst).rightInput((EmiIngredient)lavaCatalyst, false).output(EmiStack.of((ItemLike)Blocks.MUD)).requiredAdvancement(HumusConvertingRecipe.UNLOCK_IDENTIFIER).build());
    }

    public void registerRecipeHandlers(EmiRegistry registry) {
        registry.addRecipeHandler(PastelScreenHandlerTypes.PEDESTAL, (EmiRecipeHandler)new PedestalRecipeHandler());
        registry.addRecipeHandler(PastelScreenHandlerTypes.CRAFTING_TABLET, (EmiRecipeHandler)new CraftingTabletRecipeHandler());
        registry.addRecipeHandler(PastelScreenHandlerTypes.CINDERHEARTH, (EmiRecipeHandler)new CinderhearthRecipeHandler());
        registry.addRecipeHandler(PastelScreenHandlerTypes.POTION_WORKSHOP, (EmiRecipeHandler)new PotionWorkshopRecipeHandler());
    }

    public static ResourceLocation syntheticId(String type, Block block) {
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        return ResourceLocation.parse((String)("pastel:/" + type + "/" + blockId.getNamespace() + "/" + blockId.getPath()));
    }

    public <C extends RecipeInput, T extends Recipe<C>> void addAll(EmiRegistry registry, RecipeType<T> type, Function<T, EmiRecipe> constructor) {
        for (RecipeHolder entry : registry.getRecipeManager().getAllRecipesFor(type)) {
            Recipe recipe = entry.value();
            registry.addRecipe(constructor.apply(recipe));
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn((String)"Exception thrown when parsing EMI recipe (no ID available)");
            EmiReloadLog.error((Throwable)e);
        }
    }
}

