/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.compat.REI.PastelDisplay;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.REIHelper;
import earth.terrarium.pastel.helpers.render.LoreHelper;
import earth.terrarium.pastel.recipe.spirit_instiller.SpiritInstillerRecipe;
import earth.terrarium.pastel.recipe.spirit_instiller.dynamic.spawner_manipulation.SpawnerChangeRecipe;
import java.util.Collections;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class SpiritInstillingDisplay
extends PastelDisplay {
    protected final float experience;
    protected final int craftingTime;

    public SpiritInstillingDisplay(@NotNull RecipeHolder<SpiritInstillerRecipe> recipe) {
        super(recipe, REIHelper.toEntryIngredients(((SpiritInstillerRecipe)recipe.value()).getIngredientStacks()), Collections.singletonList(SpiritInstillingDisplay.buildOutput((SpiritInstillerRecipe)recipe.value())));
        this.experience = ((SpiritInstillerRecipe)recipe.value()).getExperience();
        this.craftingTime = ((SpiritInstillerRecipe)recipe.value()).getCraftingTime();
    }

    public static EntryIngredient buildOutput(SpiritInstillerRecipe recipe) {
        if (recipe instanceof SpawnerChangeRecipe) {
            SpawnerChangeRecipe spawnerChangeRecipe = (SpawnerChangeRecipe)recipe;
            ItemStack outputStack = recipe.getResultItem((HolderLookup.Provider)BasicDisplay.registryAccess());
            LoreHelper.setLore(outputStack, spawnerChangeRecipe.getOutputLoreText());
            return EntryIngredients.of((ItemStack)outputStack);
        }
        return EntryIngredients.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)BasicDisplay.registryAccess()));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return PastelPlugins.SPIRIT_INSTILLER;
    }

    @Override
    public boolean isUnlocked() {
        Minecraft client = Minecraft.getInstance();
        return DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)SpiritInstillerRecipe.UNLOCK_IDENTIFIER) && super.isUnlocked();
    }
}

