/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.util.FormattedCharSequence;

public class ScrollableTextWidget
extends WidgetWithBounds {
    private final Rectangle bounds;
    private final List<FormattedCharSequence> texts;
    private final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            Rectangle bounds = ScrollableTextWidget.this.getBounds();
            return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
        }

        public int getMaxScrollHeight() {
            int i = 2;
            for (FormattedCharSequence entry : ScrollableTextWidget.this.texts) {
                int n;
                if (entry == null) {
                    n = 4;
                } else {
                    Objects.requireNonNull(ScrollableTextWidget.this.font);
                    n = 9;
                }
                i += n;
            }
            return i;
        }
    };

    public ScrollableTextWidget(Rectangle bounds, List<FormattedCharSequence> texts) {
        this.bounds = Objects.requireNonNull(bounds);
        this.texts = texts;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -verticalAmount, true);
            return true;
        }
        return false;
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.scrolling.updatePosition(delta);
        Rectangle innerBounds = this.scrolling.getScissorBounds();
        ScissorsHandler.INSTANCE.scissor(innerBounds);
        int currentY = -this.scrolling.scrollAmountInt() + innerBounds.y;
        for (FormattedCharSequence text : this.texts) {
            int n;
            if (text != null) {
                Objects.requireNonNull(this.font);
                if (currentY + 9 >= innerBounds.y && currentY <= innerBounds.getMaxY()) {
                    drawContext.drawString(this.font, text, innerBounds.x + 2, currentY + 2, REIRuntime.getInstance().isDarkThemeEnabled() ? -4473925 : -16185079, false);
                }
            }
            if (text == null) {
                n = 4;
            } else {
                Objects.requireNonNull(this.font);
                n = 9;
            }
            currentY += n;
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        ScissorsHandler.INSTANCE.scissor(this.scrolling.getBounds());
        this.scrolling.renderScrollBar(drawContext, -16777216, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        ScissorsHandler.INSTANCE.removeLastScissor();
    }
}

