/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.plugins.EnchanterCategory;
import earth.terrarium.pastel.compat.REI.plugins.EnchantmentUpgradeDisplay;
import earth.terrarium.pastel.compat.REI.widgets.IndexedEntryWidget;
import earth.terrarium.pastel.registries.PastelAdvancements;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class EnchantmentUpgradeCategory
extends EnchanterCategory<EnchantmentUpgradeDisplay> {
    public static final int NORMAL_COLOR = 5060181;
    private static final int OVERCHANT_COLOR = 14366052;

    public CategoryIdentifier<EnchantmentUpgradeDisplay> getCategoryIdentifier() {
        return PastelPlugins.ENCHANTMENT_UPGRADE;
    }

    public Component getTitle() {
        return Component.translatable((String)"container.pastel.rei.enchantment_upgrading.title");
    }

    @Override
    public int getCraftingTime(@NotNull EnchantmentUpgradeDisplay display) {
        return 0;
    }

    @Override
    public Component getDescriptionText(@NotNull EnchantmentUpgradeDisplay display) {
        return Component.translatable((String)"container.pastel.rei.enchantment_upgrade.required_item_count", (Object[])new Object[]{0});
    }

    @Override
    public void setupWidgets(Point startPoint, Rectangle bounds, List<Widget> widgets, @NotNull EnchantmentUpgradeDisplay display) {
        boolean overUnlocked = DatabankUtils.hasAdvancement((Player)Minecraft.getInstance().player, (ResourceLocation)PastelAdvancements.Milestones.UNLOCK_OVERENCHANTING_WITH_ENCHANTER);
        List inputs = display.getInputEntries();
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)BACKGROUND_TEXTURE, (int)(startPoint.x - 8 + 12), (int)(startPoint.y - 7 + 21), (float)0.0f, (float)0.0f, (int)54, (int)54));
        if (overUnlocked && display.levelCap > display.maxNormal) {
            widgets.add((Widget)Widgets.withTooltip((WidgetWithBounds)Widgets.withBounds((Widget)Widgets.createTexturedWidget((ResourceLocation)BACKGROUND_TEXTURE, (int)(startPoint.x - 10), (int)(startPoint.y + 2), (float)64.0f, (float)0.0f, (int)16, (int)16), (Rectangle)new Rectangle(startPoint.x - 10, startPoint.y + 2, 16, 16)), (Component[])new Component[]{Component.translatable((String)"container.pastel.rei.enchantment_upgrade.tooltip").withStyle(s -> s.withColor(14366052))}));
        }
        int max = overUnlocked ? display.levelCap : display.maxNormal;
        widgets.add((Widget)Widgets.createButton((Rectangle)new Rectangle(startPoint.x - 8 + 84, startPoint.y + 20, 8, 8), (Component)Component.literal((String)"-")).onClick(b -> {
            display.index = Math.clamp((long)(display.index - 1), 1, max - 1);
        }));
        widgets.add((Widget)Widgets.createButton((Rectangle)new Rectangle(startPoint.x - 8 + 94, startPoint.y + 20, 8, 8), (Component)Component.literal((String)"+")).onClick(b -> {
            display.index = Math.clamp((long)(display.index + 1), 1, max - 1);
        }));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 8 + 18, startPoint.y - 7 + 9)).markInput().entries((Collection)inputs.get(0)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 8 + 44, startPoint.y - 7 + 9)).markInput().entries((Collection)inputs.get(1)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 8 + 62, startPoint.y - 7 + 27)).markInput().entries((Collection)inputs.get(2)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 8 + 62, startPoint.y - 7 + 53)).markInput().entries((Collection)inputs.get(3)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 8 + 44, startPoint.y - 7 + 71)).markInput().entries((Collection)inputs.get(4)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 8 + 18, startPoint.y - 7 + 71)).markInput().entries((Collection)inputs.get(5)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 8, startPoint.y - 7 + 53)).markInput().entries((Collection)inputs.get(6)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 8, startPoint.y - 7 + 27)).markInput().entries((Collection)inputs.get(7)));
        widgets.add((Widget)new IndexedEntryWidget(new Point(startPoint.x - 8 + 111, startPoint.y - 7 + 14), () -> display.index - 1).markInput().entries((Collection)inputs.get(overUnlocked ? 9 : 8)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 8 + 111, startPoint.y - 7 + 60)).entries((Collection)ENCHANTER).disableBackground());
        widgets.add((Widget)new IndexedEntryWidget(new Point(startPoint.x - 8 + 31, startPoint.y - 7 + 40), () -> display.index - 1).markInput().entries((Collection)inputs.get(overUnlocked ? 11 : 10)));
        widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x - 8 + 80, startPoint.y - 7 + 40)).animationDurationTicks((double)this.getCraftingTime(display)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x - 8 + 111, startPoint.y - 7 + 40)));
        Slot outputSlot = new IndexedEntryWidget(new Point(startPoint.x - 8 + 111, startPoint.y - 7 + 40), () -> display.index - 1).markOutput().disableBackground().entries((Collection)(overUnlocked ? display.overchantOutputs : display.normalOutputs));
        widgets.add((Widget)outputSlot);
        Label levelLabel = Widgets.createLabel((Point)new Point(startPoint.x - 11 + 70, startPoint.y + 2), (Component)this.getDescriptionText(display)).leftAligned().color(5060181).noShadow();
        levelLabel.setOnRender((drawContext, label) -> {
            int level = display.index;
            if (level > display.maxNormal) {
                label.setColor(14366052);
            } else {
                label.setColor(5060181);
            }
            label.setMessage((FormattedText)Component.translatable((String)"container.pastel.rei.enchantment_upgrade.level", (Object[])new Object[]{level, level + 1}));
        });
        Label costLabel = Widgets.createLabel((Point)new Point(startPoint.x - 11 + 70, startPoint.y - 11 + 85), (Component)this.getDescriptionText(display)).leftAligned().color(5060181).noShadow();
        costLabel.setOnRender((drawContext, label) -> {
            int level = display.index;
            label.setMessage((FormattedText)Component.translatable((String)"container.pastel.rei.enchantment_upgrade.required_item_count", (Object[])new Object[]{display.itemScaling.apply(level)}));
        });
        widgets.add((Widget)levelLabel);
        widgets.add((Widget)costLabel);
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x - 7, startPoint.y + 2 + 82), (Component)display.transKey).color(5060181).shadow(false).leftAligned());
    }

    @Override
    public int getDisplayHeight() {
        return super.getDisplayHeight() + 10;
    }
}

