/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.compat.REI.PastelDisplay;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumCatalyst;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumRecipe;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CrystallarieumDisplay
extends PastelDisplay {
    protected final List<EntryIngredient> growthStages = new ArrayList<EntryIngredient>();
    protected final List<CrystallarieumCatalyst> catalysts;
    protected final InkColor inkColor;
    protected final boolean growsWithoutCatalyst;
    protected final int secondsPerStage;

    public CrystallarieumDisplay(@NotNull RecipeHolder<CrystallarieumRecipe> recipe) {
        super(recipe, CrystallarieumDisplay.inputs((CrystallarieumRecipe)recipe.value()), CrystallarieumDisplay.outputs((CrystallarieumRecipe)recipe.value()));
        for (BlockState state : ((CrystallarieumRecipe)recipe.value()).getGrowthStages()) {
            this.growthStages.add(EntryIngredients.of((ItemLike)state.getBlock().asItem()));
        }
        this.catalysts = ((CrystallarieumRecipe)recipe.value()).getCatalysts();
        this.inkColor = ((CrystallarieumRecipe)recipe.value()).getInkColor();
        this.growsWithoutCatalyst = ((CrystallarieumRecipe)recipe.value()).growsWithoutCatalyst();
        this.secondsPerStage = ((CrystallarieumRecipe)recipe.value()).getSecondsPerGrowthStage();
    }

    public static List<EntryIngredient> inputs(CrystallarieumRecipe recipe) {
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
        inputs.add(EntryIngredients.ofIngredient((Ingredient)recipe.getIngredientStack()));
        Item firstBlockStateItem = recipe.getGrowthStages().get(0).getBlock().asItem();
        if (firstBlockStateItem != Items.AIR) {
            inputs.add(EntryIngredients.of((ItemLike)firstBlockStateItem));
        }
        return inputs;
    }

    public static List<EntryIngredient> outputs(CrystallarieumRecipe recipe) {
        ArrayList<EntryIngredient> outputs = new ArrayList<EntryIngredient>();
        outputs.add(EntryIngredients.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)BasicDisplay.registryAccess())));
        for (ItemStack additionalOutput : recipe.getAdditionalResults()) {
            outputs.add(EntryIngredients.of((ItemStack)additionalOutput));
        }
        for (BlockState growthStageState : recipe.getGrowthStages()) {
            Item blockStateItem = growthStageState.getBlock().asItem();
            if (blockStateItem == Items.AIR) continue;
            outputs.add(EntryIngredients.of((ItemLike)blockStateItem));
        }
        return outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return PastelPlugins.CRYSTALLARIEUM;
    }

    @Override
    public boolean isUnlocked() {
        Minecraft client = Minecraft.getInstance();
        return DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)CrystallarieumRecipe.UNLOCK_IDENTIFIER) && super.isUnlocked();
    }
}

