/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.plugins.CinderhearthDisplay;
import earth.terrarium.pastel.compat.REI.plugins.GatedDisplayCategory;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CinderhearthCategory
extends GatedDisplayCategory<CinderhearthDisplay> {
    public CategoryIdentifier<CinderhearthDisplay> getCategoryIdentifier() {
        return PastelPlugins.CINDERHEARTH;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.pastel.cinderhearth");
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)PastelBlocks.CINDERHEARTH.get()));
    }

    @Override
    public void setupWidgets(Point startPoint, Rectangle bounds, List<Widget> widgets, @NotNull CinderhearthDisplay display) {
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 6, startPoint.y + 2)).markInput().entries((Collection)display.getInputEntries().get(0)));
        widgets.add((Widget)Widgets.createBurningFire((Point)new Point(startPoint.x - 6, startPoint.y + 1 + 20)).animationDurationMS(10000.0));
        widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x - 6 + 18, startPoint.y + 2 + 5)).animationDurationTicks((double)display.craftingTime));
        List<Tuple<ItemStack, Float>> outputs = display.outputsWithChance;
        for (int i = 0; i < outputs.size(); ++i) {
            Tuple<ItemStack, Float> currentOutput = outputs.get(i);
            ItemStack outputStack = (ItemStack)currentOutput.getA();
            Float chance = (Float)currentOutput.getB();
            Point point = new Point(startPoint.x - 6 + 49 + i * 28, startPoint.y + 1 + 5);
            widgets.add(Widgets.createResultSlotBackground((Point)point));
            widgets.add((Widget)Widgets.createSlot((Point)point).disableBackground().markOutput().entries((Collection)EntryIngredients.of((ItemStack)outputStack)));
            if (!((double)chance.floatValue() < 1.0)) continue;
            widgets.add((Widget)Widgets.createLabel((Point)new Point(point.x - 2, point.y + 23), (Component)Component.literal((String)((int)(chance.floatValue() * 100.0f) + " %"))).leftAligned().color(0x3F3F3F).noShadow());
        }
        Component text = CinderhearthCategory.getCraftingTimeText(display.craftingTime, display.experience);
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x - 6, startPoint.y + 1 + 43), (Component)text).leftAligned().color(0x3F3F3F).noShadow());
    }

    public int getDisplayHeight() {
        return 65;
    }
}

