/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.capabilities.item;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.ApiStatus;

public class FriendlyStackHandler
extends ItemStackHandler {
    private List<Consumer<Integer>> listeners;
    private final Int2IntMap limits = new Int2IntOpenHashMap();
    private int tempLimit = -1;

    public FriendlyStackHandler(int size) {
        super(size);
    }

    public FriendlyStackHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public ItemStack removeStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        ItemStack removed = (ItemStack)this.stacks.set(slot, (Object)ItemStack.EMPTY);
        this.onContentsChanged(slot);
        return removed;
    }

    public ItemStack removeStackInSlotNoUpdate(int slot) {
        this.validateSlotIndex(slot);
        ItemStack removed = (ItemStack)this.stacks.set(slot, (Object)ItemStack.EMPTY);
        return removed;
    }

    public NonNullList<ItemStack> getInternalList() {
        return this.stacks;
    }

    public void setInternalList(NonNullList<ItemStack> newStacks) {
        if (newStacks.size() != this.stacks.size()) {
            throw new RuntimeException("Attempted to replace stack handler list with one of an unequal size!");
        }
        this.stacks = newStacks;
        for (int i = 0; i < this.getSlots(); ++i) {
            this.onContentsChanged(i);
        }
    }

    public void save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("inventory", (Tag)this.serializeNBT(provider));
    }

    public void load(CompoundTag tag, HolderLookup.Provider provider) {
        this.deserializeNBT(provider, tag.getCompound("inventory"));
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.stacks.clear();
        for (int i = 0; i < this.getSlots(); ++i) {
            this.onContentsChanged(i);
        }
    }

    public void addListener(Consumer<Integer> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Consumer<Integer>>();
        }
        this.listeners.add(listener);
    }

    public void onContentsChanged(int slot) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.forEach(l -> l.accept(slot));
    }

    public boolean hasAnyOf(Set<Item> set) {
        return this.hasAnyMatching(item -> !item.isEmpty() && set.contains(item.getItem()));
    }

    protected void validateSlotIndex(int slot) {
        super.validateSlotIndex(slot);
    }

    public int getSlotLimit(int slot) {
        if (this.tempLimit != -1) {
            return this.tempLimit;
        }
        if (this.limits.containsKey(slot)) {
            return this.limits.get(slot);
        }
        return super.getSlotLimit(slot);
    }

    public FriendlyStackHandler addLimit(int slot, int limit) {
        this.limits.put(slot, limit);
        return this;
    }

    public void clearLimits() {
        this.limits.clear();
    }

    @ApiStatus.Internal
    public void setTempLimit(int tempLimit) {
        this.tempLimit = tempLimit;
    }

    public boolean hasAnyMatching(Predicate<ItemStack> predicate) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (!predicate.test(stack)) continue;
            return true;
        }
        return false;
    }
}

