/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.weathering;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface Weathering
extends ChangeOverTimeBlock<WeatheringLevel> {
    public static final Supplier<BiMap<Block, Block>> WEATHERING_LEVEL_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)PastelBlocks.POLISHED_SHALE_CLAY.get()), (Object)((Block)PastelBlocks.EXPOSED_POLISHED_SHALE_CLAY.get())).put((Object)((Block)PastelBlocks.EXPOSED_POLISHED_SHALE_CLAY.get()), (Object)((Block)PastelBlocks.WEATHERED_POLISHED_SHALE_CLAY.get())).put((Object)((Block)PastelBlocks.POLISHED_SHALE_CLAY_STAIRS.get()), (Object)((Block)PastelBlocks.EXPOSED_POLISHED_SHALE_CLAY_STAIRS.get())).put((Object)((Block)PastelBlocks.EXPOSED_POLISHED_SHALE_CLAY_STAIRS.get()), (Object)((Block)PastelBlocks.WEATHERED_POLISHED_SHALE_CLAY_STAIRS.get())).put((Object)((Block)PastelBlocks.POLISHED_SHALE_CLAY_SLAB.get()), (Object)((Block)PastelBlocks.EXPOSED_POLISHED_SHALE_CLAY_SLAB.get())).put((Object)((Block)PastelBlocks.EXPOSED_POLISHED_SHALE_CLAY_SLAB.get()), (Object)((Block)PastelBlocks.WEATHERED_POLISHED_SHALE_CLAY_SLAB.get())).put((Object)((Block)PastelBlocks.SHALE_CLAY_BRICKS.get()), (Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_BRICKS.get())).put((Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_BRICKS.get()), (Object)((Block)PastelBlocks.WEATHERED_SHALE_CLAY_BRICKS.get())).put((Object)((Block)PastelBlocks.SHALE_CLAY_BRICK_STAIRS.get()), (Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_BRICK_STAIRS.get())).put((Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_BRICK_STAIRS.get()), (Object)((Block)PastelBlocks.WEATHERED_SHALE_CLAY_BRICK_STAIRS.get())).put((Object)((Block)PastelBlocks.SHALE_CLAY_BRICK_SLAB.get()), (Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_BRICK_SLAB.get())).put((Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_BRICK_SLAB.get()), (Object)((Block)PastelBlocks.WEATHERED_SHALE_CLAY_BRICK_SLAB.get())).put((Object)((Block)PastelBlocks.SHALE_CLAY_TILES.get()), (Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_TILES.get())).put((Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_TILES.get()), (Object)((Block)PastelBlocks.WEATHERED_SHALE_CLAY_TILES.get())).put((Object)((Block)PastelBlocks.SHALE_CLAY_TILE_STAIRS.get()), (Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_TILE_STAIRS.get())).put((Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_TILE_STAIRS.get()), (Object)((Block)PastelBlocks.WEATHERED_SHALE_CLAY_TILE_STAIRS.get())).put((Object)((Block)PastelBlocks.SHALE_CLAY_TILE_SLAB.get()), (Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_TILE_SLAB.get())).put((Object)((Block)PastelBlocks.EXPOSED_SHALE_CLAY_TILE_SLAB.get()), (Object)((Block)PastelBlocks.WEATHERED_SHALE_CLAY_TILE_SLAB.get())).build());
    public static final Supplier<BiMap<Block, Block>> WEATHERING_LEVEL_DECREASES = Suppliers.memoize(() -> WEATHERING_LEVEL_INCREASES.get().inverse());

    public static Optional<Block> getDecreasedWeatheredBlock(Block block) {
        return Optional.ofNullable((Block)WEATHERING_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Block getUnaffectedWeatheredBlock(Block block) {
        Block returnBlock = block;
        Block block3 = (Block)WEATHERING_LEVEL_DECREASES.get().get((Object)block);
        while (block3 != null) {
            returnBlock = block3;
            block3 = (Block)WEATHERING_LEVEL_DECREASES.get().get((Object)block3);
        }
        return returnBlock;
    }

    public static Optional<BlockState> getDecreasedWeatheredState(BlockState state) {
        return Weathering.getDecreasedWeatheredBlock(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    public static Optional<Block> getIncreasedWeatheredBlock(Block block) {
        return Optional.ofNullable((Block)WEATHERING_LEVEL_INCREASES.get().get((Object)block));
    }

    public static BlockState getUnaffectedWeatheredState(BlockState state) {
        return Weathering.getUnaffectedWeatheredBlock(state.getBlock()).withPropertiesOf(state);
    }

    default public Optional<BlockState> getNext(BlockState state) {
        return Weathering.getIncreasedWeatheredBlock(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    default public float getChanceModifier() {
        return this.getAge() == WeatheringLevel.UNAFFECTED ? 0.75f : 1.0f;
    }

    default public boolean shouldTryWeather(Level world, BlockPos pos) {
        float chance;
        float f = chance = world.canSeeSky(pos) ? 0.5f : 0.0f;
        if (world.isRaining() && ((Biome)world.getBiome(pos).value()).getPrecipitationAt(pos) != Biome.Precipitation.NONE) {
            chance = (float)((double)chance + 0.5);
        }
        return world.random.nextFloat() < chance;
    }

    public static enum WeatheringLevel {
        UNAFFECTED,
        EXPOSED,
        WEATHERED;

    }
}

