/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.upgrade;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.upgrade.UpgradeBlock;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class UpgradeBlockBlockEntityRenderer<PedestalUpgradeBlockEntity extends BlockEntity>
implements BlockEntityRenderer<PedestalUpgradeBlockEntity> {
    private final ModelPart root;
    private final ModelPart disk;
    private Material spriteIdentifier;

    public UpgradeBlockBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        LayerDefinition texturedModelData = this.getTexturedModelData(Upgradeable.UpgradeType.SPEED);
        this.root = texturedModelData.bakeRoot();
        this.root.setPos(8.0f, 8.0f, 8.0f);
        this.disk = this.root.getChild("gemstone_disk");
    }

    public void render(PedestalUpgradeBlockEntity entity, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        if (entity.getLevel() != null && entity.getLevel().getBlockState(entity.getBlockPos().above()).canOcclude()) {
            return;
        }
        Block block = entity.getLevel().getBlockState(entity.getBlockPos()).getBlock();
        if (block instanceof UpgradeBlock) {
            UpgradeBlock upgradeBlock = (UpgradeBlock)block;
            float upgradeMod = upgradeBlock.getUpgradeMod();
            VertexConsumer vertexConsumer = this.spriteIdentifier.buffer(vertexConsumerProvider, RenderType::entityCutout);
            float newYaw = ((float)(entity.getLevel().getGameTime() % 24000L) + tickDelta) / 80.0f;
            this.root.y = 16.0f + (float)(Math.sin(newYaw) * 0.5);
            this.disk.yRot = newYaw * upgradeMod * 4.0f;
            this.root.render(poseStack, vertexConsumer, light, overlay);
        }
    }

    @NotNull
    public LayerDefinition getTexturedModelData( @NotNull Upgradeable.UpgradeType upgradeType) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        switch (upgradeType) {
            case SPEED: {
                this.spriteIdentifier = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/pedestal_upgrade_speed"));
                modelPartData.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                modelPartData.addOrReplaceChild("basalt", CubeListBuilder.create().texOffs(20, 2).mirror().addBox(-3.0f, -3.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                modelPartData.addOrReplaceChild("basalt2", CubeListBuilder.create().texOffs(20, 3).mirror().addBox(-3.0f, 2.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                modelPartData.addOrReplaceChild("gemstone_disk", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                return LayerDefinition.create((MeshDefinition)modelData, (int)48, (int)48);
            }
            case YIELD: {
                this.spriteIdentifier = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/pedestal_upgrade_yield"));
                modelPartData.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                modelPartData.addOrReplaceChild("basalt", CubeListBuilder.create().texOffs(20, 2).mirror().addBox(-3.0f, -3.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                modelPartData.addOrReplaceChild("basalt2", CubeListBuilder.create().texOffs(20, 3).mirror().addBox(-3.0f, 2.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                modelPartData.addOrReplaceChild("gemstone_disk", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                return LayerDefinition.create((MeshDefinition)modelData, (int)48, (int)48);
            }
            case EFFICIENCY: {
                this.spriteIdentifier = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/pedestal_upgrade_efficiency"));
                modelPartData.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                modelPartData.addOrReplaceChild("basalt", CubeListBuilder.create().texOffs(20, 2).mirror().addBox(-3.0f, -3.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                modelPartData.addOrReplaceChild("basalt2", CubeListBuilder.create().texOffs(20, 3).mirror().addBox(-3.0f, 2.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                modelPartData.addOrReplaceChild("gemstone_disk", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                return LayerDefinition.create((MeshDefinition)modelData, (int)48, (int)48);
            }
        }
        this.spriteIdentifier = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/pedestal_upgrade_experience"));
        modelPartData.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.addOrReplaceChild("basalt", CubeListBuilder.create().texOffs(20, 2).mirror().addBox(-3.0f, -3.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.addOrReplaceChild("basalt2", CubeListBuilder.create().texOffs(20, 3).mirror().addBox(-3.0f, 2.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.addOrReplaceChild("gemstone_disk", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)48, (int)48);
    }
}

