/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.titration_barrel;

import earth.terrarium.pastel.api.block.FluidTankInventory;
import earth.terrarium.pastel.blocks.titration_barrel.TitrationBarrelBlock;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.capabilities.fluid.FluidHandlerView;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.mixin.accessors.BiomeAccessor;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.recipe.FluidRecipeInput;
import earth.terrarium.pastel.recipe.titration_barrel.ITitrationBarrelRecipe;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class TitrationBarrelBlockEntity
extends BlockEntity
implements FluidTankInventory,
SidedCapabilityProvider {
    protected static final int INVENTORY_SIZE = 5;
    public static final int MAX_ITEM_COUNT = 64;
    protected FriendlyStackHandler inventory;
    protected FluidTank tank = new FluidTank(1000);
    protected long sealTime = -1L;
    protected long tapTime = -1L;
    protected String recipe;
    protected int extractedBottles = 0;

    @Override
    public FriendlyStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    public TitrationBarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.TITRATION_BARREL.get(), pos, state);
        this.inventory = new FriendlyStackHandler(5);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.inventory.save(nbt, registryLookup);
        this.tank.writeToNBT(registryLookup, nbt);
        nbt.putLong("SealTime", this.sealTime);
        nbt.putLong("TapTime", this.tapTime);
        nbt.putInt("ExtractedBottles", this.extractedBottles);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.inventory.load(nbt, registryLookup);
        this.tank.readFromNBT(registryLookup, nbt);
        this.sealTime = nbt.contains("SealTime", 4) ? nbt.getLong("SealTime") : -1L;
        this.tapTime = nbt.contains("TapTime", 4) ? nbt.getLong("TapTime") : -1L;
        this.extractedBottles = nbt.contains("ExtractedBottles", 99) ? nbt.getInt("ExtractedBottles") : 0;
    }

    public void seal() {
        this.sealTime = new Date().getTime();
        this.setChanged();
    }

    public void tap() {
        this.tapTime = new Date().getTime();
        this.setChanged();
    }

    public void reset(Level world, BlockPos blockPos, BlockState state) {
        this.sealTime = -1L;
        this.tapTime = -1L;
        this.tank.setFluid(FluidStack.EMPTY);
        this.extractedBottles = 0;
        this.getInventory().getInternalList().clear();
        world.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue(TitrationBarrelBlock.BARREL_STATE, (Comparable)((Object)TitrationBarrelBlock.BarrelState.EMPTY)));
        world.playSound(null, blockPos, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.setChanged();
    }

    public long getSealMilliseconds() {
        if (this.sealTime == -1L) {
            return 0L;
        }
        long tapTime = this.tapTime == -1L ? new Date().getTime() : this.tapTime;
        return tapTime - this.sealTime;
    }

    public long getSealSeconds() {
        return this.getSealMilliseconds() / 1000L;
    }

    public int getSealMinecraftDays() {
        return (int)(this.getSealMilliseconds() / 1000L / 60L / 20L);
    }

    public String getSealRealDays() {
        return Support.getWithOneDecimalAfterComma((float)this.getSealMilliseconds() / 1000.0f / 60.0f / 20.0f / 72.0f);
    }

    private boolean isEmpty(float temperature, int extractedBottles, ITitrationBarrelRecipe recipe) {
        if (this.level == null || !recipe.getFluidInput().test(this.getTank().getFluid())) {
            return true;
        }
        return extractedBottles >= recipe.getOutputCountAfterAngelsShare(this.level, temperature, this.getSealSeconds());
    }

    public void addOneDayOfSealTime() {
        this.sealTime -= 86400000L;
        this.setChanged();
    }

    public ItemStack tryHarvest(Level world, BlockPos blockPos, BlockState blockState, ItemStack handStack, @Nullable Player player) {
        ItemStack harvestedStack = ItemStack.EMPTY;
        Biome biome = (Biome)world.getBiome(blockPos).value();
        boolean shouldReset = false;
        MutableComponent message = null;
        int daysSealed = this.getSealMinecraftDays();
        int inventoryCount = InventoryHelper.countItemsInInventory((IItemHandlerModifiable)this.getInventory());
        Optional<RecipeHolder<ITitrationBarrelRecipe>> optionalRecipe = this.getRecipeForInventory(world);
        if (optionalRecipe.isEmpty()) {
            message = this.getInventory().isEmpty() && this.tank.isEmpty() ? Component.translatable((String)"block.pastel.titration_barrel.empty_when_tapping") : Component.translatable((String)"block.pastel.titration_barrel.invalid_recipe_when_tapping");
            shouldReset = true;
        } else {
            ITitrationBarrelRecipe recipe = (ITitrationBarrelRecipe)optionalRecipe.get().value();
            long secondsFermented = (this.tapTime - this.sealTime) / 1000L;
            int output = recipe.getOutputCountAfterAngelsShare(world, biome.getBaseTemperature(), secondsFermented);
            if (recipe.getFluidInput().test(this.tank.getFluid())) {
                if (recipe.canPlayerCraft(player)) {
                    boolean canTap = true;
                    Item tappingItem = recipe.getTappingItem();
                    if (tappingItem != Items.AIR) {
                        if (handStack.is(tappingItem)) {
                            output = Math.min(output, handStack.getCount());
                            handStack.shrink(output);
                        } else {
                            message = Component.translatable((String)"block.pastel.titration_barrel.tapping_item_required").append(tappingItem.getDescription());
                            canTap = false;
                        }
                    }
                    if (canTap) {
                        float downfall = ((BiomeAccessor)biome).getClimateSettings().downfall();
                        harvestedStack = recipe.getTitrationResult(this.inventory, secondsFermented, downfall);
                        harvestedStack.setCount(output);
                        this.extractedBottles += output;
                        shouldReset = this.isEmpty(biome.getBaseTemperature(), this.extractedBottles, recipe);
                    }
                } else {
                    message = Component.translatable((String)"block.pastel.titration_barrel.recipe_not_unlocked");
                }
            } else {
                message = this.tank.isEmpty() ? Component.translatable((String)"block.pastel.titration_barrel.missing_liquid_when_tapping") : Component.translatable((String)"block.pastel.titration_barrel.invalid_recipe_when_tapping");
                shouldReset = true;
            }
        }
        Level secondsFermented = this.level;
        if (secondsFermented instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)secondsFermented;
            ItemStack finalHarvestedStack = harvestedStack;
            Support.areaCriterion(sl, 12, blockPos, optionalRecipe.flatMap(r -> ((ITitrationBarrelRecipe)r.value()).advancementID()), p -> PastelCriteria.TITRATION_BARREL_TAPPING.trigger((ServerPlayer)p, finalHarvestedStack, daysSealed, inventoryCount));
        }
        if (player != null && message != null) {
            player.displayClientMessage((Component)message, true);
        }
        if (shouldReset) {
            this.reset(world, blockPos, blockState);
        }
        this.setChanged();
        return harvestedStack;
    }

    public Optional<RecipeHolder<ITitrationBarrelRecipe>> getRecipeForInventory(Level world) {
        return world.getRecipeManager().getRecipeFor(PastelRecipeTypes.TITRATION_BARREL, this.getRecipeInput(), world);
    }

    public FluidRecipeInput<FluidTank> getRecipeInput() {
        return new FluidRecipeInput<FluidTank>((List<ItemStack>)this.inventory.getInternalList(), this.tank);
    }

    public void giveRecipeRemainders(Player player) {
        for (ItemStack stack : this.getInventory().getInternalList()) {
            ItemStack remainder = stack.getCraftingRemainingItem();
            if (remainder.isEmpty()) continue;
            player.getInventory().placeItemBackInInventory(remainder);
        }
    }

    public boolean canBeSealed(Player player) {
        int itemCount = InventoryHelper.countItemsInInventory((IItemHandlerModifiable)this.getInventory());
        if (itemCount == 0 && this.tank.isEmpty()) {
            return true;
        }
        if (this.level != null) {
            Optional<RecipeHolder<ITitrationBarrelRecipe>> optionalRecipe = this.getRecipeForInventory(this.level);
            return optionalRecipe.isPresent() && ((ITitrationBarrelRecipe)optionalRecipe.get().value()).canPlayerCraft(player) && ((ITitrationBarrelRecipe)optionalRecipe.get().value()).getFluidInput().test(this.tank.getFluid());
        }
        return false;
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        return new StackHandlerView(this.inventory).disableExtraction().disableInsertion();
    }

    @Override
    public IFluidHandler exposeFluidHandlers(Direction dir) {
        return new FluidHandlerView((IFluidHandler)this.tank).disableExtraction().disableInsertion();
    }
}

