/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.titration_barrel;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.titration_barrel.TitrationBarrelBlockEntity;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.recipe.titration_barrel.ITitrationBarrelRecipe;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitrationBarrelBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<TitrationBarrelBlock> CODEC = TitrationBarrelBlock.simpleCodec(TitrationBarrelBlock::new);
    public static final EnumProperty<BarrelState> BARREL_STATE = EnumProperty.create((String)"barrel_state", BarrelState.class);

    public TitrationBarrelBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(BARREL_STATE, (Comparable)((Object)BarrelState.EMPTY)));
    }

    public MapCodec<? extends TitrationBarrelBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TitrationBarrelBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TitrationBarrelBlockEntity) {
            TitrationBarrelBlockEntity barrelEntity = (TitrationBarrelBlockEntity)blockEntity;
            BarrelState barrelState = (BarrelState)((Object)state.getValue(BARREL_STATE));
            switch (barrelState.ordinal()) {
                case 0: 
                case 1: {
                    if (player.isShiftKeyDown() && handStack.isEmpty()) {
                        if (barrelState != BarrelState.FILLED) break;
                        this.tryExtractLastStack(state, world, pos, player, barrelEntity);
                        break;
                    }
                    if (handStack.isEmpty()) {
                        int itemCount = InventoryHelper.countItemsInInventory((IItemHandlerModifiable)barrelEntity.inventory);
                        Fluid fluid = barrelEntity.tank.getFluid().getFluid();
                        if (fluid == Fluids.EMPTY) {
                            if (itemCount == 64) {
                                player.displayClientMessage((Component)Component.translatable((String)"block.pastel.titration_barrel.content_count_without_fluid_full", (Object[])new Object[]{itemCount}), true);
                                break;
                            }
                            player.displayClientMessage((Component)Component.translatable((String)"block.pastel.titration_barrel.content_count_without_fluid", (Object[])new Object[]{itemCount}), true);
                            break;
                        }
                        String fluidName = fluid.defaultFluidState().createLegacyBlock().getBlock().getName().getString();
                        if (itemCount == 64) {
                            player.displayClientMessage((Component)Component.translatable((String)"block.pastel.titration_barrel.content_count_with_fluid_full", (Object[])new Object[]{fluidName, itemCount}), true);
                            break;
                        }
                        player.displayClientMessage((Component)Component.translatable((String)"block.pastel.titration_barrel.content_count_with_fluid", (Object[])new Object[]{fluidName, itemCount}), true);
                        break;
                    }
                    if (handStack.is(PastelItemTags.COLORED_PLANKS)) {
                        if (barrelEntity.canBeSealed(player)) {
                            if (!player.isCreative()) {
                                handStack.shrink(1);
                            }
                            this.sealBarrel(world, pos, state, barrelEntity, player);
                        } else {
                            player.displayClientMessage((Component)Component.translatable((String)"block.pastel.titration_barrel.invalid_recipe"), true);
                        }
                        return ItemInteractionResult.CONSUME;
                    }
                    if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)barrelEntity.tank)) {
                        if (!barrelEntity.tank.isEmpty()) {
                            if (state.getValue(BARREL_STATE) == BarrelState.FILLED && barrelEntity.tank.isEmpty()) {
                                world.setBlockAndUpdate(pos, (BlockState)state.setValue(BARREL_STATE, (Comparable)((Object)BarrelState.EMPTY)));
                            }
                        } else if (state.getValue(BARREL_STATE) == BarrelState.EMPTY) {
                            world.setBlockAndUpdate(pos, (BlockState)state.setValue(BARREL_STATE, (Comparable)((Object)BarrelState.FILLED)));
                        }
                        return ItemInteractionResult.CONSUME;
                    }
                    int countBefore = handStack.getCount();
                    ItemStack leftoverStack = InventoryHelper.addToInventoryUpToSingleStackWithMaxTotalCount(handStack, (IItemHandlerModifiable)barrelEntity.inventory, 64);
                    player.setItemInHand(hand, leftoverStack);
                    if (countBefore == leftoverStack.getCount()) break;
                    world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.8f, 0.8f + world.random.nextFloat() * 0.6f);
                    if (barrelState == BarrelState.EMPTY) {
                        world.setBlockAndUpdate(pos, (BlockState)state.setValue(BARREL_STATE, (Comparable)((Object)BarrelState.FILLED)));
                        break;
                    }
                    world.updateNeighbourForOutputSignal(pos, (Block)this);
                    break;
                }
                case 2: {
                    Optional<RecipeHolder<ITitrationBarrelRecipe>> recipe = barrelEntity.getRecipeForInventory(world);
                    if (recipe.isPresent()) {
                        long sealSeconds;
                        if (player.isCreative() && player.getMainHandItem().is((Item)PastelItems.PAINTBRUSH.get())) {
                            player.displayClientMessage((Component)Component.translatable((String)"block.pastel.titration_barrel.debug_added_day"), true);
                            barrelEntity.addOneDayOfSealTime();
                            world.playSound(null, pos, PastelSounds.NEW_RECIPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        if ((sealSeconds = barrelEntity.getSealSeconds()) >= 0L && !((ITitrationBarrelRecipe)recipe.get().value()).isFermentingLongEnoughToTap(barrelEntity.getSealSeconds())) {
                            player.displayClientMessage((Component)Component.translatable((String)"block.pastel.titration_barrel.not_yet_ready", (Object[])new Object[]{barrelEntity.getSealMinecraftDays(), barrelEntity.getSealRealDays()}), true);
                            break;
                        }
                    }
                    if (player.isShiftKeyDown()) {
                        this.unsealBarrel(world, pos, state, barrelEntity);
                        break;
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"block.pastel.titration_barrel.days_of_sealing_before_opened", (Object[])new Object[]{barrelEntity.getSealMinecraftDays(), barrelEntity.getSealRealDays()}), true);
                    break;
                }
                case 3: {
                    if (player.isShiftKeyDown()) {
                        Optional recipe = world.getRecipeManager().getRecipeFor(PastelRecipeTypes.TITRATION_BARREL, barrelEntity.getRecipeInput(), world);
                        if (recipe.isPresent()) {
                            player.displayClientMessage((Component)Component.translatable((String)"block.pastel.titration_barrel.days_of_sealing_after_opened_with_extractable_amount", (Object[])new Object[]{((ITitrationBarrelRecipe)((RecipeHolder)recipe.get()).value()).assemble(barrelEntity.getRecipeInput(), (HolderLookup.Provider)world.registryAccess()).getHoverName().getString(), barrelEntity.getSealMinecraftDays(), barrelEntity.getSealRealDays()}), true);
                            break;
                        }
                        player.displayClientMessage((Component)Component.translatable((String)"block.pastel.titration_barrel.invalid_recipe_when_tapping"), true);
                        break;
                    }
                    ItemStack harvestedStack = barrelEntity.tryHarvest(world, pos, state, player.getItemInHand(hand), player);
                    if (harvestedStack.isEmpty()) break;
                    player.getInventory().placeItemBackInInventory(harvestedStack);
                    world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    private void tryExtractLastStack(BlockState state, Level world, BlockPos pos, Player player, TitrationBarrelBlockEntity barrelEntity) {
        Optional<ItemStack> stack = InventoryHelper.extractLastStack((IItemHandlerModifiable)barrelEntity.getInventory());
        if (stack.isPresent()) {
            player.getInventory().placeItemBackInInventory(stack.get());
            barrelEntity.setChanged();
            if (barrelEntity.inventory.isEmpty() && barrelEntity.tank.isEmpty()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue(BARREL_STATE, (Comparable)((Object)BarrelState.EMPTY)));
            } else {
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void sealBarrel(Level world, BlockPos pos, BlockState state, TitrationBarrelBlockEntity barrelEntity, Player player) {
        barrelEntity.giveRecipeRemainders(player);
        world.setBlockAndUpdate(pos, (BlockState)state.setValue(BARREL_STATE, (Comparable)((Object)BarrelState.SEALED)));
        barrelEntity.seal();
        world.playSound(null, pos, SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void unsealBarrel(Level world, BlockPos pos, BlockState state, TitrationBarrelBlockEntity barrelEntity) {
        world.setBlockAndUpdate(pos, (BlockState)state.setValue(BARREL_STATE, (Comparable)((Object)BarrelState.TAPPED)));
        barrelEntity.tap();
        world.playSound(null, pos, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
        CustomData comp = (CustomData)ctx.getItemInHand().get(DataComponents.BLOCK_ENTITY_DATA);
        if (comp != null) {
            long tapTime;
            CompoundTag nbt = comp.copyTag();
            boolean inventoryEmpty = nbt.getList("Inventory", 10).isEmpty();
            long fluidAmount = nbt.getLong("FluidAmount");
            long sealTime = nbt.contains("SealTime", 4) ? nbt.getLong("SealTime") : -1L;
            long l = tapTime = nbt.contains("TapTime", 4) ? nbt.getLong("TapTime") : -1L;
            BarrelState barrelState = tapTime > -1L ? BarrelState.TAPPED : (sealTime > -1L ? BarrelState.SEALED : (inventoryEmpty && fluidAmount == 0L ? BarrelState.EMPTY : BarrelState.FILLED));
            state = (BlockState)state.setValue(BARREL_STATE, (Comparable)((Object)barrelState));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BARREL_STATE});
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TitrationBarrelBlockEntity) {
            TitrationBarrelBlockEntity blockEntity2 = (TitrationBarrelBlockEntity)blockEntity;
            switch (((BarrelState)((Object)state.getValue(BARREL_STATE))).ordinal()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    int isNotEmpty = blockEntity2.inventory.isEmpty() ? 0 : 1;
                    float icurr = InventoryHelper.countItemsInInventory((IItemHandlerModifiable)blockEntity2.inventory);
                    float imax = 64.0f;
                    float fcurr = blockEntity2.tank.getFluidAmount();
                    float fmax = blockEntity2.tank.getCapacity();
                    return Mth.floor((float)((icurr / imax + fcurr / fmax) / 2.0f * 14.0f)) + isNotEmpty;
                }
                case 2: {
                    return 15;
                }
                case 3: {
                    Biome biome = (Biome)world.getBiome(pos).value();
                    Optional<RecipeHolder<ITitrationBarrelRecipe>> recipe = blockEntity2.getRecipeForInventory(world);
                    if (recipe.isEmpty()) {
                        return 0;
                    }
                    float curr = blockEntity2.extractedBottles;
                    float max = ((ITitrationBarrelRecipe)recipe.get().value()).getOutputCountAfterAngelsShare(world, biome.getBaseTemperature(), blockEntity2.getSealSeconds());
                    return Mth.floor((float)((1.0f - curr / max) * 15.0f));
                }
            }
        }
        return 0;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!newState.is((Block)this) && state.getValue(BARREL_STATE) == BarrelState.FILLED) {
            TitrationBarrelBlock.scatterContents(world, pos);
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public static void scatterContents(@NotNull Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TitrationBarrelBlockEntity) {
            TitrationBarrelBlockEntity titrationBarrelBlockEntity = (TitrationBarrelBlockEntity)blockEntity;
            Containers.dropContents((Level)world, (BlockPos)pos, titrationBarrelBlockEntity.inventory.getInternalList());
        }
    }

    public static enum BarrelState implements StringRepresentable
    {
        EMPTY,
        FILLED,
        SEALED,
        TAPPED;


        public String getSerializedName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

