/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.chests.PastelChestBlock;
import earth.terrarium.pastel.blocks.chests.PastelChestBlockEntity;
import earth.terrarium.pastel.blocks.structure.TreasureChestBlockEntity;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TreasureChestBlock
extends PastelChestBlock {
    public static final MapCodec<TreasureChestBlock> CODEC = TreasureChestBlock.simpleCodec(TreasureChestBlock::new);

    public TreasureChestBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends TreasureChestBlock> codec() {
        return CODEC;
    }

    @Override
    public void openScreen(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TreasureChestBlockEntity) {
            TreasureChestBlockEntity treasureChestBlockEntity = (TreasureChestBlockEntity)blockEntity;
            if (!TreasureChestBlock.isChestBlocked((LevelAccessor)world, pos)) {
                if (treasureChestBlockEntity.canOpen(player)) {
                    player.openMenu((MenuProvider)treasureChestBlockEntity);
                } else {
                    world.playSound(null, pos, SoundEvents.CHEST_LOCKED, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TreasureChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? TreasureChestBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.PRESERVATION_CHEST.get()), PastelChestBlockEntity::clientTick) : null;
    }

    @Override
    public Material getTextureLocation() {
        return new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/preservation_chest"));
    }
}

