/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.item_roundel.ItemRoundelBlock;
import earth.terrarium.pastel.blocks.item_roundel.ItemRoundelBlockEntity;
import earth.terrarium.pastel.blocks.structure.PreservationRoundelBlockEntity;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class PreservationRoundelBlock
extends ItemRoundelBlock {
    public static final MapCodec<PreservationRoundelBlock> CODEC = PreservationRoundelBlock.simpleCodec(PreservationRoundelBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public PreservationRoundelBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public MapCodec<? extends PreservationRoundelBlock> codec() {
        return CODEC;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PreservationRoundelBlockEntity(pos, state);
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ItemRoundelBlockEntity) {
            ItemRoundelBlockEntity itemRoundelBlockEntity = (ItemRoundelBlockEntity)blockEntity;
            if (player.isShiftKeyDown() || handStack.isEmpty()) {
                this.retrieveLastStack(world, pos, player, hand, handStack, itemRoundelBlockEntity);
            } else {
                int countBefore = handStack.getCount();
                ItemStack leftoverStack = InventoryHelper.addToInventoryUpToSingleStackWithMaxTotalCount(handStack, (IItemHandlerModifiable)itemRoundelBlockEntity.getInventory(), 6);
                player.setItemInHand(hand, leftoverStack);
                if (countBefore != leftoverStack.getCount()) {
                    world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.8f, 0.8f + world.random.nextFloat() * 0.6f);
                }
            }
            blockEntity.setChanged();
            itemRoundelBlockEntity.updateInClientWorld();
        }
        return ItemInteractionResult.CONSUME;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

