/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.structure.PreservationControllerBlockEntity;
import earth.terrarium.pastel.helpers.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;

public class PreservationControllerBlockEntityRenderer
implements BlockEntityRenderer<PreservationControllerBlockEntity> {
    private static final ResourceLocation AETHER_CORE = PastelCommon.locate("textures/block/preservation_controller_aether.png");
    protected static EntityRenderDispatcher dispatcher;

    public PreservationControllerBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
    }

    public void render(PreservationControllerBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        matrices.translate(0.5, 0.5, 0.5);
        matrices.mulPose(PreservationControllerBlockEntityRenderer.dispatcher.camera.rotation());
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.entityTranslucent((ResourceLocation)AETHER_CORE));
        float time = (float)(entity.getLevel().getGameTime() % 24000L) + tickDelta;
        matrices.mulPose(Axis.ZP.rotationDegrees(time / 1.5f));
        float pulse = (float)Math.sin(time / 19.0f);
        float scale = pulse * 0.2f + 0.8f;
        matrices.scale(scale, scale, scale);
        RenderHelper.renderFlatTrans(matrices, buffer, false, 15.0f, pulse * 0.25f + 0.75f, 0.0f, overlay);
        matrices.popPose();
    }
}

