/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.structure.DikeGateBlock;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.status_effects.SleepStatusEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DreamGateBlock
extends DikeGateBlock {
    public static final MapCodec<DreamGateBlock> CODEC = DreamGateBlock.simpleCodec(DreamGateBlock::new);

    public DreamGateBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends DreamGateBlock> codec() {
        return CODEC;
    }

    @Override
    @Deprecated
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityShapeContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityShapeContext = (EntityCollisionContext)context).getEntity()) instanceof LivingEntity) {
            Player player;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof Player && (player = (Player)entity).isCreative()) {
                return Shapes.empty();
            }
            float sleep = SleepStatusEffect.getGeneralSleepResistanceIfEntityHasSoporificEffect(livingEntity);
            if (sleep != -1.0f) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)entity;
                    Support.grantAdvancementCriterion(player2, "lategame/enter_strange_preservation_ruin", "enter_dream_gate");
                }
                return Shapes.empty();
            }
        }
        return Shapes.block();
    }

    @Override
    public void punishEntityWithoutAzureDike(BlockGetter world, BlockPos pos, Entity entity, boolean decreasedSounds) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (entity instanceof LivingEntity) {
                float sleep;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (player.getAbilities().instabuild) {
                        return;
                    }
                }
                if ((sleep = SleepStatusEffect.getGeneralSleepResistanceIfEntityHasSoporificEffect(livingEntity)) == -1.0f && serverWorld.getGameTime() % 5L == 0L) {
                    entity.hurt(PastelDamageTypes.sleep((Level)serverWorld, null), 2.0f);
                    PlayParticleWithExactVelocityPayload.playParticles(serverWorld, pos, (ParticleOptions)PastelParticleTypes.AZURE_DIKE_RUNES, 10);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
                        if (!decreasedSounds || ((ServerLevel)world).getGameTime() % 10L == 0L) {
                            serverPlayerEntity.playNotifySound(PastelSounds.USE_FAIL, SoundSource.PLAYERS, 0.75f, 1.0f);
                        }
                    }
                }
            }
        }
    }
}

