/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import earth.terrarium.pastel.blocks.structure.DeepLightBlock;
import earth.terrarium.pastel.blocks.structure.DeepLightBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class DeepLightBlockEntityRenderer
implements BlockEntityRenderer<DeepLightBlockEntity> {
    protected static EntityRenderDispatcher dispatcher;
    private final Font textRenderer;
    private final List<Component> text;

    public DeepLightBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.textRenderer = Minecraft.getInstance().font;
        this.text = new ArrayList<Component>();
        dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        for (int i = 0; i < 9; ++i) {
            this.text.add((Component)Component.translatable((String)("block.pastel.deep_light_chiseled_preservation_stone.puzzle" + i)));
        }
    }

    public void render(DeepLightBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (Math.sqrt(Minecraft.getInstance().player.distanceToSqr(entity.getBlockPos().getCenter())) > 6.0) {
            return;
        }
        matrices.pushPose();
        float time = (float)(entity.getLevel().getGameTime() % 24000L) + tickDelta;
        double bob = Math.sin(time / 37.0f) * 0.05;
        float f = ((Direction)entity.getBlockState().getValue((Property)DeepLightBlock.FACING)).toYRot();
        matrices.translate(0.5, 0.0, 0.5);
        matrices.mulPose(Axis.YP.rotationDegrees(-f));
        matrices.translate(1.3, 1.4 + bob, -0.7);
        matrices.scale(0.00875f, 0.00875f, 0.00875f);
        double interp = Mth.clamp((double)(Math.sqrt(Minecraft.getInstance().player.distanceToSqr(entity.getBlockPos().getCenter())) / 8.0), (double)0.0, (double)1.0) * 1.25;
        int alpha = (int)Mth.clampedLerp((double)255.0, (double)2.0, (double)interp);
        matrices.mulPose(Axis.ZP.rotationDegrees(180.0f));
        for (int i = 0; i < this.text.size(); ++i) {
            this.textRenderer.drawInBatch(this.text.get(i), 0.0f, (float)(14 * i + (i == 0 ? -20 : 0)), (alpha & 0xFF) << 24 | 0xE9C4FF, false, matrices.last().pose(), vertexConsumers, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        }
        matrices.popPose();
    }
}

