/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.spirit_instiller;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;

public class SpiritInstillerBlockEntityRenderer
implements BlockEntityRenderer<SpiritInstillerBlockEntity> {
    private static final Material SPRITE = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/spirit_instiller"));
    protected final double ITEM_STACK_RENDER_HEIGHT = 0.95f;
    private final ModelPart head;
    private final ModelPart spectralblossom;
    private final ModelPart geode;
    private final ModelPart calcite;
    private final ModelPart innergeode;

    public SpiritInstillerBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart root = SpiritInstillerBlockEntityRenderer.getTexturedModelData().bakeRoot();
        this.head = root.getChild("head");
        this.spectralblossom = root.getChild("spectralblossom");
        this.geode = root.getChild("geode");
        this.calcite = this.geode.getChild("calcite");
        this.innergeode = this.calcite.getChild("innergeode");
    }

    public void render(SpiritInstillerBlockEntity instiller, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (instiller.animator == null) {
            return;
        }
        long time = instiller.getLevel().getGameTime() % 1000000L;
        instiller.animator.animate(tickDelta, time);
        ItemStack stack = instiller.getItem(0);
        if (instiller.getMultiblockRotation() != null) {
            int rotation;
            Rotation itemFacingDirection = instiller.getMultiblockRotation();
            switch (itemFacingDirection) {
                default: {
                    throw new MatchException(null, null);
                }
                case NONE: {
                    int n = 0;
                    break;
                }
                case CLOCKWISE_90: {
                    int n = -90;
                    break;
                }
                case CLOCKWISE_180: {
                    int n = 180;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    int n = rotation = 90;
                }
            }
            if (!stack.isEmpty()) {
                matrices.pushPose();
                matrices.translate(0.5, (double)(1.0f + instiller._platformY.get().floatValue() / 16.0f), 0.5);
                matrices.mulPose(Axis.YP.rotationDegrees((float)((double)rotation - Math.toDegrees(instiller.platform))));
                matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
                matrices.translate(-0.0, -0.1, 0.0);
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, matrices, vertexConsumers, instiller.getLevel(), 0);
                matrices.popPose();
            }
            matrices.pushPose();
            int haloAlpha = FastColor.ARGB32.color((int)Math.round(instiller._haloAlpha.get().floatValue() * 255.0f), (int)0xFFFFFF);
            int blossomAlpha = FastColor.ARGB32.color((int)Math.round(instiller._blossomAlpha.get().floatValue() * 255.0f), (int)0xFFFFFF);
            matrices.translate(0.5, 1.5, 0.5);
            matrices.mulPose(Axis.YP.rotationDegrees((float)rotation));
            matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
            VertexConsumer vertices = SPRITE.buffer(vertexConsumers, RenderType::entityTranslucent);
            instiller.platform += (float)Math.toRadians(instiller._platformSpin.get().floatValue());
            this.head.y = 9.5f - instiller._platformY.get().floatValue();
            this.head.yRot = instiller.platform;
            this.head.render(matrices, vertices, light, overlay);
            if (instiller._blossomAlpha.get().floatValue() > 0.0f) {
                this.spectralblossom.y = -25.0f - instiller._haloY.get().floatValue();
                this.spectralblossom.render(matrices, vertices, 0xF000F0, overlay, blossomAlpha);
            }
            if (instiller._haloAlpha.get().floatValue() > 0.0f) {
                this.geode.y = -25.0f - instiller._haloY.get().floatValue();
                instiller.geode += (float)Math.toRadians(instiller._haloSpin.get().floatValue());
                instiller.calcite += (float)Math.toRadians((double)(-instiller._haloSpin.get().floatValue()) * 1.25);
                instiller.innergeode += (float)Math.toRadians((double)instiller._haloSpin.get().floatValue() * 1.4);
                this.geode.zRot = instiller.geode;
                this.calcite.zRot = instiller.calcite;
                this.innergeode.zRot = instiller.innergeode;
                this.geode.render(matrices, vertices, 0xF000F0, overlay, haloAlpha);
            }
            matrices.popPose();
        }
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition head = modelPartData.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)9.5f, (float)0.0f));
        head.addOrReplaceChild("pedestal_r1", CubeListBuilder.create().texOffs(43, 38).addBox(-7.5f, -1.5f, -7.5f, 15.0f, 3.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.025f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        modelPartData.addOrReplaceChild("spectralblossom", CubeListBuilder.create().texOffs(58, 24).addBox(-6.5f, -6.5f, 0.0f, 13.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-25.0f, (float)0.0f));
        PartDefinition geode = modelPartData.addOrReplaceChild("geode", CubeListBuilder.create().texOffs(0, 24).addBox(-14.5f, -14.5f, 0.0f, 29.0f, 29.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-25.0f, (float)0.0f));
        PartDefinition calcite = geode.addOrReplaceChild("calcite", CubeListBuilder.create().texOffs(0, 56).addBox(-12.5f, -12.5f, 1.0f, 25.0f, 25.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.25f));
        calcite.addOrReplaceChild("innergeode", CubeListBuilder.create().texOffs(50, 56).addBox(-10.5f, -10.5f, 3.0f, 21.0f, 21.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-0.75f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }
}

