/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.spirit_instiller;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.MultiblockCrafter;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.blocks.InWorldInteractionBlockEntity;
import earth.terrarium.pastel.blocks.decoration.GemstoneChimeBlock;
import earth.terrarium.pastel.blocks.item_bowl.ItemBowlBlockEntity;
import earth.terrarium.pastel.blocks.spirit_instiller.SpiritInstillerBlock;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.PlayBlockBoundSoundInstancePayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.recipe.InstanceRecipeInput;
import earth.terrarium.pastel.recipe.spirit_instiller.SpiritInstillerRecipe;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.render.animation.FlowAnimator;
import earth.terrarium.pastel.render.animation.FlowData;
import earth.terrarium.pastel.render.animation.FlowHandlers;
import earth.terrarium.pastel.render.animation.FlowStates;
import earth.terrarium.pastel.render.animation.Interpolation;
import earth.terrarium.pastel.render.animation.KeyFrame;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class SpiritInstillerBlockEntity
extends InWorldInteractionBlockEntity
implements MultiblockCrafter,
SidedCapabilityProvider {
    private static final FlowAnimator.Factory<SpiritInstillerBlockEntity> FACTORY;
    private static final KeyFrame<Float> platformPos;
    protected static final int INVENTORY_SIZE = 3;
    public static final List<Vec3i> itemBowlOffsetsHorizontal;
    public static final List<Vec3i> itemBowlOffsetsVertical;
    private static final ResourceLocation JADE_VINE_CROSSBREEDING;
    private boolean inventoryChanged;
    private UUID ownerUUID;
    private Upgradeable.UpgradeHolder upgrades;
    private Rotation multiblockRotation = Rotation.NONE;
    private RecipeHolder<SpiritInstillerRecipe> currentRecipe;
    private int craftingTime;
    private int craftingTimeTotal;
    private boolean validStructure;
    protected FlowAnimator animator;
    protected FlowData<Float> _platformY = FlowData.NULL();
    protected FlowData<Float> _haloY = FlowData.NULL();
    protected FlowData<Float> _platformSpin = FlowData.NULL();
    protected FlowData<Float> _haloSpin = FlowData.NULL();
    protected FlowData<Float> _haloAlpha = FlowData.NULL();
    protected FlowData<Float> _blossomAlpha = FlowData.NULL();
    protected float platform;
    protected float geode;
    protected float calcite;
    protected float innergeode;

    public SpiritInstillerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.SPIRIT_INSTILLER.get(), pos, state, 3);
        this.inventory.addListener(i -> this.inventoryChanged());
    }

    public static void clientTick(Level world, BlockPos blockPos, BlockState blockState, @NotNull SpiritInstillerBlockEntity instiller) {
        if (instiller.animator == null) {
            instiller.animator = FACTORY.create(FlowStates.INIT, instiller);
        } else {
            instiller.updateAnimator();
        }
        if (instiller.currentRecipe != null && world.getGameTime() % 43L == 0L) {
            instiller.doChimeParticles(world);
        }
    }

    private void updateAnimator() {
        this.animator.tick();
        if (!this.validStructure) {
            this.animator.swapState(FlowStates.MB_INVALID);
            return;
        }
        if (this.getItem(0).isEmpty()) {
            this.animator.swapState(FlowStates.INACTIVE);
        } else if (this.currentRecipe != null) {
            this.animator.swapState(FlowStates.ACTIVE);
        } else {
            this.animator.swapState(FlowStates.IDLE);
        }
    }

    public static void serverTick(Level world, BlockPos blockPos, BlockState blockState, SpiritInstillerBlockEntity blockEntity) {
        if (blockEntity.upgrades == null) {
            blockEntity.calculateUpgrades();
        }
        if (blockEntity.inventoryChanged) {
            RecipeHolder<SpiritInstillerRecipe> previousRecipe = blockEntity.currentRecipe;
            SpiritInstillerBlockEntity.calculateCurrentRecipe(world, blockEntity);
            if (blockEntity.currentRecipe != previousRecipe) {
                blockEntity.craftingTime = 0;
                if (blockEntity.currentRecipe == null) {
                    PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((ServerLevel)world, blockEntity.worldPosition);
                } else {
                    blockEntity.craftingTimeTotal = (int)Math.ceil((float)((SpiritInstillerRecipe)blockEntity.currentRecipe.value()).getCraftingTime() / blockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
                }
                blockEntity.updateInClientWorld();
            }
            blockEntity.inventoryChanged = false;
        }
        if (blockEntity.currentRecipe == null) {
            return;
        }
        if (blockEntity.craftingTime % 60 == 0 && !SpiritInstillerBlockEntity.checkRecipeRequirements(world, blockPos, blockEntity)) {
            blockEntity.craftingTime = 0;
            blockEntity.setChanged();
            PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((ServerLevel)world, blockEntity.worldPosition);
            return;
        }
        if (blockEntity.currentRecipe != null) {
            ++blockEntity.craftingTime;
            if (blockEntity.craftingTime == 1) {
                PlayBlockBoundSoundInstancePayload.sendPlayBlockBoundSoundInstance(PastelSounds.SPIRIT_INSTILLER_CRAFTING, (ServerLevel)world, blockEntity.worldPosition, Integer.MAX_VALUE);
            } else if ((double)blockEntity.craftingTime == (double)blockEntity.craftingTimeTotal * 0.01 || (double)blockEntity.craftingTime == Math.floor((double)blockEntity.craftingTimeTotal * 0.25) || (double)blockEntity.craftingTime == Math.floor((double)blockEntity.craftingTimeTotal * 0.5) || (double)blockEntity.craftingTime == Math.floor((double)blockEntity.craftingTimeTotal * 0.75) || (double)blockEntity.craftingTime == Math.floor((double)blockEntity.craftingTimeTotal * 0.83) || (double)blockEntity.craftingTime == Math.floor((double)blockEntity.craftingTimeTotal * 0.9) || (double)blockEntity.craftingTime == Math.floor((double)blockEntity.craftingTimeTotal * 0.95) || (double)blockEntity.craftingTime == Math.floor((double)blockEntity.craftingTimeTotal * 0.98) || (double)blockEntity.craftingTime == Math.floor((double)blockEntity.craftingTimeTotal * 0.99)) {
                blockEntity.doItemBowlOrbs(world);
            } else if (blockEntity.craftingTime == blockEntity.craftingTimeTotal) {
                SpiritInstillerBlockEntity.craftSpiritInstillerRecipe(world, blockEntity, blockEntity.currentRecipe);
            }
            blockEntity.setChanged();
        }
    }

    private static void calculateCurrentRecipe(@NotNull Level world, @NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        ItemStack instillerStack = spiritInstillerBlockEntity.getItem(0);
        if (!instillerStack.isEmpty()) {
            ItemBowlBlockEntity itemBowlBlockEntity;
            spiritInstillerBlockEntity.setItem(0, instillerStack);
            BlockEntity blockEntity = world.getBlockEntity(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, false));
            if (blockEntity instanceof ItemBowlBlockEntity) {
                itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
                spiritInstillerBlockEntity.setItem(1, itemBowlBlockEntity.getItem(0));
            } else {
                spiritInstillerBlockEntity.setItem(1, ItemStack.EMPTY);
            }
            blockEntity = world.getBlockEntity(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, true));
            if (blockEntity instanceof ItemBowlBlockEntity) {
                itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
                spiritInstillerBlockEntity.setItem(2, itemBowlBlockEntity.getItem(0));
            } else {
                spiritInstillerBlockEntity.setItem(2, ItemStack.EMPTY);
            }
            if (spiritInstillerBlockEntity.currentRecipe != null && !spiritInstillerBlockEntity.isEmpty() && ((SpiritInstillerRecipe)spiritInstillerBlockEntity.currentRecipe.value()).matches(spiritInstillerBlockEntity.getRecipeInput(), world)) {
                return;
            }
            spiritInstillerBlockEntity.craftingTime = 0;
            spiritInstillerBlockEntity.currentRecipe = null;
            RecipeHolder spiritInstillerRecipe = world.getRecipeManager().getRecipeFor(PastelRecipeTypes.SPIRIT_INSTILLING, spiritInstillerBlockEntity.getRecipeInput(), world).orElse(null);
            if (spiritInstillerRecipe != null) {
                spiritInstillerBlockEntity.currentRecipe = spiritInstillerRecipe;
                spiritInstillerBlockEntity.craftingTimeTotal = (int)Math.ceil((float)((SpiritInstillerRecipe)spiritInstillerRecipe.value()).getCraftingTime() / spiritInstillerBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
            }
        }
        spiritInstillerBlockEntity.updateInClientWorld();
    }

    public static BlockPos getItemBowlPos(@NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity, boolean right) {
        BlockPos blockPos = spiritInstillerBlockEntity.worldPosition;
        switch (spiritInstillerBlockEntity.multiblockRotation) {
            case NONE: 
            case CLOCKWISE_180: {
                if (right) {
                    return blockPos.above().east(2);
                }
                return blockPos.above().west(2);
            }
        }
        if (right) {
            return blockPos.above().north(2);
        }
        return blockPos.above().south(2);
    }

    private static boolean checkRecipeRequirements(Level world, BlockPos blockPos, @NotNull SpiritInstillerBlockEntity instiller) {
        Player lastInteractedPlayer = PlayerOwned.getPlayerEntityIfOnline(instiller.ownerUUID);
        if (lastInteractedPlayer == null) {
            return false;
        }
        boolean playerCanCraft = true;
        if (instiller.currentRecipe != null) {
            playerCanCraft = ((SpiritInstillerRecipe)instiller.currentRecipe.value()).canPlayerCraft(lastInteractedPlayer);
        }
        boolean structureComplete = SpiritInstillerBlock.verifyStructure(world, blockPos, null, instiller);
        boolean canCraft = true;
        if (!playerCanCraft || !structureComplete) {
            if (!structureComplete) {
                world.playSound(null, instiller.getBlockPos(), PastelSounds.CRAFTING_ABORTED, SoundSource.BLOCKS, 0.9f + world.random.nextFloat() * 0.2f, 0.9f + world.random.nextFloat() * 0.2f);
            }
            canCraft = false;
        }
        if (lastInteractedPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)lastInteractedPlayer;
            SpiritInstillerBlockEntity.testAndUnlockRecipeAdvancements(serverPlayerEntity, instiller.currentRecipe, canCraft);
        }
        return canCraft & ((SpiritInstillerRecipe)instiller.currentRecipe.value()).canPlayerCraft(lastInteractedPlayer) && ((SpiritInstillerRecipe)instiller.currentRecipe.value()).canCraftWithStacks(instiller.getRecipeInput(), instiller.level);
    }

    public static void testAndUnlockRecipeAdvancements(ServerPlayer player, RecipeHolder<SpiritInstillerRecipe> spiritInstillerRecipe, boolean canActuallyCraft) {
        boolean isBossMenory;
        boolean bl = isBossMenory = ((SpiritInstillerRecipe)spiritInstillerRecipe.value()).getGroup() != null && ((SpiritInstillerRecipe)spiritInstillerRecipe.value()).getGroup().equals("boss_memories");
        if (isBossMenory) {
            if (canActuallyCraft) {
                Support.grantAdvancementCriterion(player, "midgame/craft_blacklisted_memory_success", "succeed_crafting_boss_memory");
            } else {
                Support.grantAdvancementCriterion(player, "midgame/craft_blacklisted_memory_fail", "fail_to_craft_boss_memory");
            }
        }
        if (spiritInstillerRecipe.id().equals((Object)JADE_VINE_CROSSBREEDING)) {
            Support.grantAdvancementCriterion(player, "lategame/create_jade_vine", "crossbred_jade_vine_bulb");
        }
    }

    public static void craftSpiritInstillerRecipe(Level world, @NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity, @NotNull RecipeHolder<SpiritInstillerRecipe> spiritInstillerRecipe) {
        ItemStack resultStack = ((SpiritInstillerRecipe)spiritInstillerRecipe.value()).assemble(spiritInstillerBlockEntity.getRecipeInput(), (HolderLookup.Provider)world.registryAccess());
        SpiritInstillerBlockEntity.decrementItemsInInstillerAndBowls(spiritInstillerBlockEntity);
        if (!resultStack.isEmpty()) {
            if (spiritInstillerBlockEntity.getItem(0).isEmpty()) {
                spiritInstillerBlockEntity.setItem(0, resultStack);
            } else {
                MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, spiritInstillerBlockEntity.worldPosition, resultStack, resultStack.getCount(), MultiblockCrafter.RECIPE_STACK_VELOCITY);
            }
        }
        SpiritInstillerBlockEntity.playCraftingFinishedEffects(spiritInstillerBlockEntity);
        spiritInstillerBlockEntity.craftingTime = 0;
        spiritInstillerBlockEntity.inventoryChanged();
    }

    public static void decrementItemsInInstillerAndBowls(@NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        Level world = spiritInstillerBlockEntity.getLevel();
        if (world == null) {
            return;
        }
        RecipeHolder<SpiritInstillerRecipe> recipe = spiritInstillerBlockEntity.currentRecipe;
        double efficiencyModifier = 1.0;
        if (!((SpiritInstillerRecipe)recipe.value()).areYieldAndEfficiencyUpgradesDisabled() && (double)spiritInstillerBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY) != 1.0) {
            efficiencyModifier = 1.0 / (double)spiritInstillerBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
        }
        BlockEntity leftBowlBlockEntity = world.getBlockEntity(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, false));
        BlockEntity rightBowlBlockEntity = world.getBlockEntity(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, true));
        if (leftBowlBlockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity leftBowl = (ItemBowlBlockEntity)leftBowlBlockEntity;
            if (rightBowlBlockEntity instanceof ItemBowlBlockEntity) {
                ItemBowlBlockEntity rightBowl = (ItemBowlBlockEntity)rightBowlBlockEntity;
                int decreasedAmountAfterEfficiencyMod = Support.chanceRound((double)((SpiritInstillerRecipe)recipe.value()).getIngredientStacks().get(0).getCount() * efficiencyModifier, world.random);
                if (decreasedAmountAfterEfficiencyMod > 0) {
                    spiritInstillerBlockEntity.getItem(0).shrink(decreasedAmountAfterEfficiencyMod);
                }
                List<IngredientStack> ingredientStacks = ((SpiritInstillerRecipe)recipe.value()).getIngredientStacks();
                int amountAfterEfficiencyModFirst = Support.chanceRound((double)ingredientStacks.get(1).getCount() * efficiencyModifier, world.random);
                int amountAfterEfficiencyModSecond = Support.chanceRound((double)ingredientStacks.get(2).getCount() * efficiencyModifier, world.random);
                boolean leftIsFirstIngredient = ingredientStacks.get(1).test(leftBowl.getItem(0));
                Vec3 particlePos = new Vec3((double)spiritInstillerBlockEntity.worldPosition.getX() + 0.5, (double)(spiritInstillerBlockEntity.worldPosition.getY() + 1), (double)spiritInstillerBlockEntity.worldPosition.getZ() + 0.5);
                if (leftIsFirstIngredient) {
                    if (amountAfterEfficiencyModFirst > 0) {
                        leftBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModFirst, true);
                    }
                    if (amountAfterEfficiencyModSecond > 0) {
                        rightBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModSecond, true);
                    }
                } else {
                    if (amountAfterEfficiencyModFirst > 0) {
                        rightBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModFirst, true);
                    }
                    if (amountAfterEfficiencyModSecond > 0) {
                        leftBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModSecond, true);
                    }
                }
            }
        }
    }

    public static void playCraftingFinishedEffects(@NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        Level world = spiritInstillerBlockEntity.getLevel();
        if (world == null) {
            return;
        }
        world.playSound(null, spiritInstillerBlockEntity.worldPosition, PastelSounds.SPIRIT_INSTILLER_CRAFTING_FINISHED, SoundSource.BLOCKS, 1.0f, 1.0f);
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)world, new Vec3((double)spiritInstillerBlockEntity.worldPosition.getX() + 0.5, (double)spiritInstillerBlockEntity.worldPosition.getY() + 0.5, (double)spiritInstillerBlockEntity.worldPosition.getZ() + 0.5), ColoredCraftingParticleEffect.LIGHT_BLUE, 75, new Vec3(0.5, 0.5, 0.5), new Vec3(0.1, -0.1, 0.1));
    }

    public void setValidStructure(boolean validStructure) {
        if (!this.level.isClientSide()) {
            this.validStructure = validStructure;
            this.setChanged();
            this.updateInClientWorld();
        }
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.craftingTime = nbt.getShort("CraftingTime");
        this.craftingTimeTotal = nbt.getShort("CraftingTimeTotal");
        this.inventoryChanged = true;
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.validStructure = nbt.getBoolean("validStructure");
        if (nbt.contains("MultiblockRotation")) {
            try {
                this.multiblockRotation = Rotation.valueOf((String)nbt.getString("MultiblockRotation").toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.multiblockRotation = Rotation.NONE;
            }
        }
        if (nbt.contains("platformSpin")) {
            this.platform = nbt.getFloat("platformSpin");
        }
        this.currentRecipe = MultiblockCrafter.getRecipeEntryFromNbt(this.level, nbt, SpiritInstillerRecipe.class);
        this.upgrades = nbt.contains("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.getList("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putShort("CraftingTime", (short)this.craftingTime);
        nbt.putShort("CraftingTimeTotal", (short)this.craftingTimeTotal);
        nbt.putString("MultiblockRotation", this.multiblockRotation.toString());
        nbt.putBoolean("validStructure", this.validStructure);
        if (this.upgrades != null) {
            nbt.put("Upgrades", (Tag)this.upgrades.toNbt());
        }
        if (this.platform != 0.0f) {
            nbt.putFloat("platformSpin", this.platform);
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.currentRecipe != null) {
            nbt.putString("CurrentRecipe", this.currentRecipe.id().toString());
        }
    }

    private void doChimeParticles(@NotNull Level world) {
        this.doChimeInstillingParticles(world, this.worldPosition.offset(this.getItemBowlHorizontalPositionOffset(false).above(3)));
        this.doChimeInstillingParticles(world, this.worldPosition.offset(this.getItemBowlHorizontalPositionOffset(true).above(3)));
    }

    public void doChimeInstillingParticles(@NotNull Level world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof GemstoneChimeBlock) {
            GemstoneChimeBlock gemstoneChimeBlock = (GemstoneChimeBlock)block;
            RandomSource random = world.random;
            ParticleOptions particleEffect = gemstoneChimeBlock.getParticleEffect();
            for (int i = 0; i < 12; ++i) {
                world.addParticle(particleEffect, (double)pos.getX() + 0.25 + random.nextDouble() * 0.5, (double)pos.getY() + 0.15 + random.nextDouble() * 0.5, (double)pos.getZ() + 0.25 + random.nextDouble() * 0.5, 0.06 - random.nextDouble() * 0.12, -0.1 - random.nextDouble() * 0.05, 0.06 - random.nextDouble() * 0.12);
            }
        }
    }

    private void doItemBowlOrbs(@NotNull Level world) {
        ItemBowlBlockEntity itemBowlBlockEntity;
        BlockPos itemBowlPos = this.worldPosition.offset(this.getItemBowlHorizontalPositionOffset(false).above());
        BlockEntity blockEntity = world.getBlockEntity(itemBowlPos);
        if (blockEntity instanceof ItemBowlBlockEntity) {
            itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            itemBowlBlockEntity.spawnOrbParticles(new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0 + (double)platformPos.at(0.0f, world.getGameTime()).floatValue() / 16.0, (double)this.worldPosition.getZ() + 0.5));
        }
        if ((blockEntity = world.getBlockEntity(itemBowlPos = this.worldPosition.offset(this.getItemBowlHorizontalPositionOffset(true).above()))) instanceof ItemBowlBlockEntity) {
            itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            itemBowlBlockEntity.spawnOrbParticles(new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0 + (double)platformPos.at(0.0f, world.getGameTime()).floatValue() / 16.0, (double)this.worldPosition.getZ() + 0.5));
        }
    }

    public Vec3i getItemBowlHorizontalPositionOffset(boolean right) {
        if (this.multiblockRotation == Rotation.NONE || this.multiblockRotation == Rotation.CLOCKWISE_180) {
            return itemBowlOffsetsVertical.get(right ? 1 : 0);
        }
        return itemBowlOffsetsHorizontal.get(right ? 1 : 0);
    }

    public InstanceRecipeInput<SpiritInstillerBlockEntity> getRecipeInput() {
        return new InstanceRecipeInput<SpiritInstillerBlockEntity>((List<ItemStack>)this.inventory.getInternalList(), this);
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.setChanged();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods2(this.level, this.worldPosition, this.multiblockRotation, 4, 1, this.ownerUUID);
        this.setChanged();
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.setChanged();
    }

    public Rotation getMultiblockRotation() {
        return this.multiblockRotation;
    }

    public void setMultiblockRotation(Rotation blockRotation) {
        this.multiblockRotation = blockRotation;
        this.upgrades = null;
        this.setChanged();
    }

    public void inventoryChanged() {
        this.inventoryChanged = true;
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        return new StackHandlerView(this.inventory, 0, 1);
    }

    static {
        platformPos = (tickDelta, time) -> Float.valueOf((float)(Math.sin(((float)time + tickDelta + 15.0f) / 23.0f) + 6.0) * 2.0f);
        itemBowlOffsetsHorizontal = new ArrayList<Vec3i>(){
            {
                this.add(new Vec3i(0, 0, 2));
                this.add(new Vec3i(0, 0, -2));
            }
        };
        itemBowlOffsetsVertical = new ArrayList<Vec3i>(){
            {
                this.add(new Vec3i(2, 0, 0));
                this.add(new Vec3i(-2, 0, 0));
            }
        };
        JADE_VINE_CROSSBREEDING = PastelCommon.locate("spirit_instiller/secret/germinated_jade_vine_crossbreeding");
        FlowAnimator.Builder<SpiritInstillerBlockEntity> builder = new FlowAnimator.Builder<SpiritInstillerBlockEntity>(SpiritInstillerBlockEntity.class);
        builder.stateInfo(FlowStates.MB_INVALID, 11);
        builder.stateInfo(FlowStates.INACTIVE, 27);
        builder.stateInfo(FlowStates.IDLE, 17);
        builder.stateInfo(FlowStates.ACTIVE, 17);
        builder.handle("platformY", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).interpolate(Interpolation.CUBIC_OUT).loopback(FlowStates.MB_INVALID, FlowStates.INACTIVE).forStates((tickDelta, time) -> Float.valueOf((float)(Math.sin(((float)time + tickDelta + 15.0f) / 23.0f) + 4.0)), FlowStates.IDLE).forStates(platformPos, FlowStates.ACTIVE).push();
        builder.handle("haloY", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).interpolate(Interpolation.CUBIC_OUT).startingKeyFrame((tickDelta, time) -> Float.valueOf((float)(Math.sin(((float)time + tickDelta) / 23.0f) + 1.0))).loopback(FlowStates.MB_INVALID, FlowStates.INACTIVE, FlowStates.IDLE).forStates((tickDelta, time) -> Float.valueOf(platformPos.at(tickDelta, time).floatValue() - 34.5f), FlowStates.ACTIVE).push();
        builder.handle("platformSpin", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).loopback(FlowStates.MB_INVALID, FlowStates.INACTIVE).forStates(Float.valueOf(0.25f), FlowStates.IDLE).forStates(Float.valueOf(0.825f), FlowStates.ACTIVE).push();
        builder.handle("haloSpin", FlowHandlers.FLOAT).initial(Float.valueOf(0.15f)).loopback(FlowStates.MB_INVALID, FlowStates.INACTIVE).forStates(Float.valueOf(0.325f), FlowStates.IDLE).forStates(Float.valueOf(0.825f), FlowStates.ACTIVE).push();
        builder.handle("haloAlpha", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).forStates(Float.valueOf(1.0f), FlowStates.INACTIVE, FlowStates.IDLE, FlowStates.ACTIVE).push();
        builder.handle("blossomAlpha", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).interpolate(Interpolation.CUBIC_OUT).loopback(FlowStates.ACTIVE).forStates(Float.valueOf(1.0f), FlowStates.INACTIVE, FlowStates.IDLE).push();
        FACTORY = builder.build();
    }
}

