/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.shooting_star;

import earth.terrarium.pastel.blocks.shooting_star.ShootingStar;
import earth.terrarium.pastel.blocks.shooting_star.ShootingStarBlock;
import earth.terrarium.pastel.components.ShootingStarComponent;
import earth.terrarium.pastel.entity.entity.ShootingStarEntity;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ShootingStarItem
extends BlockItem
implements ShootingStar {
    private final ShootingStar.Variant shootingStarType;

    public ShootingStarItem(ShootingStarBlock block, Item.Properties settings) {
        super((Block)block, settings);
        this.shootingStarType = block.shootingStarType;
    }

    @NotNull
    public static ItemStack getWithRemainingHits(@NotNull ShootingStarItem shootingStarItem, int remainingHits, boolean hardened) {
        return ShootingStarItem.getWithRemainingHits(shootingStarItem.getDefaultInstance(), remainingHits, hardened);
    }

    @NotNull
    public static ItemStack getWithRemainingHits(@NotNull ItemStack stack, int remainingHits, boolean hardened) {
        ShootingStarComponent component = new ShootingStarComponent(remainingHits, hardened);
        stack.set(PastelDataComponentTypes.SHOOTING_STAR, (Object)component);
        return stack;
    }

    public InteractionResult useOn(@NotNull UseOnContext context) {
        if (context.getPlayer().isShiftKeyDown()) {
            return super.useOn(context);
        }
        Level world = context.getLevel();
        if (!world.isClientSide) {
            ItemStack itemStack = context.getItemInHand();
            Vec3 hitPos = context.getClickLocation();
            Player user = context.getPlayer();
            ShootingStarEntity shootingStarEntity = this.getEntityForStack(context.getLevel(), hitPos, itemStack);
            shootingStarEntity.setYRot(user.getYRot());
            if (!world.noCollision((Entity)shootingStarEntity, shootingStarEntity.getBoundingBox())) {
                return InteractionResult.FAIL;
            }
            world.addFreshEntity((Entity)shootingStarEntity);
            world.gameEvent((Entity)user, (Holder)GameEvent.ENTITY_PLACE, context.getClickedPos());
            if (!user.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            user.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    @NotNull
    public ShootingStarEntity getEntityForStack(@NotNull Level world, Vec3 pos, ItemStack stack) {
        return new ShootingStarEntity(world, pos.x, pos.y, pos.z, this.shootingStarType, true, ShootingStarItem.getRemainingHits(stack), ShootingStarItem.isHardened(stack));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (ShootingStarItem.isHardened(stack)) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.shooting_star.tooltip.hardened").withStyle(ChatFormatting.GRAY));
        }
    }

    public ShootingStar.Variant getShootingStarType() {
        return this.shootingStarType;
    }

    public static boolean isHardened(ItemStack stack) {
        return ((ShootingStarComponent)stack.getOrDefault(PastelDataComponentTypes.SHOOTING_STAR, (Object)ShootingStarComponent.DEFAULT)).hardened();
    }

    public static int getRemainingHits(@NotNull ItemStack stack) {
        return ((ShootingStarComponent)stack.getOrDefault(PastelDataComponentTypes.SHOOTING_STAR, (Object)ShootingStarComponent.DEFAULT)).remainingHits();
    }

    public static void setHardened(ItemStack stack) {
        ShootingStarComponent component = (ShootingStarComponent)stack.getOrDefault(PastelDataComponentTypes.SHOOTING_STAR, (Object)ShootingStarComponent.DEFAULT);
        component = component == null ? new ShootingStarComponent(ShootingStarComponent.DEFAULT.remainingHits(), true) : new ShootingStarComponent(component.remainingHits(), true);
        stack.set(PastelDataComponentTypes.SHOOTING_STAR, (Object)component);
    }
}

