/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.shooting_star;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelLootTables;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public interface ShootingStar {

    public static enum Variant implements StringRepresentable
    {
        GLISTERING("glistering", PastelLootTables.GLISTERING_SHOOTING_STAR),
        FIERY("fiery", PastelLootTables.FIERY_SHOOTING_STAR),
        COLORFUL("colorful", PastelLootTables.COLORFUL_SHOOTING_STAR),
        PRISTINE("pristine", PastelLootTables.PRISTINE_SHOOTING_STAR),
        GEMSTONE("gemstone", PastelLootTables.GEMSTONE_SHOOTING_STAR);

        public static Codec<Variant> CODEC;
        public static final StreamCodec<ByteBuf, Variant> STREAM_CODEC;
        private final String name;
        private final ResourceKey<LootTable> lootTable;

        private Variant(String name, ResourceKey<LootTable> lootTable) {
            this.name = name;
            this.lootTable = lootTable;
        }

        public static Variant getWeightedRandomType(@NotNull RandomSource random) {
            int r = random.nextInt(8);
            if (r == 0) {
                return FIERY;
            }
            if (r == 1) {
                return PRISTINE;
            }
            if (r < 3) {
                return GLISTERING;
            }
            if (r < 5) {
                return COLORFUL;
            }
            return GEMSTONE;
        }

        public static Variant getType(int type) {
            Variant[] types = Variant.values();
            if (type < 0 || type >= types.length) {
                type = 0;
            }
            return types[type];
        }

        public static Variant getType(String name) {
            Variant[] types;
            for (Variant type : types = Variant.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return types[0];
        }

        @Contract(value="_ -> new")
        @NotNull
        public static ResourceKey<LootTable> getLootTable(int index) {
            return Variant.values()[index].getLootTable();
        }

        @NotNull
        public ResourceKey<LootTable> getLootTable() {
            return this.lootTable;
        }

        public String getName() {
            return this.name;
        }

        public Block getBlock() {
            switch (this.ordinal()) {
                case 3: {
                    return (Block)PastelBlocks.PRISTINE_SHOOTING_STAR.get();
                }
                case 4: {
                    return (Block)PastelBlocks.GEMSTONE_SHOOTING_STAR.get();
                }
                case 1: {
                    return (Block)PastelBlocks.FIERY_SHOOTING_STAR.get();
                }
                case 2: {
                    return (Block)PastelBlocks.COLORFUL_SHOOTING_STAR.get();
                }
            }
            return (Block)PastelBlocks.GLISTERING_SHOOTING_STAR.get();
        }

        @NotNull
        public Vector3f getRandomParticleColor(RandomSource random) {
            switch (this.ordinal()) {
                case 0: {
                    int r = random.nextInt(5);
                    if (r == 0) {
                        return ColorHelper.getRGBVec(DyeColor.YELLOW);
                    }
                    if (r == 1) {
                        return ColorHelper.getRGBVec(DyeColor.WHITE);
                    }
                    if (r == 2) {
                        return ColorHelper.getRGBVec(DyeColor.ORANGE);
                    }
                    if (r == 3) {
                        return ColorHelper.getRGBVec(DyeColor.LIME);
                    }
                    return ColorHelper.getRGBVec(DyeColor.BLUE);
                }
                case 2: {
                    return ColorHelper.getRGBVec(ColorHelper.VANILLA_DYE_COLORS.get(random.nextInt(ColorHelper.VANILLA_DYE_COLORS.size())));
                }
                case 1: {
                    int r = random.nextInt(2);
                    if (r == 0) {
                        return ColorHelper.getRGBVec(DyeColor.ORANGE);
                    }
                    return ColorHelper.getRGBVec(DyeColor.RED);
                }
                case 3: {
                    int r = random.nextInt(3);
                    if (r == 0) {
                        return ColorHelper.getRGBVec(DyeColor.BLUE);
                    }
                    if (r == 1) {
                        return ColorHelper.getRGBVec(DyeColor.LIGHT_BLUE);
                    }
                    return ColorHelper.getRGBVec(DyeColor.CYAN);
                }
            }
            int r = random.nextInt(4);
            if (r == 0) {
                return ColorHelper.getRGBVec(DyeColor.CYAN);
            }
            if (r == 1) {
                return ColorHelper.getRGBVec(DyeColor.MAGENTA);
            }
            if (r == 2) {
                return ColorHelper.getRGBVec(DyeColor.WHITE);
            }
            return ColorHelper.getRGBVec(DyeColor.YELLOW);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            STREAM_CODEC = PacketCodecHelper.enumOf(Variant::values);
        }
    }
}

