/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class RedstoneInteractionBlock
extends Block {
    public static final MapCodec<RedstoneInteractionBlock> CODEC = RedstoneInteractionBlock.simpleCodec(RedstoneInteractionBlock::new);
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    public static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;

    public RedstoneInteractionBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(ORIENTATION, (Comparable)FrontAndTop.EAST_UP)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends RedstoneInteractionBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(ORIENTATION, (Comparable)rotation.rotation().rotate((FrontAndTop)state.getValue(ORIENTATION)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(ORIENTATION, (Comparable)mirror.rotation().rotate((FrontAndTop)state.getValue(ORIENTATION)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ORIENTATION, TRIGGERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getNearestLookingDirection().getOpposite();
        Direction direction2 = switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> ctx.getPlayer().getDirection().getOpposite();
            case Direction.UP -> ctx.getPlayer().getDirection();
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Direction.UP;
        };
        return (BlockState)((BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)direction, (Direction)direction2))).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(ctx.getLevel().hasNeighborSignal(ctx.getClickedPos())));
    }
}

