/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RedstoneGravityBlock
extends FallingBlock {
    public static final MapCodec<RedstoneGravityBlock> CODEC = RedstoneGravityBlock.simpleCodec(RedstoneGravityBlock::new);
    public static final BooleanProperty UNSTABLE = BooleanProperty.create((String)"unstable");

    public RedstoneGravityBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends RedstoneGravityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{UNSTABLE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        if (ctx.getLevel().getBestNeighborSignal(ctx.getClickedPos()) > 0 && RedstoneGravityBlock.isFree((BlockState)ctx.getLevel().getBlockState(ctx.getClickedPos().below()))) {
            state.setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(true));
        } else {
            state.setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)UNSTABLE)).booleanValue()) {
            this.propagate(world, pos);
            world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(false)));
            super.tick(state, world, pos, random);
        } else if (world.getBestNeighborSignal(pos) > 0) {
            world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(true)));
            this.propagate(world, pos);
        }
    }

    protected void propagate(ServerLevel world, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = pos.relative(dir);
            BlockState offsetBlockState = world.getBlockState(offsetPos);
            if (!offsetBlockState.is((Block)this) || ((Boolean)offsetBlockState.getValue((Property)UNSTABLE)).booleanValue() || !RedstoneGravityBlock.isFree((BlockState)world.getBlockState(offsetPos.below()))) continue;
            world.setBlockAndUpdate(offsetPos, (BlockState)world.getBlockState(offsetPos).setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(true)));
            world.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        }
    }
}

