/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.redstone.RedstoneCalculatorBlockEntity;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;

public class RedstoneCalculatorBlock
extends DiodeBlock
implements EntityBlock {
    public static final MapCodec<RedstoneCalculatorBlock> CODEC = RedstoneCalculatorBlock.simpleCodec(RedstoneCalculatorBlock::new);
    public static final EnumProperty<CalculationMode> CALCULATION_MODE = EnumProperty.create((String)"calculation_mode", CalculationMode.class);

    public RedstoneCalculatorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(CALCULATION_MODE, (Comparable)((Object)CalculationMode.ADDITION)));
    }

    public MapCodec<? extends RedstoneCalculatorBlock> codec() {
        return CODEC;
    }

    protected int getDelay(BlockState state) {
        return 2;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, CALCULATION_MODE});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RedstoneCalculatorBlockEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        BlockState newModeState = (BlockState)state.cycle(CALCULATION_MODE);
        world.setBlock(pos, newModeState, 3);
        float pitch = 0.5f + (float)((CalculationMode)((Object)state.getValue(CALCULATION_MODE))).ordinal() * 0.05f;
        world.playSound(player, pos, PastelSounds.REDSTONE_MECHANISM_TRIGGER, SoundSource.BLOCKS, 0.3f, pitch);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            serverPlayerEntity.displayClientMessage((Component)Component.translatable((String)"block.pastel.redstone_calculator.mode_set").append((Component)Component.translatable((String)((CalculationMode)((Object)newModeState.getValue(RedstoneCalculatorBlock.CALCULATION_MODE))).localizationString)), true);
        }
        this.update(world, pos, state);
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.update((Level)world, pos, state);
    }

    private void update(Level world, BlockPos pos, BlockState state) {
        int newSignal = this.calculateOutputSignal(world, pos, state);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        int previousSignal = 0;
        if (blockEntity instanceof RedstoneCalculatorBlockEntity) {
            RedstoneCalculatorBlockEntity redstoneCalculatorBlockEntity = (RedstoneCalculatorBlockEntity)blockEntity;
            previousSignal = redstoneCalculatorBlockEntity.getOutputSignal();
            redstoneCalculatorBlockEntity.setOutputSignal(newSignal);
        }
        if (previousSignal != newSignal) {
            boolean bl = newSignal != 0;
            boolean bl2 = (Boolean)state.getValue((Property)POWERED);
            if (bl2 && !bl) {
                world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            } else if (!bl2 && bl) {
                world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
            this.updateNeighborsInFront(world, pos, state);
        }
    }

    protected void checkTickOnNeighbor(Level world, BlockPos pos, BlockState state) {
        if (!world.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            int n;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof RedstoneCalculatorBlockEntity) {
                RedstoneCalculatorBlockEntity redstoneCalculatorBlockEntity = (RedstoneCalculatorBlockEntity)blockEntity;
                n = redstoneCalculatorBlockEntity.getOutputSignal();
            } else {
                n = 0;
            }
            int previousSignal = n;
            int newSignal = this.calculateOutputSignal(world, pos, state);
            if (newSignal != previousSignal) {
                TickPriority tickPriority = this.shouldPrioritize((BlockGetter)world, pos, state) ? TickPriority.HIGH : TickPriority.NORMAL;
                world.scheduleTick(pos, (Block)this, this.getDelay(state), tickPriority);
            }
        }
    }

    private int calculateOutputSignal(Level world, BlockPos pos, BlockState state) {
        int power = this.getInputSignal(world, pos, state);
        int powerSides = this.getAlternateSignal((SignalGetter)world, pos, state);
        switch (((CalculationMode)((Object)state.getValue(CALCULATION_MODE))).ordinal()) {
            case 0: {
                return power + powerSides;
            }
            case 1: {
                return power - powerSides;
            }
            case 2: {
                return power * powerSides;
            }
            case 3: {
                if (powerSides == 0) {
                    return 0;
                }
                return power / powerSides;
            }
            case 5: {
                return Math.min(power, powerSides);
            }
            case 6: {
                return Math.max(power, powerSides);
            }
        }
        if (powerSides == 0) {
            return 0;
        }
        return power % powerSides;
    }

    protected int getOutputSignal(@NotNull BlockGetter world, BlockPos pos, BlockState state) {
        int n;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneCalculatorBlockEntity) {
            RedstoneCalculatorBlockEntity redstoneCalculatorBlockEntity = (RedstoneCalculatorBlockEntity)blockEntity;
            n = redstoneCalculatorBlockEntity.getOutputSignal();
        } else {
            n = 0;
        }
        return n;
    }

    public static enum CalculationMode implements StringRepresentable
    {
        ADDITION("addition", "block.pastel.redstone_calculator.mode.addition"),
        SUBTRACTION("subtraction", "block.pastel.redstone_calculator.mode.subtraction"),
        MULTIPLICATION("multiplication", "block.pastel.redstone_calculator.mode.multiplication"),
        DIVISION("division", "block.pastel.redstone_calculator.mode.division"),
        MODULO("modulo", "block.pastel.redstone_calculator.mode.modulo"),
        MIN("min", "block.pastel.redstone_calculator.mode.min"),
        MAX("max", "block.pastel.redstone_calculator.mode.max");

        public final String localizationString;
        private final String name;

        private CalculationMode(String name, String localizationString) {
            this.name = name;
            this.localizationString = localizationString;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

