/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.redstone.DetectorBlock;
import earth.terrarium.pastel.blocks.redstone.PlayerDetectorBlockEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PlayerDetectorBlock
extends DetectorBlock
implements EntityBlock {
    public static final MapCodec<PlayerDetectorBlock> CODEC = PlayerDetectorBlock.simpleCodec(PlayerDetectorBlock::new);

    public PlayerDetectorBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends PlayerDetectorBlock> codec() {
        return CODEC;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (!world.isClientSide && placer instanceof Player && (blockEntity = world.getBlockEntity(pos)) instanceof PlayerDetectorBlockEntity) {
            ((PlayerDetectorBlockEntity)blockEntity).setOwner((Player)placer);
        }
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            String ownerName = this.getOwnerName(world, pos);
            if (ownerName != null && !ownerName.isBlank()) {
                player.displayClientMessage((Component)Component.translatable((String)"block.pastel.player_detector.owner", (Object[])new Object[]{ownerName}), true);
            }
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    @Override
    protected void updateState(BlockState state, Level world, BlockPos pos) {
        List players = world.getEntities((EntityTypeTest)EntityType.PLAYER, this.getDetectionBox(pos), player -> player.isAlive() && !player.isSpectator());
        int power = 0;
        if (!players.isEmpty()) {
            power = 8;
            UUID ownerUUID = this.getOwnerUUID(world, pos);
            if (ownerUUID != null) {
                for (Player playerEntity : players) {
                    if (!playerEntity.getUUID().equals(ownerUUID)) continue;
                    power = 15;
                    break;
                }
            }
        }
        int n = power = (Boolean)state.getValue((Property)INVERTED) != false ? 15 - power : power;
        if ((Integer)state.getValue((Property)POWER) != power) {
            world.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(power)), 3);
        }
    }

    @Override
    int getUpdateFrequencyTicks() {
        return 20;
    }

    private UUID getOwnerUUID(Level world, BlockPos blockPos) {
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (blockEntity instanceof PlayerDetectorBlockEntity) {
            return ((PlayerDetectorBlockEntity)blockEntity).getOwnerUUID();
        }
        return null;
    }

    private String getOwnerName(Level world, BlockPos blockPos) {
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (blockEntity instanceof PlayerDetectorBlockEntity) {
            return ((PlayerDetectorBlockEntity)blockEntity).getOwnerName();
        }
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PlayerDetectorBlockEntity(pos, state);
    }
}

