/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.redstone.DetectorBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;

public class EntityDetectorBlock
extends DetectorBlock {
    public static final MapCodec<EntityDetectorBlock> CODEC = EntityDetectorBlock.simpleCodec(EntityDetectorBlock::new);

    public EntityDetectorBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends EntityDetectorBlock> codec() {
        return CODEC;
    }

    @Override
    protected void updateState(BlockState state, Level world, BlockPos pos) {
        List entities = world.getEntities(EntityTypeTest.forClass(LivingEntity.class), this.getDetectionBox(pos), LivingEntity::isAlive);
        int power = Math.min(entities.size(), 15);
        int n = power = (Boolean)state.getValue((Property)INVERTED) != false ? 15 - power : power;
        if ((Integer)state.getValue((Property)POWER) != power) {
            world.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(power)), 3);
        }
    }

    @Override
    int getUpdateFrequencyTicks() {
        return 20;
    }
}

