/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.redstone.RedstoneInteractionBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockDetectorBlock
extends RedstoneInteractionBlock {
    public static final MapCodec<BlockDetectorBlock> CODEC = BlockDetectorBlock.simpleCodec(BlockDetectorBlock::new);

    public BlockDetectorBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends BlockDetectorBlock> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction != Direction.DOWN && ((FrontAndTop)state.getValue((Property)ORIENTATION)).front() == direction && !((Boolean)state.getValue((Property)TRIGGERED)).booleanValue() && neighborState.equals(this.getTargetBlockState(world, state, pos))) {
            this.scheduleTick(world, pos);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected BlockState getTargetBlockState(LevelAccessor world, BlockState state, BlockPos pos) {
        if (((FrontAndTop)state.getValue((Property)ORIENTATION)).front() == Direction.DOWN) {
            return world.getBlockState(pos.relative(Direction.UP));
        }
        return world.getBlockState(pos.relative(Direction.DOWN));
    }

    private void scheduleTick(LevelAccessor world, BlockPos pos) {
        if (!world.isClientSide() && !world.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            world.scheduleTick(pos, (Block)this, 2);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)TRIGGERED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        } else {
            world.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
            world.scheduleTick(pos, (Block)this, 2);
        }
        this.updateNeighbors((Level)world, pos, state);
    }

    protected void updateNeighbors(Level world, BlockPos pos, BlockState state) {
        Direction direction = ((FrontAndTop)state.getValue((Property)ORIENTATION)).front();
        BlockPos blockPos = pos.relative(direction.getOpposite());
        world.neighborChanged(blockPos, (Block)this, pos);
        world.updateNeighborsAtExceptFromFacing(blockPos, (Block)this, direction);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getSignal(world, pos, direction);
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return (Boolean)state.getValue((Property)TRIGGERED) != false && ((FrontAndTop)state.getValue((Property)ORIENTATION)).front() == direction ? 15 : 0;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.is(oldState.getBlock()) && !world.isClientSide() && ((Boolean)state.getValue((Property)TRIGGERED)).booleanValue() && !world.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            BlockState blockState = (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false));
            world.setBlock(pos, blockState, 18);
            this.updateNeighbors(world, pos, blockState);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock()) && !world.isClientSide && ((Boolean)state.getValue((Property)TRIGGERED)).booleanValue() && world.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            this.updateNeighbors(world, pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
        }
    }
}

