/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.present;

import com.mojang.authlib.GameProfile;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.block.PlayerOwnedWithName;
import earth.terrarium.pastel.components.WrappedPresentComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PresentBlockEntity
extends BlockEntity
implements PlayerOwnedWithName {
    private UUID openerUUID;
    protected int openingTicks = 0;

    public PresentBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.PRESENT.get(), pos, state);
    }

    public void triggerAdvancement() {
        Player wrapper;
        UUID ownerUUID;
        Player opener;
        UUID openerUUID = this.getOpenerUUID();
        if (openerUUID != null && (opener = PlayerOwned.getPlayerEntityIfOnline(openerUUID)) != null) {
            Support.grantAdvancementCriterion((ServerPlayer)opener, "gift_or_open_present", "gifted_or_opened_present");
        }
        if ((ownerUUID = this.getOwnerUUID()) != null && (wrapper = PlayerOwned.getPlayerEntityIfOnline(ownerUUID)) != null) {
            Support.grantAdvancementCriterion((ServerPlayer)wrapper, "gift_or_open_present", "gifted_or_opened_present");
        }
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.openerUUID = nbt.contains("OpenerUUID") ? nbt.getUUID("OpenerUUID") : null;
        if (nbt.contains("OpeningTick", 99)) {
            this.openingTicks = nbt.getInt("OpeningTick");
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (this.openerUUID != null) {
            nbt.putUUID("OpenerUUID", this.openerUUID);
        }
        if (this.openingTicks > 0) {
            nbt.putInt("OpeningTick", this.openingTicks);
        }
    }

    public int openingTick() {
        ++this.openingTicks;
        this.setChanged();
        return this.openingTicks;
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        ResolvableProfile profile = this.getOwner();
        return profile == null ? null : (UUID)profile.id().orElse(null);
    }

    @Nullable
    public ResolvableProfile getOwner() {
        return (ResolvableProfile)this.components().get(DataComponents.PROFILE);
    }

    @Override
    public String getOwnerName() {
        ResolvableProfile profile = this.getOwner();
        return profile == null ? "???" : profile.name().orElse("???");
    }

    @Override
    public void setOwner(@Nullable Player playerEntity) {
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        if (playerEntity == null) {
            builder.remove(DataComponents.PROFILE);
        } else {
            GameProfile profile = new GameProfile(playerEntity.getUUID(), playerEntity.getName().getString());
            builder.set(DataComponents.PROFILE, (Object)new ResolvableProfile(profile));
        }
        this.applyComponents(this.components(), builder.build());
        this.setChanged();
    }

    public void setOpenerUUID(Player opener) {
        this.openerUUID = opener.getUUID();
        this.setChanged();
    }

    public UUID getOpenerUUID() {
        return this.openerUUID;
    }

    public ItemStack retrievePresent() {
        ItemStack result = PastelBlocks.PRESENT.toStack();
        result.applyComponents(this.components());
        return result;
    }

    public Map<Integer, Integer> getColors() {
        return ((WrappedPresentComponent)this.components().getOrDefault(PastelDataComponentTypes.WRAPPED_PRESENT, (Object)WrappedPresentComponent.DEFAULT)).colors();
    }

    public List<ItemStack> getStacks() {
        BundleContents contents = (BundleContents)this.components().get(DataComponents.BUNDLE_CONTENTS);
        return contents == null ? List.of() : contents.itemCopyStream().toList();
    }

    public boolean isEmpty() {
        BundleContents contents = (BundleContents)this.components().get(DataComponents.BUNDLE_CONTENTS);
        return contents == null || contents.isEmpty();
    }
}

