/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.potion_workshop;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.item.InkPoweredPotionFillable;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.helpers.level.ContainerWrapper;
import earth.terrarium.pastel.inventories.PotionWorkshopScreenHandler;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.recipe.SimpleRecipeInput;
import earth.terrarium.pastel.recipe.potion_workshop.PotionMod;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopBrewingRecipe;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopCraftingRecipe;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopReactingRecipe;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopRecipe;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffectTags;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionWorkshopBlockEntity
extends BlockEntity
implements MenuProvider,
StackedContentsCompatible,
PlayerOwned,
SidedCapabilityProvider,
ContainerWrapper {
    public static final int INVENTORY_SIZE = 22;
    public static final int MERMAIDS_GEM_INPUT_SLOT_ID = 0;
    public static final int BASE_INPUT_SLOT_ID = 1;
    public static final int FIRST_INGREDIENT_SLOT = 2;
    public static final int FIRST_REAGENT_SLOT = 5;
    public static final int FIRST_INVENTORY_SLOT = 9;
    public static final int INVENTORY_SLOT_COUNT = 12;
    public static final int[] INGREDIENT_SLOTS = IntStream.rangeClosed(2, 4).toArray();
    public static final int[] REAGENT_SLOTS = IntStream.rangeClosed(5, 8).toArray();
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{0, 1, 2, 3, 4};
    private static final int[] ACCESSIBLE_SLOTS_SIDE_WITHOUT_UNLOCK = new int[]{5, 6, 7};
    private static final int[] ACCESSIBLE_SLOTS_SIDE_WITH_UNLOCK = new int[]{5, 6, 7, 8};
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    protected final ContainerData propertyDelegate;
    protected FriendlyStackHandler inventory = new FriendlyStackHandler(22);
    protected boolean inventoryChanged;
    protected RecipeHolder<? extends PotionWorkshopRecipe> currentRecipe;
    protected int brewTime;
    protected int brewTimeTotal;
    protected int potionColor;
    protected UUID ownerUUID;
    protected RecipeHolder<PotionWorkshopBrewingRecipe> lastBrewedRecipe;

    public PotionWorkshopBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.POTION_WORKSHOP.get(), pos, state);
        this.inventory.addListener(i -> {
            this.inventoryChanged = true;
        });
        this.propertyDelegate = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> PotionWorkshopBlockEntity.this.brewTime;
                    case 1 -> PotionWorkshopBlockEntity.this.brewTimeTotal;
                    default -> PotionWorkshopBlockEntity.this.potionColor;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        PotionWorkshopBlockEntity.this.brewTime = value;
                        break;
                    }
                    case 1: {
                        PotionWorkshopBlockEntity.this.brewTimeTotal = value;
                        break;
                    }
                    case 2: {
                        PotionWorkshopBlockEntity.this.potionColor = value;
                    }
                }
            }

            public int getCount() {
                return 3;
            }
        };
    }

    public static void tick(Level world, BlockPos blockPos, BlockState blockState, PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        boolean shouldMarkDirty = false;
        RecipeHolder<? extends PotionWorkshopRecipe> calculatedRecipe = PotionWorkshopBlockEntity.calculateRecipe(world, potionWorkshopBlockEntity);
        if (potionWorkshopBlockEntity.currentRecipe != calculatedRecipe) {
            potionWorkshopBlockEntity.currentRecipe = calculatedRecipe;
            potionWorkshopBlockEntity.brewTime = 0;
            if (potionWorkshopBlockEntity.currentRecipe != null) {
                potionWorkshopBlockEntity.brewTimeTotal = ((PotionWorkshopRecipe)calculatedRecipe.value()).getCraftingTime();
                potionWorkshopBlockEntity.potionColor = ((PotionWorkshopRecipe)calculatedRecipe.value()).getColor();
            }
            shouldMarkDirty = true;
        }
        potionWorkshopBlockEntity.inventoryChanged = false;
        if (calculatedRecipe != null && (potionWorkshopBlockEntity.brewTime > 0 || PotionWorkshopBlockEntity.hasRoomInOutputInventoryFor(potionWorkshopBlockEntity, ((PotionWorkshopRecipe)calculatedRecipe.value()).getMinOutputCount(potionWorkshopBlockEntity.inventory.getStackInSlot(1))))) {
            if (potionWorkshopBlockEntity.brewTime == potionWorkshopBlockEntity.brewTimeTotal) {
                if (calculatedRecipe.value() instanceof PotionWorkshopBrewingRecipe) {
                    Item baseItem = potionWorkshopBlockEntity.inventory.getStackInSlot(1).getItem();
                    if (baseItem instanceof InkPoweredPotionFillable) {
                        PotionWorkshopBlockEntity.fillPotionFillable(potionWorkshopBlockEntity, calculatedRecipe);
                    } else if (baseItem.equals(Items.ARROW)) {
                        PotionWorkshopBlockEntity.createTippedArrows(potionWorkshopBlockEntity, calculatedRecipe);
                    } else {
                        PotionWorkshopBlockEntity.brewRecipe(potionWorkshopBlockEntity, calculatedRecipe);
                    }
                } else if (calculatedRecipe.value() instanceof PotionWorkshopCraftingRecipe) {
                    PotionWorkshopBlockEntity.craftRecipe(potionWorkshopBlockEntity, calculatedRecipe);
                }
                potionWorkshopBlockEntity.brewTime = 0;
                potionWorkshopBlockEntity.inventoryChanged = true;
                potionWorkshopBlockEntity.playSound(SoundEvents.BREWING_STAND_BREW);
            } else {
                ++potionWorkshopBlockEntity.brewTime;
            }
            shouldMarkDirty = true;
        }
        if (shouldMarkDirty) {
            PotionWorkshopBlockEntity.setChanged((Level)world, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    public static boolean hasRoomInOutputInventoryFor(@NotNull PotionWorkshopBlockEntity potionWorkshopBlockEntity, int count) {
        for (int slotID : ACCESSIBLE_SLOTS_DOWN) {
            if (!potionWorkshopBlockEntity.inventory.getStackInSlot(slotID).isEmpty() || --count != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static RecipeHolder<? extends PotionWorkshopRecipe> calculateRecipe(Level world, @NotNull PotionWorkshopBlockEntity workshop) {
        PotionWorkshopRecipe current;
        if (!workshop.inventoryChanged) {
            PotionWorkshopCraftingRecipe craftingRecipe;
            if (workshop.currentRecipe == null) return workshop.currentRecipe;
            ItemStack slot = workshop.inventory.getStackInSlot(1);
            Recipe recipe = workshop.currentRecipe.value();
            if (!(recipe instanceof PotionWorkshopCraftingRecipe) || (craftingRecipe = (PotionWorkshopCraftingRecipe)recipe).getBaseIngredient().test(slot)) {
                if (!(workshop.currentRecipe.value() instanceof PotionWorkshopBrewingRecipe)) return workshop.currentRecipe;
                if (!slot.isEmpty()) return workshop.currentRecipe;
            }
            workshop.currentRecipe = null;
            workshop.brewTime = 0;
            workshop.setChanged();
            return workshop.currentRecipe;
        }
        RecipeHolder newRecipe = null;
        PotionWorkshopRecipe potionWorkshopRecipe = current = workshop.currentRecipe == null ? null : (PotionWorkshopRecipe)workshop.currentRecipe.value();
        if (current instanceof PotionWorkshopBrewingRecipe) {
            PotionWorkshopBrewingRecipe potionWorkshopBrewingRecipe = (PotionWorkshopBrewingRecipe)current;
            if (current.matches(workshop.getRecipeInput(), world)) {
                if (!PotionWorkshopBlockEntity.isBrewingRecipeApplicable(potionWorkshopBrewingRecipe, workshop.inventory.getStackInSlot(1), workshop)) return newRecipe;
                return workshop.currentRecipe;
            }
        }
        if (current instanceof PotionWorkshopCraftingRecipe && current.matches(workshop.getRecipeInput(), world)) {
            return workshop.currentRecipe;
        }
        RecipeHolder newPotionWorkshopBrewingRecipe = world.getRecipeManager().getRecipeFor(PastelRecipeTypes.POTION_WORKSHOP_BREWING, (RecipeInput)workshop.getRecipeInput(), world).orElse(null);
        if (newPotionWorkshopBrewingRecipe != null) {
            if (!((PotionWorkshopBrewingRecipe)newPotionWorkshopBrewingRecipe.value()).canPlayerCraft(workshop.getOwnerIfOnline())) return newRecipe;
            if (!PotionWorkshopBlockEntity.isBrewingRecipeApplicable((PotionWorkshopBrewingRecipe)newPotionWorkshopBrewingRecipe.value(), workshop.inventory.getStackInSlot(1), workshop)) return newRecipe;
            return newPotionWorkshopBrewingRecipe;
        }
        RecipeHolder newPotionWorkshopCraftingRecipe = world.getRecipeManager().getRecipeFor(PastelRecipeTypes.POTION_WORKSHOP_CRAFTING, (RecipeInput)workshop.getRecipeInput(), world).orElse(null);
        if (newPotionWorkshopCraftingRecipe == null) return newRecipe;
        if (!((PotionWorkshopCraftingRecipe)newPotionWorkshopCraftingRecipe.value()).canPlayerCraft(workshop.getOwnerIfOnline())) return newRecipe;
        return newPotionWorkshopCraftingRecipe;
    }

    private static boolean hasUniqueReagents(PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        ArrayList<Item> reagentItems = new ArrayList<Item>();
        for (int slot : REAGENT_SLOTS) {
            ItemStack reagentStack = potionWorkshopBlockEntity.inventory.getStackInSlot(slot);
            if (reagentStack.isEmpty()) continue;
            if (reagentItems.contains(reagentStack.getItem())) {
                return false;
            }
            reagentItems.add(reagentStack.getItem());
        }
        return true;
    }

    private static boolean isBrewingRecipeApplicable(PotionWorkshopBrewingRecipe recipe, ItemStack baseIngredient, PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        PotionMod potionMod = PotionWorkshopBlockEntity.getPotionModFromReagents(potionWorkshopBlockEntity);
        return PotionWorkshopBlockEntity.hasUniqueReagents(potionWorkshopBlockEntity) && recipe.recipeData.isApplicableTo(baseIngredient, potionMod) && (!potionMod.flags().incurable() || !recipe.recipeData.statusEffect().is(PastelMobEffectTags.CANNOT_BE_INCURABLE));
    }

    private static void craftRecipe(PotionWorkshopBlockEntity potionWorkshopBlockEntity, RecipeHolder<PotionWorkshopCraftingRecipe> recipe) {
        Level world = potionWorkshopBlockEntity.level;
        if (world == null) {
            return;
        }
        PotionWorkshopBlockEntity.decrementIngredientSlots(potionWorkshopBlockEntity);
        if (((PotionWorkshopCraftingRecipe)recipe.value()).consumesBaseIngredient()) {
            PotionWorkshopBlockEntity.decrementBaseIngredientSlot(potionWorkshopBlockEntity, ((PotionWorkshopCraftingRecipe)recipe.value()).getBaseIngredient().getCount());
        }
        PotionWorkshopBlockEntity.addToInventoryOrSpawn(potionWorkshopBlockEntity, ((PotionWorkshopCraftingRecipe)recipe.value()).assemble(potionWorkshopBlockEntity.getRecipeInput(), (HolderLookup.Provider)potionWorkshopBlockEntity.level.registryAccess()));
    }

    private static void brewRecipe(PotionWorkshopBlockEntity potionWorkshopBlockEntity, RecipeHolder<PotionWorkshopBrewingRecipe> brewingRecipe) {
        Level world = potionWorkshopBlockEntity.getLevel();
        if (world == null) {
            return;
        }
        PotionMod potionMod = PotionWorkshopBlockEntity.getPotionModFromReagents(potionWorkshopBlockEntity);
        int maxBrewedPotionsAmount = Support.chanceRound(((PotionWorkshopBrewingRecipe)brewingRecipe.value()).getModifiedYield(potionMod), world.random);
        int brewedAmount = Math.min(potionWorkshopBlockEntity.inventory.getStackInSlot(1).getCount(), maxBrewedPotionsAmount);
        ItemStack bottles = potionWorkshopBlockEntity.inventory.getStackInSlot(1);
        List<ItemStack> results = ((PotionWorkshopBrewingRecipe)brewingRecipe.value()).getPotions(bottles, potionMod, potionWorkshopBlockEntity.lastBrewedRecipe, world.random, brewedAmount);
        PotionWorkshopBlockEntity.decrementIngredientSlots(potionWorkshopBlockEntity);
        PotionWorkshopBlockEntity.decrementBaseIngredientSlot(potionWorkshopBlockEntity, brewedAmount);
        PotionWorkshopBlockEntity.decrementReagentSlots(potionWorkshopBlockEntity);
        ServerPlayer serverPlayerEntity = (ServerPlayer)potionWorkshopBlockEntity.getOwnerIfOnline();
        if (brewedAmount <= 0) {
            PastelCriteria.POTION_WORKSHOP_BREWING.trigger(serverPlayerEntity, ItemStack.EMPTY, 0);
        } else {
            for (ItemStack potion : results) {
                if (serverPlayerEntity != null) {
                    PastelCriteria.POTION_WORKSHOP_BREWING.trigger(serverPlayerEntity, potion, brewedAmount);
                    ((PotionContents)potion.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().ifPresent(p -> CriteriaTriggers.BREWED_POTION.trigger(serverPlayerEntity, p));
                }
                PotionWorkshopBlockEntity.addToInventoryOrSpawn(potionWorkshopBlockEntity, potion);
            }
        }
        potionWorkshopBlockEntity.lastBrewedRecipe = brewingRecipe;
    }

    private static void createTippedArrows(PotionWorkshopBlockEntity potionWorkshopBlockEntity, RecipeHolder<PotionWorkshopBrewingRecipe> brewingRecipe) {
        Level world = potionWorkshopBlockEntity.getLevel();
        if (world == null) {
            return;
        }
        PotionMod potionMod = PotionWorkshopBlockEntity.getPotionModFromReagents(potionWorkshopBlockEntity);
        int maxTippedArrowsAmount = Support.chanceRound(((PotionWorkshopBrewingRecipe)brewingRecipe.value()).getModifiedYield(potionMod) * 8.0f, world.random);
        int tippedAmount = Math.min(potionWorkshopBlockEntity.inventory.getStackInSlot(1).getCount(), maxTippedArrowsAmount);
        ItemStack arrows = potionWorkshopBlockEntity.inventory.getStackInSlot(1);
        ItemStack tippedArrows = ((PotionWorkshopBrewingRecipe)brewingRecipe.value()).getTippedArrows(arrows, potionMod, potionWorkshopBlockEntity.lastBrewedRecipe, tippedAmount, world.random);
        PotionWorkshopBlockEntity.decrementIngredientSlots(potionWorkshopBlockEntity);
        PotionWorkshopBlockEntity.decrementBaseIngredientSlot(potionWorkshopBlockEntity, tippedAmount);
        PotionWorkshopBlockEntity.decrementReagentSlots(potionWorkshopBlockEntity);
        ServerPlayer serverPlayerEntity = (ServerPlayer)potionWorkshopBlockEntity.getOwnerIfOnline();
        InventoryHelper.addToInventory((IItemHandlerModifiable)potionWorkshopBlockEntity.inventory, tippedArrows, 9, 21);
        if (serverPlayerEntity != null) {
            PastelCriteria.POTION_WORKSHOP_BREWING.trigger(serverPlayerEntity, tippedArrows, tippedArrows.getCount());
        }
        potionWorkshopBlockEntity.lastBrewedRecipe = brewingRecipe;
    }

    private static void fillPotionFillable(PotionWorkshopBlockEntity potionWorkshopBlockEntity, RecipeHolder<PotionWorkshopBrewingRecipe> brewingRecipe) {
        ItemStack potionFillableStack = potionWorkshopBlockEntity.inventory.getStackInSlot(1);
        if (potionFillableStack.getItem() instanceof InkPoweredPotionFillable && potionWorkshopBlockEntity.level != null) {
            PotionMod potionMod = PotionWorkshopBlockEntity.getPotionModFromReagents(potionWorkshopBlockEntity);
            PotionWorkshopBlockEntity.decrementIngredientSlots(potionWorkshopBlockEntity);
            PotionWorkshopBlockEntity.decrementReagentSlots(potionWorkshopBlockEntity);
            int maxBrewedPotionsAmount = Support.chanceRound(((PotionWorkshopBrewingRecipe)brewingRecipe.value()).getModifiedYield(potionMod), potionWorkshopBlockEntity.level.random);
            if (maxBrewedPotionsAmount < 1) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)potionWorkshopBlockEntity.getOwnerIfOnline();
                if (serverPlayerEntity != null) {
                    PastelCriteria.POTION_WORKSHOP_BREWING.trigger(serverPlayerEntity, potionFillableStack, 0);
                }
                return;
            }
            ((PotionWorkshopBrewingRecipe)brewingRecipe.value()).fillPotionFillable(potionFillableStack, potionMod, potionWorkshopBlockEntity.lastBrewedRecipe, potionWorkshopBlockEntity.level.random);
            potionWorkshopBlockEntity.inventory.setStackInSlot(1, ItemStack.EMPTY);
            InventoryHelper.addToInventory((IItemHandlerModifiable)potionWorkshopBlockEntity.inventory, potionFillableStack, 9, 21);
            ServerPlayer serverPlayerEntity = (ServerPlayer)potionWorkshopBlockEntity.getOwnerIfOnline();
            if (serverPlayerEntity != null) {
                PastelCriteria.POTION_WORKSHOP_BREWING.trigger(serverPlayerEntity, potionFillableStack, 1);
            }
            potionWorkshopBlockEntity.lastBrewedRecipe = brewingRecipe;
        }
    }

    private static PotionMod getPotionModFromReagents(PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        Level world = potionWorkshopBlockEntity.getLevel();
        PotionMod.Builder builder = new PotionMod.Builder();
        if (world != null) {
            for (int slot : REAGENT_SLOTS) {
                ItemStack slotStack = potionWorkshopBlockEntity.inventory.getStackInSlot(slot);
                if (slotStack.isEmpty()) continue;
                PotionWorkshopReactingRecipe.combine(builder, slotStack, world.random);
            }
        }
        return builder.build();
    }

    public static void decrementBaseIngredientSlot(@NotNull PotionWorkshopBlockEntity potionWorkshopBlockEntity, int amount) {
        if (amount > 0) {
            PotionWorkshopBlockEntity.decrementUsingRemainder(potionWorkshopBlockEntity, potionWorkshopBlockEntity.inventory.getStackInSlot(1), amount);
        }
    }

    public static void decrementIngredientSlots(@NotNull PotionWorkshopBlockEntity workshop) {
        workshop.inventory.getStackInSlot(0).shrink(1);
        if (workshop.level == null) {
            return;
        }
        RecipeHolder<? extends PotionWorkshopRecipe> recipe = workshop.currentRecipe;
        int requiredExperience = ((PotionWorkshopRecipe)recipe.value()).getRequiredExperience();
        block0: for (IngredientStack ingredientStack : ((PotionWorkshopRecipe)recipe.value()).getOtherIngredients()) {
            for (int slot : INGREDIENT_SLOTS) {
                int fre;
                ItemStack slotStack = workshop.inventory.getStackInSlot(slot);
                if (!ingredientStack.test(slotStack)) continue;
                Optional<ExperienceHandler> storage = Optional.ofNullable((ExperienceHandler)slotStack.getCapability(PastelCapabilities.Misc.XP, (Object)workshop.level.registryAccess()));
                if (storage.map(arg_0 -> PotionWorkshopBlockEntity.lambda$decrementIngredientSlots$2(fre = requiredExperience, arg_0)).orElse(false).booleanValue()) {
                    requiredExperience = 0;
                    continue block0;
                }
                PotionWorkshopBlockEntity.decrementUsingRemainder(workshop, slotStack, 1);
                continue block0;
            }
        }
    }

    public static void decrementReagentSlots(@NotNull PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        for (int i : REAGENT_SLOTS) {
            ItemStack currentStack = potionWorkshopBlockEntity.inventory.getStackInSlot(i);
            if (currentStack.isEmpty()) continue;
            PotionWorkshopBlockEntity.decrementUsingRemainder(potionWorkshopBlockEntity, currentStack, 1);
        }
    }

    private static void decrementUsingRemainder(@NotNull PotionWorkshopBlockEntity potionWorkshopBlockEntity, ItemStack currentStack, int amount) {
        ItemStack currentRemainder = currentStack.getCraftingRemainingItem();
        currentStack.shrink(amount);
        if (!currentRemainder.isEmpty()) {
            PotionWorkshopBlockEntity.addToInventoryOrSpawn(potionWorkshopBlockEntity, currentRemainder);
        }
    }

    private static void addToInventoryOrSpawn(@NotNull PotionWorkshopBlockEntity potionWorkshopBlockEntity, ItemStack currentRemainder) {
        if (!(currentRemainder = InventoryHelper.offerToInventory((IItemHandlerModifiable)potionWorkshopBlockEntity.inventory, currentRemainder, 9, 21)).isEmpty()) {
            Containers.dropItemStack((Level)potionWorkshopBlockEntity.level, (double)potionWorkshopBlockEntity.worldPosition.getX(), (double)potionWorkshopBlockEntity.worldPosition.getY(), (double)potionWorkshopBlockEntity.worldPosition.getZ(), (ItemStack)currentRemainder);
        }
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.inventory.deserializeNBT(registryLookup, nbt.getCompound("inventory"));
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        if (nbt.contains("LastBrewedRecipe") && this.getLevel() != null) {
            Object object;
            ResourceLocation id = ResourceLocation.parse((String)nbt.getString("LastBrewedRecipe"));
            Optional optRecipe = registryLookup.lookup(Registries.RECIPE).flatMap(impl -> impl.get(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)id)));
            if (optRecipe.isPresent() && (object = ((Holder.Reference)optRecipe.get()).value()) instanceof PotionWorkshopBrewingRecipe) {
                PotionWorkshopBrewingRecipe brewingRecipe = (PotionWorkshopBrewingRecipe)object;
                this.lastBrewedRecipe = new RecipeHolder(id, (Recipe)brewingRecipe);
            }
        } else {
            this.lastBrewedRecipe = null;
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.put("inventory", (Tag)this.inventory.serializeNBT(registryLookup));
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.lastBrewedRecipe != null) {
            nbt.putString("LastBrewedRecipe", this.lastBrewedRecipe.id().toString());
        }
    }

    private void playSound(SoundEvent soundEvent) {
        if (this.level == null) {
            return;
        }
        RandomSource random = this.level.random;
        this.level.playSound(null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), soundEvent, SoundSource.BLOCKS, 0.9f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public SimpleRecipeInput getRecipeInput() {
        return new SimpleRecipeInput((List<ItemStack>)this.inventory.getInternalList());
    }

    public void fillStackedContents(StackedContents recipeMatcher) {
        recipeMatcher.accountStack(this.inventory.getStackInSlot(2));
        recipeMatcher.accountStack(this.inventory.getStackInSlot(3));
        recipeMatcher.accountStack(this.inventory.getStackInSlot(4));
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.setChanged();
    }

    private boolean hasFourthReagentSlotUnlocked(Player playerEntity) {
        if (playerEntity == null) {
            return false;
        }
        return DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)PastelAdvancements.Milestones.UNLOCK_FOURTH_POTION_WORKSHOP_REAGENT_SLOT);
    }

    private boolean hasFourthReagentSlotUnlocked() {
        if (this.ownerUUID == null) {
            return false;
        }
        return this.hasFourthReagentSlotUnlocked(this.getOwnerIfOnline());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.pastel.potion_workshop");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new PotionWorkshopScreenHandler(syncId, inv, this, this.propertyDelegate);
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        if (dir == Direction.UP) {
            return new StackHandlerView(this.inventory, 0, ACCESSIBLE_SLOTS_UP.length).disableExtraction().addFilter(0, (Predicate<ItemStack>)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PastelItems.MERMAIDS_GEM.get()}));
        }
        return new StackHandlerView(this.inventory, ACCESSIBLE_SLOTS_DOWN[0], ACCESSIBLE_SLOTS_DOWN.length);
    }

    @Override
    public FriendlyStackHandler getHandlerForScreens() {
        return this.inventory;
    }

    private static /* synthetic */ Boolean lambda$decrementIngredientSlots$2(int fre, ExperienceHandler s) {
        return s.extractOrFail(fre);
    }
}

