/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pedestal;

import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntity;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class PedestalCraftingView
extends StackHandlerView {
    private final PedestalBlockEntity pedestal;

    public PedestalCraftingView(PedestalBlockEntity pedestal, FriendlyStackHandler delegator) {
        super(delegator, 0, 9);
        this.pedestal = pedestal;
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        List<Ingredient> ing = this.pedestal.getTabletIngredients();
        if (ing.isEmpty()) {
            return super.insertItem(slot, stack, simulate);
        }
        if (slot >= ing.size() || !ing.get(slot).test(stack)) {
            return stack;
        }
        this.delegator.setTempLimit(this.getSlotLimit(slot));
        ItemStack remnant = super.insertItem(slot, stack, simulate);
        this.delegator.setTempLimit(-1);
        return remnant;
    }

    @Override
    public int getSlotLimit(int slot) {
        List<Ingredient> ing = this.pedestal.getTabletIngredients();
        if (ing.isEmpty()) {
            return super.getSlotLimit(slot);
        }
        if (slot > ing.size() || ing.get(slot).isEmpty()) {
            return 0;
        }
        return 4;
    }
}

