/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pedestal;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.MultiblockCrafter;
import earth.terrarium.pastel.api.block.PedestalVariant;
import earth.terrarium.pastel.api.color.ItemColors;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.item.GemstoneColor;
import earth.terrarium.pastel.blocks.ActionableBlockEntity;
import earth.terrarium.pastel.blocks.Containerlike;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlock;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockItem;
import earth.terrarium.pastel.blocks.pedestal.PedestalCraftingView;
import earth.terrarium.pastel.blocks.pedestal.PedestalRecipeInput;
import earth.terrarium.pastel.blocks.pedestal.PedestalVariants;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.inventories.PedestalScreenHandler;
import earth.terrarium.pastel.items.magic_items.CraftingTabletItem;
import earth.terrarium.pastel.networking.s2c_payloads.PlayBlockBoundSoundInstancePayload;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.recipe.pedestal.PastelGemstoneColor;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PedestalBlockEntity
extends ActionableBlockEntity
implements MultiblockCrafter,
SidedCapabilityProvider,
MenuProvider,
Containerlike {
    public static final int SIZE = 16;
    public static final int TABLET = 14;
    protected UUID owner;
    protected PedestalVariant variant;
    protected Optional<PedestalTier> tier = Optional.empty();
    protected Upgradeable.UpgradeHolder upgrades;
    public Optional<RecipeHolder> recipe = Optional.empty();
    protected Optional<BlockCapabilityCache<IItemHandler, Direction>> cache = Optional.empty();
    protected int craftingTime = -1;
    protected int totalTime = -1;
    protected int storedXp;
    protected boolean active;
    protected boolean hadTablet;
    protected final ContainerData data;

    public PedestalBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.PEDESTAL.get(), blockPos, blockState, 16);
        this.inventory.addListener(i -> this.setChanged());
        this.refreshVariant();
        this.data = this.initData();
    }

    private void clientTick() {
        if (this.level == null || this.recipe.isEmpty() || !this.isActive()) {
            return;
        }
        RandomSource random = this.level.getRandom();
        int particleColor = this.getPowderColor(random);
        Recipe recipe = this.recipe.get().value();
        if (!(recipe instanceof PedestalRecipe)) {
            this.spawnParticles(ColoredCraftingParticleEffect.of(particleColor));
            return;
        }
        PedestalRecipe pr = (PedestalRecipe)recipe;
        Optional<InkColor> itemColor = ItemColors.ITEM_COLORS.getMapping(pr.getResultItem((HolderLookup.Provider)this.level.registryAccess()).getItem());
        this.spawnParticles(ColoredCraftingParticleEffect.of(itemColor.map(InkColor::getColorInt).orElse(particleColor)));
    }

    private int getPowderColor(RandomSource random) {
        ArrayList<InkColor> colors = new ArrayList<InkColor>();
        for (PastelGemstoneColor color : PastelGemstoneColor.values()) {
            if (this.inventory.getStackInSlot(PedestalBlockEntity.powderSlot(color)).isEmpty()) continue;
            colors.add(color.getInkColor());
        }
        if (colors.isEmpty()) {
            return 16766645;
        }
        return ((InkColor)colors.get(random.nextInt(colors.size()))).getColorInt();
    }

    private void serverTick() {
        if (this.level == null) {
            return;
        }
        if (!this.active) {
            if (((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
                this.active = true;
            } else {
                return;
            }
        }
        if (this.upgrades == null) {
            this.calculateUpgrades();
        }
        PedestalRecipeInput input = this.getInput();
        if (this.recipe.isEmpty() && this.craftingTime > -1) {
            this.findRecipe(input);
        }
        if (this.recipe.isEmpty() || this.craftingTime < 0) {
            return;
        }
        if (this.craftingTime > 0) {
            --this.craftingTime;
            return;
        }
        this.finalizeCrafting(input);
    }

    private void finalizeCrafting(PedestalRecipeInput input) {
        PedestalRecipe pr;
        assert (this.level != null);
        assert (this.recipe.isPresent());
        ItemStack output = this.actionCraft(input);
        Recipe recipe = this.recipe.get().value();
        if (recipe instanceof PedestalRecipe && (pr = (PedestalRecipe)recipe).isStructureUpgrade(this.level.registryAccess())) {
            this.consumeAndPlaySound(input, pr);
            this.upgrade(pr, input);
            this.setChanged();
            this.craftingTime = -1;
            this.totalTime = -1;
            this.active = false;
            return;
        }
        if (!this.outputToStorage(output)) {
            Vec3 pos = this.getBlockPos().getCenter();
            ItemEntity entity = new ItemEntity(this.level, pos.x, pos.y + 1.0, pos.z, output, 0.0, this.level.random.nextDouble() * 0.2 + 0.2, 0.0);
            this.level.addFreshEntity((Entity)entity);
        }
        this.consumeAndPlaySound(input, this.recipe.get().value());
        this.setChanged();
        this.updateInClientWorld();
        this.setRecipeTimings();
    }

    private void upgrade(PedestalRecipe recipe, PedestalRecipeInput input) {
        assert (this.level != null);
        recipe.consumeIngredients(this, input);
        PedestalBlockItem upgrade = (PedestalBlockItem)recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).getItem();
        PedestalBlock.upgradeTo(this.level, this.getBlockPos(), this.getBlockState(), upgrade.getVariant());
        this.level.playSound(null, this.getBlockPos(), PastelSounds.PEDESTAL_UPGRADE, SoundSource.BLOCKS, 1.5f, 1.0f);
    }

    private ItemStack actionCraft(PedestalRecipeInput input) {
        float xp;
        boolean doYield;
        assert (this.recipe.isPresent());
        assert (this.level != null);
        Recipe rec = this.recipe.get().value();
        ItemStack out = ItemStack.EMPTY;
        if (rec instanceof PedestalRecipe) {
            PedestalRecipe pr = (PedestalRecipe)rec;
            out = rec.assemble((RecipeInput)input, (HolderLookup.Provider)this.level.registryAccess());
            doYield = pr.allowsYield();
            xp = pr.getExperience();
        } else {
            out = rec.assemble((RecipeInput)input.getCraftingGridInput(), (HolderLookup.Provider)this.level.registryAccess());
            doYield = !this.isDupe(input.getCraftingGridInput(), (CraftingRecipe)rec, out);
            xp = 1.0f;
        }
        if (doYield) {
            out.setCount(Support.chanceRound((float)out.getCount() * this.upgrades.getEffectiveValue(Upgradeable.UpgradeType.YIELD), this.level.random));
        }
        xp *= this.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EXPERIENCE);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            float finalXp = xp;
            ItemStack finalOut = out;
            Support.areaCriterion(sl, 16, this.getBlockPos(), this.getTier().unlockAdvancementId, p -> PastelCriteria.PEDESTAL_CRAFTING.trigger((ServerPlayer)p, finalOut, (int)finalXp, this.totalTime));
        }
        this.storedXp += Support.chanceRound(xp, this.level.random);
        return out;
    }

    private void consumeAndPlaySound(PedestalRecipeInput input, Recipe<?> rec) {
        SoundEvent sound = PastelSounds.PEDESTAL_CRAFTING_FINISHED_GENERIC;
        if (rec instanceof PedestalRecipe) {
            PedestalRecipe pr = (PedestalRecipe)rec;
            pr.consumeIngredients(this, input);
            sound = pr.getSoundEvent(this.level.random);
        } else {
            for (int i = 0; i < 9; ++i) {
                this.inventory.extractItem(i, 1, false);
            }
        }
        this.level.playSound(null, this.getBlockPos(), sound, SoundSource.BLOCKS, 1.0f, Support.varFloatCentered(this.level.random, 0.15f));
    }

    private boolean isDupe(CraftingInput input, CraftingRecipe recipe, ItemStack out) {
        if (!out.isStackable() || out.getRarity().ordinal() > 1) {
            return true;
        }
        if (recipe.category() == CraftingBookCategory.EQUIPMENT) {
            return true;
        }
        if (input.size() == 1 && input.getItem(0).is(PastelItemTags.PRODUCTIVITY_EXCLUDED)) {
            return true;
        }
        return out.is(PastelItemTags.PRODUCTIVITY_EXCLUDED);
    }

    private void updateCache() {
        if (this.cache.isPresent() && this.cache.get().getCapability() != null) {
            return;
        }
        this.cache = Optional.of(BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos().below(), (Object)Direction.UP, () -> !this.isRemoved(), () -> {
            this.cache = Optional.empty();
        }));
        if (this.cache.get().getCapability() != null) {
            return;
        }
        this.cache = Optional.of(BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos().above(), (Object)Direction.DOWN, () -> !this.isRemoved(), () -> {
            this.cache = Optional.empty();
        }));
    }

    private boolean outputToStorage(ItemStack output) {
        IItemHandler cap;
        if (this.cache.isEmpty()) {
            this.updateCache();
        }
        if ((cap = (IItemHandler)this.cache.get().getCapability()) == null) {
            return false;
        }
        if (ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)output, (boolean)true).isEmpty()) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)output, (boolean)false);
            return true;
        }
        return false;
    }

    private void findRecipe(PedestalRecipeInput input) {
        assert (this.level != null);
        this.recipe = this.level.getRecipeManager().getRecipeFor(PastelRecipeTypes.PEDESTAL, (RecipeInput)input, this.level);
        if (this.recipe.isEmpty()) {
            this.recipe = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input.getCraftingGridInput(), this.level);
        }
        if (!this.verifyRecipe()) {
            this.recipe = Optional.empty();
        }
    }

    private boolean verifyRecipe() {
        if (this.recipe.isEmpty()) {
            return false;
        }
        Optional<RecipeHolder<?>> tablet = this.tabletRecipe();
        if (tablet.map(t -> !t.id().equals((Object)this.recipe.get().id())).orElse(false).booleanValue()) {
            return false;
        }
        assert (this.level != null);
        Recipe rec = this.recipe.get().value();
        if (rec instanceof PedestalRecipe) {
            PedestalRecipe pr = (PedestalRecipe)rec;
            return pr.canCraft(this);
        }
        return true;
    }

    @NotNull
    public PedestalRecipeInput getInput() {
        return PedestalRecipeInput.create(this.inventory.getInternalList(), this.getOwnerIfOnline());
    }

    public void updateTier(Player owner) {
        this.tier = Optional.of(PedestalTier.getTier(Optional.ofNullable(owner), this));
    }

    private void updateRecipe() {
        assert (this.level != null);
        PedestalRecipeInput input = this.getInput();
        Optional<Player> owner = Optional.ofNullable(this.getOwnerIfOnline());
        if (this.tier.isEmpty()) {
            this.tier = Optional.of(PedestalTier.getTier(owner, this));
        }
        if (this.upgrades == null) {
            this.calculateUpgrades();
        }
        if (this.recipe.filter(r -> {
            Recipe rec = r.value();
            if (rec instanceof CraftingRecipe) {
                return rec.matches((RecipeInput)input.getCraftingGridInput(), this.level);
            }
            return rec.matches((RecipeInput)input, this.level);
        }).isPresent() && this.verifyRecipe()) {
            return;
        }
        this.tier = Optional.of(PedestalTier.getTier(owner, this));
        this.findRecipe(input);
        this.setRecipeTimings();
        if (this.active && this.craftingTime == -1) {
            this.setActive(false);
        }
    }

    private void setRecipeTimings() {
        if (this.recipe.isEmpty()) {
            this.craftingTime = -1;
            this.totalTime = -1;
            return;
        }
        RecipeHolder rec = this.recipe.get();
        Recipe recipe = rec.value();
        if (recipe instanceof PedestalRecipe) {
            PedestalRecipe pr = (PedestalRecipe)recipe;
            this.craftingTime = pr.getCraftingTime();
        } else {
            this.craftingTime = PastelCommon.CONFIG.VanillaRecipeCraftingTimeTicks;
        }
        this.totalTime = this.craftingTime = this.adjustCraftingTime(this.craftingTime);
    }

    private int adjustCraftingTime(int base) {
        return Math.round((float)base / this.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
    }

    public void giveStoredXp(Player target) {
        if (this.storedXp == 0) {
            return;
        }
        assert (this.level != null);
        target.giveExperiencePoints(this.storedXp);
        this.storedXp = 0;
        this.level.playSound(null, this.getBlockPos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.3f, 1.0f);
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.updateRecipe();
            this.updateInClientWorld();
        }
    }

    @Override
    public UUID getOwnerUUID() {
        return this.owner;
    }

    @Override
    public void setOwner(Player player) {
        this.owner = player.getUUID();
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.setChanged();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods4(this.level, this.worldPosition, 3, 2, this.owner);
        this.setChanged();
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }

    public static int powderSlot(GemstoneColor gemstoneColor) {
        return 9 + gemstoneColor.getOffset();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.pastel.pedestal");
    }

    public void refreshVariant() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof PedestalBlock) {
            PedestalBlock pedestalBlock = (PedestalBlock)block;
            this.variant = pedestalBlock.getVariant();
        } else {
            this.variant = PedestalVariants.BASIC_AMETHYST;
        }
    }

    private void spawnParticles(ParticleOptions particle) {
        assert (this.level != null);
        RandomSource random = this.level.getRandom();
        Vec3 pos = this.getBlockPos().getCenter().add(random.nextDouble() - 0.5, 0.5, random.nextDouble() - 0.5);
        this.level.addParticle(particle, pos.x, pos.y, pos.z, 0.0, 0.03, 0.0);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            PlayBlockBoundSoundInstancePayload.sendPlayBlockBoundSoundInstance(PastelSounds.PEDESTAL_CRAFTING, (ServerLevel)this.getLevel(), this.getBlockPos(), Integer.MAX_VALUE);
        } else {
            PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((ServerLevel)this.level, this.getBlockPos());
        }
    }

    public PedestalTier getTier() {
        return this.tier.orElse(PedestalTier.BASIC);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.upgrades != null) {
            tag.put("Upgrades", (Tag)this.upgrades.toNbt());
        }
        tag.putBoolean("active", this.active);
        tag.putInt("craftingTime", this.craftingTime);
        this.recipe.ifPresent(recipeHolder -> tag.putString("CurrentRecipe", recipeHolder.id().toString()));
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.upgrades = tag.contains("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(tag.getList("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
        this.active = tag.getBoolean("active");
        this.totalTime = this.craftingTime = tag.getInt("craftingTime");
        this.recipe = Optional.ofNullable(MultiblockCrafter.getRecipeEntryFromNbt(this.level, tag));
    }

    @Override
    public void containerChanged() {
        this.inventoryChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new PedestalScreenHandler(containerId, playerInventory, this, this.data, this.variant.getRecipeTier());
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        PedestalScreenHandler.ScreenOpeningData.STREAM_CODEC.encode((Object)buffer, (Object)new PedestalScreenHandler.ScreenOpeningData(this.getBlockPos(), this.variant.getRecipeTier()));
    }

    public PedestalVariant getVariant() {
        return this.variant;
    }

    @Override
    public FriendlyStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        if (dir.getAxis().isHorizontal()) {
            return this.powderTabletView();
        }
        if (dir == Direction.DOWN) {
            return null;
        }
        return new PedestalCraftingView(this, this.inventory);
    }

    protected List<Ingredient> getTabletIngredients() {
        Recipe recipe;
        Optional<RecipeHolder<?>> autoRecipe = this.tabletRecipe();
        if (autoRecipe.isEmpty() || !((recipe = autoRecipe.get().value()) instanceof CraftingRecipe)) {
            return Collections.emptyList();
        }
        CraftingRecipe cr = (CraftingRecipe)recipe;
        return cr.getIngredients();
    }

    private Optional<RecipeHolder<?>> tabletRecipe() {
        return Optional.ofNullable(CraftingTabletItem.getStoredRecipe(this.level, this.inventory.getStackInSlot(14)));
    }

    @NotNull
    private StackHandlerView powderTabletView() {
        StackHandlerView view = new StackHandlerView(this.inventory, 9, 6);
        List<GemstoneColor> permittedColors = Arrays.asList(this.variant.getRecipeTier().gemstoneColors());
        for (PastelGemstoneColor color : PastelGemstoneColor.values()) {
            int index = PedestalBlockEntity.powderSlot(color) - 9;
            if (!permittedColors.contains(color)) {
                view.addFilter(index);
                continue;
            }
            view.addFilter(index, s -> s.is(color.getPowder()));
        }
        view.addFilter(5, s -> s.is(PastelItems.CRAFTING_TABLET));
        return view;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, PedestalBlockEntity pedestal) {
        pedestal.clientTick();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PedestalBlockEntity pedestal) {
        pedestal.serverTick();
    }

    @NotNull
    private ContainerData initData() {
        ContainerData data = new ContainerData(){

            public int get(int index) {
                if (index == 1) {
                    return PedestalBlockEntity.this.totalTime;
                }
                return PedestalBlockEntity.this.totalTime - PedestalBlockEntity.this.craftingTime;
            }

            public void set(int index, int value) {
            }

            public int getCount() {
                return 2;
            }
        };
        return data;
    }
}

