/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pastel_network.nodes;

import com.cmdpro.databank.DatabankUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.ColorableBlock;
import earth.terrarium.pastel.blocks.decoration.PastelFacingBlock;
import earth.terrarium.pastel.blocks.pastel_network.Pastel;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeType;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PastelNodeBlock
extends PastelFacingBlock
implements EntityBlock,
ColorableBlock {
    public static final MapCodec<PastelNodeBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)PastelNodeBlock.propertiesCodec(), (App)StringRepresentable.fromEnum(PastelNodeType::values).fieldOf("node_type").forGetter(b -> b.pastelNodeType)).apply((Applicative)i, PastelNodeBlock::new));
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty REDSTONE_EMITTING = BlockStateProperties.POWERED;
    public static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.UP, Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0));
            this.put(Direction.DOWN, Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
            this.put(Direction.NORTH, Block.box((double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)16.0));
            this.put(Direction.SOUTH, Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)4.0));
            this.put(Direction.EAST, Block.box((double)0.0, (double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0));
            this.put(Direction.WEST, Block.box((double)12.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
        }
    };
    protected final PastelNodeType pastelNodeType;

    public PastelNodeBlock(BlockBehaviour.Properties settings, PastelNodeType pastelNodeType) {
        super(settings.lightLevel(s -> (Boolean)s.getValue((Property)LIT) != false ? 13 : 0));
        this.pastelNodeType = pastelNodeType;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)REDSTONE_EMITTING, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends PastelNodeBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return PastelCommon.CONFIG.MinimalNodes ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.MODEL;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction targetDirection = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPos targetPos = pos.relative(targetDirection);
        return world.getBlockState(targetPos).isSolid();
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        PastelNodeBlockEntity blockEntity;
        if (!newState.is(state.getBlock()) && (blockEntity = this.getBlockEntity((LevelAccessor)world, pos)) != null) {
            blockEntity.onBroken();
            blockEntity.getOuterRing().ifPresent(r -> PastelNodeBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)r.upgradeItem.getDefaultInstance()));
            blockEntity.getInnerRing().ifPresent(r -> PastelNodeBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)r.upgradeItem.getDefaultInstance()));
            blockEntity.getRedstoneRing().ifPresent(r -> PastelNodeBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)r.upgradeItem.getDefaultInstance()));
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getClickedFace();
        BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos().relative(direction.getOpposite()));
        return blockState.is((Block)this) && blockState.getValue((Property)FACING) == direction ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite()) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (w, p, s, b) -> PastelNodeBlockEntity.tick(w, p, s, (PastelNodeBlockEntity)b);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.addAll(this.pastelNodeType.getTooltips());
        tooltip.add((Component)Component.translatable((String)"block.pastel.pastel_network_nodes.tooltip.range", (Object[])new Object[]{12}).withStyle(ChatFormatting.GRAY));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT, REDSTONE_EMITTING});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : state;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        @Nullable PastelNodeBlockEntity blockEntity = this.getBlockEntity((LevelAccessor)world, pos);
        if (blockEntity == null) {
            return super.useItemOn(stack, state, world, pos, player, hand, hit);
        }
        if (player.isShiftKeyDown() && stack.isEmpty()) {
            if (DatabankUtils.hasAdvancement((Player)player, (ResourceLocation)PastelAdvancements.Milestones.UNLOCK_PASTEL_NODE_UPGRADING)) {
                ItemStack removed;
                if (!world.isClientSide && !(removed = blockEntity.tryRemoveUpgrade()).isEmpty()) {
                    if (!player.getAbilities().instabuild) {
                        player.getInventory().placeItemBackInInventory(removed);
                    }
                    blockEntity.updateUpgrades();
                    blockEntity.setChanged();
                    blockEntity.updateInClientWorld();
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.is((Item)PastelItems.TUNING_STAMP.get())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.isCreative() && stack.is((Item)PastelItems.PAINTBRUSH.get())) {
            PastelNodeBlock.sendDebugMessage(world, pos, player, blockEntity);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (DatabankUtils.hasAdvancement((Player)player, (ResourceLocation)PastelAdvancements.Milestones.UNLOCK_PASTEL_NODE_UPGRADING) && stack.is(PastelItemTags.PASTEL_NODE_UPGRADES)) {
            if (!world.isClientSide() && blockEntity.tryInteractRings(stack, this.pastelNodeType)) {
                PastelCriteria.PASTEL_NODE_UPGRADING.trigger((ServerPlayer)player, stack);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                blockEntity.updateUpgrades();
                blockEntity.setChanged();
                blockEntity.updateInClientWorld();
            }
            world.playLocalSound(pos, PastelSounds.MEDIUM_CRYSTAL_RING, SoundSource.BLOCKS, 0.25f, 0.9f + world.getRandom().nextFloat() * 0.2f, true);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (this.pastelNodeType.usesFilters()) {
            if (!world.isClientSide) {
                player.openMenu((MenuProvider)blockEntity);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return (Boolean)state.getValue((Property)REDSTONE_EMITTING) != false ? 15 : 0;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)REDSTONE_EMITTING, (Comparable)Boolean.valueOf(false)));
    }

    private static void sendDebugMessage(Level world, BlockPos pos, Player player, PastelNodeBlockEntity blockEntity) {
        if (blockEntity != null) {
            String colorString;
            Optional network = blockEntity.networkUUID.isPresent() ? Pastel.getInstance(world.isClientSide).getNetwork(blockEntity.networkUUID.get()) : Optional.empty();
            String prefix = world.isClientSide ? "C (" : "S (";
            Optional<DyeColor> color = blockEntity.getColor();
            String string = colorString = color.isEmpty() ? "<uncolored>" : color.get().toString();
            if (network.isEmpty()) {
                player.sendSystemMessage((Component)Component.literal((String)(prefix + colorString + "): No connected network :(")));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)(prefix + colorString + "): " + ((PastelNetwork)network.get()).getNodeDebugText())));
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    @Nullable
    public PastelNodeBlockEntity getBlockEntity(LevelAccessor world, BlockPos blockPos) {
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (blockEntity instanceof PastelNodeBlockEntity) {
            PastelNodeBlockEntity pastelNodeBlockEntity = (PastelNodeBlockEntity)blockEntity;
            return pastelNodeBlockEntity;
        }
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PastelNodeBlockEntity(pos, state);
    }

    @Override
    public boolean color(Level world, BlockPos pos, Optional<DyeColor> color, @Nullable Entity user) {
        if (!(user instanceof Player)) {
            return false;
        }
        Player player = (Player)user;
        if (!DatabankUtils.hasAdvancement((Player)player, (ResourceLocation)PastelAdvancements.Milestones.UNLOCK_PASTEL_NODE_COLORING)) {
            return false;
        }
        @Nullable PastelNodeBlockEntity blockEntity = this.getBlockEntity((LevelAccessor)world, pos);
        if (blockEntity == null) {
            return false;
        }
        return blockEntity.setColor(color, user);
    }

    @Override
    public Optional<DyeColor> getColor(Level world, BlockPos pos) {
        @Nullable PastelNodeBlockEntity blockEntity = this.getBlockEntity((LevelAccessor)world, pos);
        if (blockEntity == null) {
            return Optional.empty();
        }
        return blockEntity.getColor();
    }
}

