/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pastel_network.network;

import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public class PastelNetwork<W extends Level> {
    protected Graph<BlockPos, DefaultEdge> graph = new SimpleGraph(DefaultEdge.class);
    protected final W world;
    protected final UUID uuid;
    protected int color;

    public PastelNetwork(W world, UUID uuid, int color) {
        this.world = world;
        this.uuid = uuid;
        this.color = color;
    }

    public int size() {
        return this.graph.vertexSet().size();
    }

    public W getLevel() {
        return this.world;
    }

    public Graph<BlockPos, DefaultEdge> getGraph() {
        return this.graph;
    }

    public boolean addEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity parent) {
        return this.addEdge(node.getBlockPos(), parent.getBlockPos());
    }

    public boolean addEdge(BlockPos pos1, BlockPos pos2) {
        if (!this.hasEdge(pos1, pos2)) {
            this.graph.addEdge((Object)pos1, (Object)pos2);
            return true;
        }
        return false;
    }

    public boolean hasEdge(BlockPos pos1, BlockPos pos2) {
        if (!this.graph.containsVertex((Object)pos1) || !this.graph.containsVertex((Object)pos2)) {
            return false;
        }
        return this.graph.containsEdge((Object)pos1, (Object)pos2);
    }

    public boolean removeEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity parent) {
        return this.graph.removeEdge((Object)node.getBlockPos(), (Object)parent.getBlockPos()) != null;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(Optional<DyeColor> dyeColor) {
        if (dyeColor.isEmpty()) {
            return;
        }
        int newColor = dyeColor.get().getTextureDiffuseColor();
        if (newColor == this.color) {
            return;
        }
        this.color = newColor;
    }

    public void setGraph(Graph<BlockPos, DefaultEdge> graph) {
        this.graph = graph;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof PastelNetwork) {
            PastelNetwork p = (PastelNetwork)other;
            return this.uuid.equals(p.uuid);
        }
        return false;
    }

    public CompoundTag graphToNbt() {
        ArrayList vertices = new ArrayList(this.graph.vertexSet());
        CompoundTag graphStorage = new CompoundTag();
        graphStorage.putInt("Size", vertices.size());
        for (int i = 0; i < vertices.size(); ++i) {
            BlockPos vertex = (BlockPos)vertices.get(i);
            graphStorage.putLong("Vertex" + i, vertex.asLong());
            int currentVertex = i;
            List edgeIndexes = this.graph.edgesOf((Object)vertex).stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).mapToInt(vertices::indexOf).filter(v -> v != currentVertex).boxed().collect(Collectors.toList());
            if (edgeIndexes.isEmpty()) continue;
            edgeIndexes.add(0, vertices.indexOf(vertex));
            graphStorage.putIntArray("EdgeIndexes" + i, edgeIndexes);
        }
        return graphStorage;
    }

    public static Graph<BlockPos, DefaultEdge> graphFromNbt(CompoundTag nbt) {
        int i;
        SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
        int size = nbt.getInt("Size");
        ArrayList<BlockPos> vertices = new ArrayList<BlockPos>();
        for (i = 0; i < size; ++i) {
            BlockPos vertex = BlockPos.of((long)nbt.getLong("Vertex" + i));
            vertices.add(vertex);
            graph.addVertex((Object)vertex);
        }
        for (i = 0; i < size; ++i) {
            if (!nbt.contains("EdgeIndexes" + i)) continue;
            int[] edgeIndexes = nbt.getIntArray("EdgeIndexes" + i);
            BlockPos source = (BlockPos)vertices.get(edgeIndexes[0]);
            for (int targetIndex = 1; targetIndex < edgeIndexes.length; ++targetIndex) {
                BlockPos target = (BlockPos)vertices.get(edgeIndexes[targetIndex]);
                if (graph.containsEdge((Object)source, (Object)target)) continue;
                graph.addEdge((Object)source, (Object)target);
            }
        }
        return graph;
    }

    public String getNodeDebugText() {
        return "UUID: " + this.uuid.toString() + " - Edges: " + this.graph.edgeSet().size() + " - Vertices: " + this.graph.vertexSet().size();
    }

    public static enum NodePriority {
        GENERIC,
        MODERATE,
        HIGH;

    }
}

