/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.mob_head.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PastelSkullModel
extends SkullModelBase {
    protected static final float ROTATION_VEC = (float)Math.PI / 180;
    protected final ModelPart head;

    public PastelSkullModel(ModelPart root) {
        this.head = root.getChild("head");
    }

    public void render(PoseStack matrices, VertexConsumer vertices, MultiBufferSource vertexConsumerProvider, int light, int overlay, int color) {
        float scale = this.getScale();
        matrices.scale(scale, scale, scale);
        this.renderToBuffer(matrices, vertices, light, overlay, color);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.head.render(matrices, vertices, light, overlay, color);
    }

    public void setupAnim(float animationProgress, float yaw, float pitch) {
        this.head.yRot = yaw * ((float)Math.PI / 180);
        this.head.xRot = pitch * ((float)Math.PI / 180);
    }

    public float getScale() {
        return 0.86f;
    }
}

