/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.jade_vines;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.api.interaction.NaturesStaffTriggered;
import earth.terrarium.pastel.blocks.jade_vines.JadeVine;
import earth.terrarium.pastel.blocks.jade_vines.JadeVineBulbBlock;
import earth.terrarium.pastel.blocks.jade_vines.JadeVinePlantBlock;
import earth.terrarium.pastel.blocks.jade_vines.JadeVineRootsBlockEntity;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeVineRootsBlock
extends BaseEntityBlock
implements JadeVine,
NaturesStaffTriggered {
    public static final MapCodec<JadeVineRootsBlock> CODEC = JadeVineRootsBlock.simpleCodec(JadeVineRootsBlock::new);
    public static final BooleanProperty DEAD = JadeVine.DEAD;

    public JadeVineRootsBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DEAD, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends JadeVineRootsBlock> codec() {
        return CODEC;
    }

    public static boolean canBePlantedOn(BlockState blockState) {
        return blockState.is(BlockTags.WOODEN_FENCES);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (!((Boolean)state.getValue((Property)DEAD)).booleanValue()) {
            JadeVine.spawnParticlesClient(world, pos);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return ((Item)PastelItems.GERMINATED_JADE_VINE_BULB.get()).getDefaultInstance();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        BlockEntity blockEntity;
        super.onPlace(state, world, pos, oldState, notify);
        if (oldState.getBlock() instanceof FenceBlock && (blockEntity = world.getBlockEntity(pos)) instanceof JadeVineRootsBlockEntity) {
            JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
            jadeVineRootsBlockEntity.setFenceBlockState(oldState.getBlock().defaultBlockState());
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!newState.is((Block)this) && (blockEntity = world.getBlockEntity(pos)) instanceof JadeVineRootsBlockEntity) {
            JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
            world.setBlockAndUpdate(pos, jadeVineRootsBlockEntity.getFenceBlockState());
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader world, BlockPos pos) {
        return JadeVineRootsBlock.canBePlantedOn(world.getBlockState(pos));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DEAD});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new JadeVineRootsBlockEntity(pos, state);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)DEAD) == false;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        if (!world.isClientSide && this.isRandomlyTicking(state)) {
            int age = this.getAge((Level)world, pos, state);
            if (JadeVine.isExposedToSunlight((Level)world, pos) || age < 0) {
                this.exposedToSunlight(world, pos);
            } else if (this.canGrow((Level)world, pos)) {
                if (world.random.nextBoolean() && this.tryGrowUpwards(state, (Level)world, pos)) {
                    this.rememberGrownTime((Level)world, pos);
                    world.playSound(null, pos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 0.5f, 0.9f + 0.2f * world.random.nextFloat() * 0.2f);
                } else if (this.tryGrowDownwards((Level)world, pos)) {
                    this.rememberGrownTime((Level)world, pos);
                    world.playSound(null, pos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 0.5f, 0.9f + 0.2f * world.random.nextFloat() * 0.2f);
                } else {
                    boolean couldGrow;
                    int targetAge = age;
                    if (age == 6) {
                        if (world.getMoonPhase() == 0) {
                            targetAge = 7;
                        }
                    } else if (age == 7) {
                        if (world.getMoonPhase() > 2) {
                            targetAge = 6;
                        }
                    } else {
                        targetAge = age + 1;
                    }
                    if (targetAge != age && (couldGrow = this.setPlantToAge(world, pos, targetAge))) {
                        world.playSound(null, pos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 0.5f, 0.9f + 0.2f * world.random.nextFloat() * 0.2f);
                    }
                    this.rememberGrownTime((Level)world, pos);
                }
            }
        }
    }

    private void exposedToSunlight(ServerLevel world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(this.getLowestRootsPos((Level)world, pos));
        if (blockEntity instanceof JadeVineRootsBlockEntity) {
            JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
            if (jadeVineRootsBlockEntity.wasExposedToSunlight()) {
                this.setDead(world, pos);
                world.playSound(null, pos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 0.5f, 0.9f + 0.2f * world.random.nextFloat() * 0.2f);
            } else {
                jadeVineRootsBlockEntity.setExposedToSunlight(true);
            }
        }
    }

    boolean setPlantToAge(@NotNull ServerLevel world, @NotNull BlockPos blockPos, int age) {
        BlockPos downPos;
        BlockState downState;
        JadeVineRootsBlock jadeVineRootsBlock;
        BlockPos upPos;
        BlockState upState;
        Block block;
        this.setToAge((Level)world, blockPos, age);
        boolean anyGrown = false;
        int i = 1;
        while ((block = (upState = world.getBlockState(upPos = blockPos.above(i))).getBlock()) instanceof JadeVineRootsBlock) {
            jadeVineRootsBlock = (JadeVineRootsBlock)block;
            if (jadeVineRootsBlock.setToAge((Level)world, upPos, age)) {
                anyGrown = true;
                JadeVine.spawnParticlesServer(world, upPos, 8);
            }
            ++i;
        }
        i = 1;
        while ((block = (downState = world.getBlockState(downPos = blockPos.below(i))).getBlock()) instanceof JadeVineRootsBlock) {
            jadeVineRootsBlock = (JadeVineRootsBlock)block;
            if (jadeVineRootsBlock.setToAge((Level)world, downPos, age)) {
                anyGrown = true;
                JadeVine.spawnParticlesServer(world, downPos, 8);
            }
            ++i;
        }
        BlockPos plantPos = blockPos.below(i);
        BlockState plantState = world.getBlockState(plantPos);
        Block plantBlock = plantState.getBlock();
        if (plantBlock instanceof JadeVinePlantBlock) {
            JadeVinePlantBlock jadeVinePlantBlock = (JadeVinePlantBlock)plantBlock;
            if (jadeVinePlantBlock.setToAge((Level)world, plantPos, age) && jadeVinePlantBlock.setToAge((Level)world, plantPos.below(), age) && jadeVinePlantBlock.setToAge((Level)world, plantPos.below(2), age)) {
                anyGrown = true;
                JadeVine.spawnParticlesServer(world, plantPos, 16);
                JadeVine.spawnParticlesServer(world, plantPos.below(), 16);
                JadeVine.spawnParticlesServer(world, plantPos.below(2), 16);
            }
        } else if (plantBlock instanceof JadeVineBulbBlock) {
            JadeVineBulbBlock jadeVineBulbBlock = (JadeVineBulbBlock)plantBlock;
            if (jadeVineBulbBlock.setToAge((Level)world, plantPos, age)) {
                anyGrown = true;
                JadeVine.spawnParticlesServer(world, plantPos, 16);
            }
        } else if (plantState.isAir() && age > 0) {
            world.setBlockAndUpdate(plantPos, ((Block)PastelBlocks.JADE_VINE_BULB.get()).defaultBlockState());
            anyGrown = true;
            JadeVine.spawnParticlesServer(world, plantPos, 16);
        }
        return anyGrown;
    }

    int getAge(Level world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)DEAD)).booleanValue()) {
            return 0;
        }
        BlockPos lowestRootsPos = this.getLowestRootsPos(world, blockPos);
        BlockState plantState = world.getBlockState(lowestRootsPos.below());
        Block plantBlock = plantState.getBlock();
        if (plantBlock instanceof JadeVinePlantBlock) {
            return (Integer)plantState.getValue((Property)JadeVinePlantBlock.AGE);
        }
        if (plantBlock instanceof JadeVineBulbBlock) {
            return 1;
        }
        return -1;
    }

    boolean canGrow(@NotNull Level world, @NotNull BlockPos blockPos) {
        BlockEntity blockEntity = world.getBlockEntity(this.getLowestRootsPos(world, blockPos));
        if (blockEntity instanceof JadeVineRootsBlockEntity) {
            JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
            return world.getBrightness(LightLayer.SKY, blockPos) > 8 && jadeVineRootsBlockEntity.isLaterNight(world);
        }
        return false;
    }

    boolean tryGrowUpwards(@NotNull BlockState blockState, @NotNull Level world, @NotNull BlockPos blockPos) {
        blockPos = blockPos.above();
        while (world.getBlockState(blockPos).getBlock() instanceof JadeVineRootsBlock) {
            blockPos = blockPos.above();
        }
        BlockState targetState = world.getBlockState(blockPos);
        if (JadeVineRootsBlock.canBePlantedOn(targetState)) {
            world.setBlockAndUpdate(blockPos, blockState);
            BlockEntity blockEntity = world.getBlockEntity(blockPos);
            if (blockEntity instanceof JadeVineRootsBlockEntity) {
                JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
                jadeVineRootsBlockEntity.setFenceBlockState(targetState.getBlock().defaultBlockState());
            }
            return true;
        }
        return false;
    }

    boolean tryGrowDownwards(@NotNull Level world, @NotNull BlockPos blockPos) {
        blockPos = blockPos.below();
        while (world.getBlockState(blockPos).getBlock() instanceof JadeVineRootsBlock) {
            blockPos = blockPos.below();
        }
        BlockState targetState = world.getBlockState(blockPos);
        if (targetState.getBlock() instanceof JadeVineBulbBlock) {
            if (world.getBlockState(blockPos.below()).isAir() && world.getBlockState(blockPos.below(2)).isAir()) {
                world.setBlockAndUpdate(blockPos, (BlockState)((Block)PastelBlocks.JADE_VINES.get()).defaultBlockState().setValue(JadeVinePlantBlock.PART, (Comparable)((Object)JadeVinePlantBlock.JadeVinesPlantPart.BASE)));
                world.setBlockAndUpdate(blockPos.below(), (BlockState)((Block)PastelBlocks.JADE_VINES.get()).defaultBlockState().setValue(JadeVinePlantBlock.PART, (Comparable)((Object)JadeVinePlantBlock.JadeVinesPlantPart.MIDDLE)));
                world.setBlockAndUpdate(blockPos.below(2), (BlockState)((Block)PastelBlocks.JADE_VINES.get()).defaultBlockState().setValue(JadeVinePlantBlock.PART, (Comparable)((Object)JadeVinePlantBlock.JadeVinesPlantPart.TIP)));
                return true;
            }
        } else {
            if (targetState.isAir()) {
                world.setBlockAndUpdate(blockPos, ((Block)PastelBlocks.JADE_VINE_BULB.get()).defaultBlockState());
                return true;
            }
            if (JadeVineRootsBlock.canBePlantedOn(targetState)) {
                BlockEntity newBlockEntity;
                world.setBlockAndUpdate(blockPos, ((Block)PastelBlocks.JADE_VINE_ROOTS.get()).defaultBlockState());
                long lastGrowTime = -1L;
                BlockEntity currentBlockEntity = world.getBlockEntity(blockPos.above());
                if (currentBlockEntity instanceof JadeVineRootsBlockEntity) {
                    JadeVineRootsBlockEntity rootsBlockEntity = (JadeVineRootsBlockEntity)currentBlockEntity;
                    lastGrowTime = rootsBlockEntity.getLastGrownTime();
                }
                if ((newBlockEntity = world.getBlockEntity(blockPos)) instanceof JadeVineRootsBlockEntity) {
                    JadeVineRootsBlockEntity rootsBlockEntity = (JadeVineRootsBlockEntity)newBlockEntity;
                    rootsBlockEntity.setFenceBlockState(targetState.getBlock().defaultBlockState());
                    if (lastGrowTime > 0L) {
                        rootsBlockEntity.setLastGrownTime(lastGrowTime);
                    } else {
                        rootsBlockEntity.setLastGrownTime(world.getGameTime());
                    }
                }
                return true;
            }
        }
        return false;
    }

    void setDead(@NotNull ServerLevel world, @NotNull BlockPos blockPos) {
        this.setPlantToAge(world, blockPos, 0);
    }

    void rememberGrownTime(@NotNull Level world, @NotNull BlockPos blockPos) {
        BlockEntity blockEntity = world.getBlockEntity(this.getLowestRootsPos(world, blockPos));
        if (blockEntity instanceof JadeVineRootsBlockEntity) {
            JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
            jadeVineRootsBlockEntity.setLastGrownTime(world.getDayTime());
        }
    }

    public BlockPos getLowestRootsPos(@NotNull Level world, @NotNull BlockPos blockPos) {
        int i = 0;
        while (world.getBlockState(blockPos.below(i + 1)).getBlock() instanceof JadeVineRootsBlock && blockPos.getY() - ++i >= world.getMinBuildHeight()) {
        }
        return blockPos.below(i);
    }

    @Override
    public boolean setToAge(@NotNull Level world, BlockPos blockPos, int age) {
        BlockState currentState = world.getBlockState(blockPos);
        boolean dead = (Boolean)currentState.getValue((Property)DEAD);
        if (age == 0 && !dead) {
            world.setBlockAndUpdate(blockPos, (BlockState)currentState.setValue((Property)DEAD, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        if (age > 0 && dead) {
            world.setBlockAndUpdate(blockPos, (BlockState)currentState.setValue((Property)DEAD, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseNaturesStaff(Level world, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)DEAD);
    }

    @Override
    public boolean onNaturesStaffUse(Level world, BlockPos pos, BlockState state, Player player) {
        this.setPlantToAge((ServerLevel)world, pos, 1);
        JadeVine.spawnParticlesServer((ServerLevel)world, pos, 16);
        return false;
    }
}

