/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.item_roundel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import earth.terrarium.pastel.blocks.item_roundel.ItemRoundelBlockEntity;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemRoundelBlockEntityRenderer<T extends ItemRoundelBlockEntity>
implements BlockEntityRenderer<T> {
    private static final float distance = 0.29f;

    public ItemRoundelBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ItemRoundelBlockEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        if (!blockEntity.isEmpty()) {
            ArrayList<ItemStack> inventoryStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < blockEntity.getContainerSize(); ++i) {
                ItemStack stack = blockEntity.getItem(i);
                if (stack.isEmpty()) continue;
                if (blockEntity.renderStacksAsIndividualItems()) {
                    for (int j = 0; j < stack.getCount(); ++j) {
                        inventoryStacks.add(stack);
                    }
                    continue;
                }
                inventoryStacks.add(stack);
            }
            float time = (float)(blockEntity.getLevel().getGameTime() % 24000L) + tickDelta;
            double radiant = Math.toRadians(360.0f / (float)inventoryStacks.size());
            for (int i = 0; i < inventoryStacks.size(); ++i) {
                poseStack.pushPose();
                double bob = Math.sin(time / 19.0f + (float)i) * 0.075;
                double currentRadiant = radiant * (double)i + radiant * ((double)time / 16.0) / (double)(8.0f / (float)inventoryStacks.size());
                poseStack.translate((double)0.29f * Math.sin(currentRadiant) + 0.5, 0.3 + bob, (double)0.29f * Math.cos(currentRadiant) + 0.5);
                poseStack.mulPose(Axis.YP.rotationDegrees((float)(i * 360 / inventoryStacks.size()) + time / 16.0f / 8.0f * 360.0f));
                Minecraft.getInstance().getItemRenderer().renderStatic((ItemStack)inventoryStacks.get(i), ItemDisplayContext.GROUND, light, overlay, poseStack, vertexConsumerProvider, blockEntity.getLevel(), 0);
                poseStack.popPose();
            }
        }
    }
}

