/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.item_bowl;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.InWorldInteractionBlock;
import earth.terrarium.pastel.blocks.enchanter.EnchanterBlockEntity;
import earth.terrarium.pastel.blocks.item_bowl.ItemBowlBlockEntity;
import earth.terrarium.pastel.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBowlBlock
extends InWorldInteractionBlock {
    public static final MapCodec<ItemBowlBlock> CODEC = ItemBowlBlock.simpleCodec(ItemBowlBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    private final List<Vec3i> possibleEnchanterOffsets = new ArrayList<Vec3i>(){
        {
            this.add(new Vec3i(5, 0, 3));
            this.add(new Vec3i(-5, 0, -3));
            this.add(new Vec3i(-3, 0, 5));
            this.add(new Vec3i(-3, 0, -5));
            this.add(new Vec3i(3, 0, 5));
            this.add(new Vec3i(3, 0, -5));
            this.add(new Vec3i(5, 0, 3));
            this.add(new Vec3i(5, 0, -3));
        }
    };
    private final List<Vec3i> possibleSpiritInstillerOffsets = new ArrayList<Vec3i>(){
        {
            this.add(new Vec3i(0, -1, 2));
            this.add(new Vec3i(0, -1, -2));
            this.add(new Vec3i(2, -1, 0));
            this.add(new Vec3i(-2, -1, 0));
        }
    };

    public ItemBowlBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends ItemBowlBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ItemBowlBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? ItemBowlBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.ITEM_BOWL.get()), ItemBowlBlockEntity::clientTick) : null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        super.onRemove(state, world, pos, newState, moved);
        this.updateConnectedMultiBlocks(world, pos);
    }

    private void updateConnectedMultiBlocks(@NotNull Level world, @NotNull BlockPos pos) {
        BlockEntity blockEntity;
        BlockPos currentPos;
        for (Vec3i possibleUpgradeBlockOffset : this.possibleEnchanterOffsets) {
            currentPos = pos.offset(possibleUpgradeBlockOffset);
            blockEntity = world.getBlockEntity(currentPos);
            if (!(blockEntity instanceof EnchanterBlockEntity)) continue;
            EnchanterBlockEntity enchanterBlockEntity = (EnchanterBlockEntity)blockEntity;
            enchanterBlockEntity.inventoryChanged();
            break;
        }
        for (Vec3i possibleUpgradeBlockOffset : this.possibleSpiritInstillerOffsets) {
            currentPos = pos.offset(possibleUpgradeBlockOffset);
            blockEntity = world.getBlockEntity(currentPos);
            if (!(blockEntity instanceof SpiritInstillerBlockEntity)) continue;
            SpiritInstillerBlockEntity spiritInstillerBlockEntity = (SpiritInstillerBlockEntity)blockEntity;
            spiritInstillerBlockEntity.inventoryChanged();
            break;
        }
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemBowlBlockEntity itemBowlBlockEntity;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ItemBowlBlockEntity && this.exchangeStack(world, pos, player, hand, handStack, itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity)) {
            this.updateConnectedMultiBlocks(world, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
    }
}

