/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class StatusEffectIdolBlock
extends IdolBlock {
    protected final Holder<MobEffect> statusEffect;
    protected final int amplifier;
    protected final int duration;

    public StatusEffectIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, Holder<MobEffect> statusEffect, int amplifier, int duration) {
        super(settings, particleEffect);
        this.statusEffect = statusEffect;
        this.amplifier = amplifier;
        this.duration = duration;
    }

    public MapCodec<? extends StatusEffectIdolBlock> codec() {
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.potion_effect_idol.tooltip", (Object[])new Object[]{((MobEffect)this.statusEffect.value()).getDisplayName()}));
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(this.statusEffect, this.duration, this.amplifier, true, true));
            if (this.statusEffect == MobEffects.FIRE_RESISTANCE && livingEntity.isOnFire()) {
                livingEntity.setRemainingFireTicks(0);
            }
            return true;
        }
        return false;
    }
}

