/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class KnockbackIdolBlock
extends IdolBlock {
    protected final float horizontalKnockback;
    protected final float verticalKnockback;

    public KnockbackIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, float horizontalKnockback, float verticalKnockback) {
        super(settings, particleEffect);
        this.horizontalKnockback = horizontalKnockback;
        this.verticalKnockback = verticalKnockback;
    }

    public MapCodec<? extends KnockbackIdolBlock> codec() {
        return null;
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        if (entity != null) {
            switch (side) {
                case NORTH: {
                    entity.push(0.0, (double)this.verticalKnockback, (double)(-this.horizontalKnockback));
                    entity.hurtMarked = true;
                    break;
                }
                case EAST: {
                    entity.push((double)this.horizontalKnockback, (double)this.verticalKnockback, 0.0);
                    entity.hurtMarked = true;
                    break;
                }
                case SOUTH: {
                    entity.push(0.0, (double)this.verticalKnockback, (double)this.horizontalKnockback);
                    entity.hurtMarked = true;
                    break;
                }
                case WEST: {
                    entity.push((double)(-this.horizontalKnockback), (double)this.verticalKnockback, 0.0);
                    entity.hurtMarked = true;
                    break;
                }
                case UP: {
                    entity.push(0.0, (double)(this.horizontalKnockback / 4.0f), 0.0);
                    entity.hurtMarked = true;
                    break;
                }
                default: {
                    entity.push(0.0, (double)(-(this.horizontalKnockback / 4.0f)), 0.0);
                    entity.hurtMarked = true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.knockback_idol.tooltip"));
    }
}

