/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirestarterIdolBlock
extends IdolBlock {
    public static final Map<Block, Tuple<BlockState, Float>> BURNING_MAP = new HashMap<Block, Tuple<BlockState, Float>>(){
        {
            this.put(Blocks.RED_MUSHROOM, new Tuple((Object)Blocks.CRIMSON_FUNGUS.defaultBlockState(), (Object)Float.valueOf(0.2f)));
            this.put(Blocks.BROWN_MUSHROOM, new Tuple((Object)Blocks.WARPED_FUNGUS.defaultBlockState(), (Object)Float.valueOf(0.2f)));
            this.put(Blocks.SAND, new Tuple((Object)Blocks.RED_SAND.defaultBlockState(), (Object)Float.valueOf(1.0f)));
            this.put(Blocks.SNOW, new Tuple((Object)Blocks.AIR.defaultBlockState(), (Object)Float.valueOf(1.0f)));
            this.put(Blocks.GRASS_BLOCK, new Tuple((Object)Blocks.DIRT.defaultBlockState(), (Object)Float.valueOf(0.05f)));
            this.put(Blocks.CALCITE, new Tuple((Object)Blocks.BASALT.defaultBlockState(), (Object)Float.valueOf(0.5f)));
            this.put(Blocks.NETHERRACK, new Tuple((Object)Blocks.MAGMA_BLOCK.defaultBlockState(), (Object)Float.valueOf(0.25f)));
            this.put(Blocks.MAGMA_BLOCK, new Tuple((Object)Blocks.LAVA.defaultBlockState(), (Object)Float.valueOf(0.5f)));
            this.put((Block)PastelBlocks.FROSTBITE_CRYSTAL.get(), new Tuple((Object)((Block)PastelBlocks.BLAZING_CRYSTAL.get()).defaultBlockState(), (Object)Float.valueOf(0.5f)));
        }
    };

    public FirestarterIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect) {
        super(settings, particleEffect);
    }

    public MapCodec<? extends FirestarterIdolBlock> codec() {
        return null;
    }

    public static void addBlockSmeltingRecipes(@NotNull MinecraftServer server) {
        RegistryAccess.Frozen manager = server.registryAccess();
        for (RecipeHolder recipe : server.getRecipeManager().getAllRecipesFor(RecipeType.SMELTING)) {
            ItemStack[] inputStacks;
            NonNullList ingredients;
            BlockItem outputBlockItem;
            ItemStack outputStack = ((SmeltingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)manager);
            Item item = outputStack.getItem();
            if (!(item instanceof BlockItem) || (outputBlockItem = (BlockItem)item).getBlock() == Blocks.AIR || (ingredients = ((SmeltingRecipe)recipe.value()).getIngredients()).isEmpty()) continue;
            for (ItemStack inputStack : inputStacks = ((Ingredient)ingredients.get(0)).getItems()) {
                BlockItem inputBlockItem;
                Item item2 = inputStack.getItem();
                if (!(item2 instanceof BlockItem) || (inputBlockItem = (BlockItem)item2).getBlock() == Blocks.AIR) continue;
                BURNING_MAP.put(inputBlockItem.getBlock(), (Tuple<BlockState, Float>)new Tuple((Object)outputBlockItem.getBlock().defaultBlockState(), (Object)Float.valueOf(1.0f)));
            }
        }
    }

    public static boolean causeFire(@NotNull ServerLevel world, BlockPos blockPos, Direction side) {
        BlockState blockState = world.getBlockState(blockPos);
        if (CampfireBlock.canLight((BlockState)blockState) || CandleBlock.canLight((BlockState)blockState) || CandleCakeBlock.canLight((BlockState)blockState)) {
            world.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
            world.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, blockPos);
            return true;
        }
        if (blockState.is(BlockTags.ICE)) {
            world.setBlockAndUpdate(blockPos, Blocks.WATER.defaultBlockState());
            return true;
        }
        if (BURNING_MAP.containsKey(blockState.getBlock())) {
            Tuple<BlockState, Float> dest = BURNING_MAP.get(blockState.getBlock());
            if (((Float)dest.getB()).floatValue() >= 1.0f || world.random.nextFloat() < ((Float)dest.getB()).floatValue()) {
                world.setBlock(blockPos, (BlockState)dest.getA(), 11);
                world.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, blockPos);
            }
            return true;
        }
        if (BaseFireBlock.canBePlacedAt((Level)world, (BlockPos)blockPos, (Direction)side)) {
            BlockState blockState2 = BaseFireBlock.getState((BlockGetter)world, (BlockPos)blockPos);
            world.setBlock(blockPos, blockState2, 11);
            world.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, blockPos);
            return true;
        }
        return false;
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        for (Direction direction : Direction.values()) {
            if (!FirestarterIdolBlock.causeFire(world, blockPos.relative(direction), direction)) continue;
            world.playSound(null, blockPos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
        }
        return true;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.firestarter_idol.tooltip"));
    }
}

