/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class EntitySummoningIdolBlock
extends IdolBlock {
    protected final EntityType<?> entityType;

    public EntitySummoningIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, EntityType<?> entityType) {
        super(settings, particleEffect);
        this.entityType = entityType;
    }

    public MapCodec<? extends EntitySummoningIdolBlock> codec() {
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.entity_summoning_idol.tooltip", (Object[])new Object[]{this.entityType.getDescription()}));
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        Entity summonedEntity = this.entityType.create((Level)world);
        if (summonedEntity != null) {
            summonedEntity.moveTo(blockPos.above(), 0.0f, 0.0f);
            if (summonedEntity instanceof Mob) {
                Mob mobEntity = (Mob)summonedEntity;
                mobEntity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(blockPos), MobSpawnType.MOB_SUMMONED, null);
            }
            this.afterSummon(world, summonedEntity);
            world.addFreshEntityWithPassengers(summonedEntity);
        }
        return true;
    }

    public abstract void afterSummon(ServerLevel var1, Entity var2);
}

