/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.geology;

import com.cmdpro.databank.hidden.types.BlockHiddenType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.blocks.conditional.CloakedOreBlock;
import earth.terrarium.pastel.helpers.render.ParticleHelper;
import earth.terrarium.pastel.mixin.accessors.ExperienceDroppingBlockAccessor;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleAroundBlockSidesPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ShimmerstoneOreBlock
extends CloakedOreBlock {
    public static final MapCodec<ShimmerstoneOreBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntProvider.codec((int)0, (int)10).fieldOf("experience").forGetter(b -> ((ExperienceDroppingBlockAccessor)((Object)b)).getXpRange()), (App)ShimmerstoneOreBlock.propertiesCodec()).apply((Applicative)instance, ShimmerstoneOreBlock::new));

    public ShimmerstoneOreBlock(IntProvider experienceDropped, BlockBehaviour.Properties settings) {
        super(experienceDropped, settings);
    }

    public MapCodec<? extends ShimmerstoneOreBlock> codec() {
        return CODEC;
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        RandomSource random = world.getRandom();
        if (!world.isClientSide() && !entity.isSteppingCarefully() && random.nextInt(3) == 0) {
            PlayParticleAroundBlockSidesPayload.playParticleAroundBlockSides((ServerLevel)world, 1, pos, new Vec3(0.0, 0.05, 0.0), (ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE, player -> BlockHiddenType.isVisible((BlockState)state, (Player)player), Direction.UP);
            if (random.nextInt(3) == 0) {
                PlayParticleAroundBlockSidesPayload.playParticleAroundBlockSides((ServerLevel)world, 1, pos, new Vec3(0.0, 0.025, 0.0), (ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE, player -> BlockHiddenType.isVisible((BlockState)state, (Player)player), Direction.values());
            }
        }
        super.stepOn(world, pos, state, entity);
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        RandomSource random;
        if (!world.isClientSide() && (random = world.getRandom()).nextBoolean()) {
            int amount = (int)Math.ceil(Mth.clamp((float)(fallDistance / 2.0f), (float)1.0f, (float)10.0f));
            PlayParticleAroundBlockSidesPayload.playParticleAroundBlockSides((ServerLevel)world, amount, pos, new Vec3(0.0, 0.05 + (double)amount / 30.0, 0.0), (ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE, player -> BlockHiddenType.isVisible((BlockState)state, (Player)player), Direction.UP);
        }
        super.fallOn(world, state, pos, entity, fallDistance);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (BlockHiddenType.isVisibleClient((BlockState)state)) {
            ParticleHelper.playParticleAroundBlockSides(world, (ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE, pos, Direction.values(), 1, new Vec3(0.0, 0.025, 0.0));
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide()) {
            PlayParticleAroundBlockSidesPayload.playParticleAroundBlockSides((ServerLevel)world, 3, pos, new Vec3(0.0, 0.05, 0.0), (ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE, serverPlayer -> BlockHiddenType.isVisible((BlockState)state, (Player)serverPlayer), Direction.values());
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        super.attack(state, world, pos, player);
        if (!world.isClientSide()) {
            PlayParticleAroundBlockSidesPayload.playParticleAroundBlockSides((ServerLevel)world, 1, pos, new Vec3(0.0, 0.01, 0.0), (ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE, serverPlayer -> BlockHiddenType.isVisible((BlockState)state, (Player)serverPlayer), Direction.values());
        }
    }
}

