/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.geology;

import com.cmdpro.databank.hidden.types.BlockHiddenType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.blocks.conditional.CloakedOreBlock;
import earth.terrarium.pastel.helpers.render.ParticleHelper;
import earth.terrarium.pastel.mixin.accessors.ExperienceDroppingBlockAccessor;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.sound.AuraData;
import earth.terrarium.pastel.sound.AuraSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AzuriteOreBlock
extends CloakedOreBlock {
    public static final MapCodec<AzuriteOreBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntProvider.codec((int)0, (int)10).fieldOf("experience").forGetter(b -> ((ExperienceDroppingBlockAccessor)((Object)b)).getXpRange()), (App)AzuriteOreBlock.propertiesCodec()).apply((Applicative)instance, AzuriteOreBlock::new));

    public AzuriteOreBlock(IntProvider experienceDropped, BlockBehaviour.Properties settings) {
        super(experienceDropped, settings);
    }

    public MapCodec<? extends AzuriteOreBlock> codec() {
        return CODEC;
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        super.stepOn(world, pos, state, entity);
        if (world.isClientSide() && !entity.isSteppingCarefully() && world.random.nextInt(3) == 0) {
            ParticleHelper.playParticleAroundBlockSides(world, (ParticleOptions)PastelParticleTypes.AZURE_MOTE_SMALL, pos, new Direction[]{Direction.UP}, 1, Vec3.ZERO);
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(world, pos, state, player);
        if (world.isClientSide() && BlockHiddenType.isVisibleClient((BlockState)state)) {
            ParticleHelper.playTriangulatedParticle(world, (ParticleOptions)PastelParticleTypes.AZURE_AURA, 1, false, Vec3.ZERO, 0.0, true, Vec3.atCenterOf((Vec3i)pos), new Vec3(0.0, 0.08 + world.getRandom().nextDouble() * 0.04, 0.0));
            ParticleHelper.playParticleAroundBlockSides(world, (ParticleOptions)PastelParticleTypes.AZURE_MOTE_SMALL, pos, Direction.values(), 3, Vec3.ZERO);
        }
        return state;
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        super.attack(state, world, pos, player);
        if (world.isClientSide() && BlockHiddenType.isVisible((BlockState)state, (Player)player)) {
            ParticleHelper.playParticleAroundBlockSides(world, (ParticleOptions)PastelParticleTypes.AZURE_MOTE, pos, Direction.values(), 1, Vec3.ZERO);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (!BlockHiddenType.isVisibleClient((BlockState)state)) {
            return;
        }
        AuraSoundInstance.getOrCreateInstance(AuraData.AZURITE, world, pos);
        if ((double)world.getRandom().nextFloat() >= 0.02) {
            return;
        }
        ParticleHelper.playTriangulatedParticle(world, (ParticleOptions)PastelParticleTypes.AZURE_AURA, 5, false, new Vec3(2.0, 0.0, 2.0), 0.0, true, Vec3.atLowerCornerOf((Vec3i)pos), new Vec3(0.0, 0.07 + random.nextDouble() * 0.06, 0.0));
        ParticleHelper.playParticleAroundBlockSides(world, (ParticleOptions)PastelParticleTypes.AZURE_MOTE, pos, Direction.values(), random.nextIntBetweenInclusive(1, 3), Vec3.ZERO);
        world.playSound(null, pos, PastelSounds.SOFT_HUM, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.5f + 1.0f);
    }
}

