/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fusion_shrine;

import earth.terrarium.pastel.api.block.MultiblockCrafter;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.color.ColorRegistry;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.recipe.FusionShrineRecipeWorldEffect;
import earth.terrarium.pastel.blocks.InWorldInteractionBlockEntity;
import earth.terrarium.pastel.blocks.fusion_shrine.FusionShrineBlock;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.events.PastelMiscEvents;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.PlayBlockBoundSoundInstancePayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayFusionCraftingFinishedParticlePayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayFusionCraftingInProgressParticlePayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.particle.effect.ColoredFluidRisingParticleEffect;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.recipe.FluidRecipeInput;
import earth.terrarium.pastel.recipe.fusion_shrine.FusionShrineRecipe;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionShrineBlockEntity
extends InWorldInteractionBlockEntity
implements PlayerOwned,
Upgradeable,
SidedCapabilityProvider {
    protected static final int INVENTORY_SIZE = 7;
    private UUID ownerUUID;
    private Upgradeable.UpgradeHolder upgrades;
    private RecipeHolder<FusionShrineRecipe> currentRecipe;
    private int craftingTime;
    private int craftingTimeTotal;
    boolean inventoryChanged = true;
    public final FluidTank tank = new FluidTank(1000);

    public FusionShrineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.FUSION_SHRINE.get(), pos, state, 7);
        this.inventory.addListener(i -> {
            this.inventoryChanged = true;
            this.updateInClientWorld();
        });
    }

    public static void clientTick(@NotNull Level world, BlockPos blockPos, BlockState blockState, FusionShrineBlockEntity fusionShrineBlockEntity) {
        Optional<InkColor> optionalItemColor;
        int randomSlot;
        ItemStack randomStack;
        if (!fusionShrineBlockEntity.isEmpty() && !(randomStack = fusionShrineBlockEntity.getItem(randomSlot = world.getRandom().nextInt(fusionShrineBlockEntity.getContainerSize()))).isEmpty() && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(randomStack.getItem())).isPresent()) {
            ParticleOptions particleEffect = ColoredCraftingParticleEffect.of(optionalItemColor.get().getColorInt());
            int particleAmount = (int)StrictMath.ceil((float)randomStack.getCount() / 8.0f);
            for (int i = 0; i < particleAmount; ++i) {
                float randomX = 3.0f - world.getRandom().nextFloat() * 7.0f;
                float randomZ = 3.0f - world.getRandom().nextFloat() * 7.0f;
                world.addParticle(particleEffect, (double)((float)blockPos.getX() + randomX), (double)blockPos.getY(), (double)((float)blockPos.getZ() + randomZ), 0.0, 0.0, 0.0);
            }
        }
    }

    public void spawnCraftingParticles() {
        Fluid fluid;
        Optional<InkColor> optionalFluidColor;
        BlockPos blockPos = this.getBlockPos();
        RecipeHolder<FusionShrineRecipe> recipe = this.currentRecipe;
        if (recipe != null && this.level != null && (optionalFluidColor = ColorRegistry.FLUID_COLORS.getMapping(fluid = this.tank.getFluid().getFluid())).isPresent()) {
            ParticleOptions particleEffect = ColoredFluidRisingParticleEffect.of(optionalFluidColor.get().getColorInt());
            float randomX = 0.1f + this.level.getRandom().nextFloat() * 0.8f;
            float randomZ = 0.1f + this.level.getRandom().nextFloat() * 0.8f;
            this.level.addParticle(particleEffect, (double)((float)blockPos.getX() + randomX), (double)(blockPos.getY() + 1), (double)((float)blockPos.getZ() + randomZ), 0.0, 0.1, 0.0);
        }
    }

    public void scatterContents(@NotNull Level world) {
        PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity((ServerLevel)world, Vec3.atCenterOf((Vec3i)this.getBlockPos()), ColoredCraftingParticleEffect.RED, 1, new Vec3(0.0, -0.5, 0.0));
        world.playSound(null, this.getBlockPos(), PastelSounds.CRAFTING_ABORTED, SoundSource.BLOCKS, 0.9f + world.random.nextFloat() * 0.2f, 0.9f + world.random.nextFloat() * 0.2f);
        world.playSound(null, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.9f + world.random.nextFloat() * 0.2f, 0.5f + world.random.nextFloat() * 0.2f);
        FusionShrineBlock.scatterContents(world, this.getBlockPos());
        this.inventoryChanged = true;
    }

    public static void serverTick(@NotNull Level world, BlockPos blockPos, BlockState blockState, FusionShrineBlockEntity fusionShrineBlockEntity) {
        FusionShrineRecipeWorldEffect effect;
        RecipeHolder<FusionShrineRecipe> recipe;
        if (fusionShrineBlockEntity.upgrades == null) {
            fusionShrineBlockEntity.calculateUpgrades();
        }
        if (fusionShrineBlockEntity.inventoryChanged) {
            RecipeHolder<FusionShrineRecipe> previousRecipe = fusionShrineBlockEntity.currentRecipe;
            fusionShrineBlockEntity.currentRecipe = FusionShrineBlockEntity.calculateRecipe(world, fusionShrineBlockEntity);
            if (!Objects.equals(fusionShrineBlockEntity.currentRecipe, previousRecipe)) {
                fusionShrineBlockEntity.craftingTime = 0;
                if (fusionShrineBlockEntity.currentRecipe == null) {
                    PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((ServerLevel)world, fusionShrineBlockEntity.worldPosition);
                } else {
                    fusionShrineBlockEntity.craftingTimeTotal = (int)Math.ceil((float)((FusionShrineRecipe)fusionShrineBlockEntity.currentRecipe.value()).getCraftingTime() / fusionShrineBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
                }
                fusionShrineBlockEntity.updateInClientWorld();
            }
            fusionShrineBlockEntity.inventoryChanged = false;
        }
        if ((recipe = fusionShrineBlockEntity.currentRecipe) == null) {
            return;
        }
        if (fusionShrineBlockEntity.craftingTime % 60 == 0) {
            boolean structureCompleteWithSky;
            Player lastInteractedPlayer = fusionShrineBlockEntity.getOwnerIfOnline();
            boolean recipeConditionsMet = ((FusionShrineRecipe)recipe.value()).canPlayerCraft(lastInteractedPlayer) && ((FusionShrineRecipe)recipe.value()).areConditionMetCurrently((ServerLevel)world, blockPos);
            boolean structureComplete = FusionShrineBlock.verifyStructure(world, blockPos, null);
            boolean bl = structureCompleteWithSky = FusionShrineBlock.verifySkyAccess((ServerLevel)world, blockPos) && structureComplete;
            if (!recipeConditionsMet || !structureCompleteWithSky) {
                if (!structureCompleteWithSky) {
                    fusionShrineBlockEntity.scatterContents(world);
                }
                fusionShrineBlockEntity.craftingTime = 0;
                return;
            }
        }
        ++fusionShrineBlockEntity.craftingTime;
        if (fusionShrineBlockEntity.craftingTime == 1 && fusionShrineBlockEntity.craftingTimeTotal > 1) {
            PlayBlockBoundSoundInstancePayload.sendPlayBlockBoundSoundInstance(PastelSounds.FUSION_SHRINE_CRAFTING, (ServerLevel)world, fusionShrineBlockEntity.getBlockPos(), fusionShrineBlockEntity.craftingTimeTotal - fusionShrineBlockEntity.craftingTime);
        }
        if ((effect = ((FusionShrineRecipe)recipe.value()).getWorldEffectForTick(fusionShrineBlockEntity.craftingTime, fusionShrineBlockEntity.craftingTimeTotal)) != null) {
            effect.trigger((ServerLevel)world, blockPos);
        }
        if (fusionShrineBlockEntity.craftingTime == fusionShrineBlockEntity.craftingTimeTotal) {
            FusionShrineBlockEntity.craft(world, blockPos, fusionShrineBlockEntity, recipe);
            fusionShrineBlockEntity.inventoryChanged = true;
        } else {
            PlayFusionCraftingInProgressParticlePayload.sendPlayFusionCraftingInProgressParticles((ServerLevel)world, blockPos);
        }
        fusionShrineBlockEntity.setChanged();
    }

    @Nullable
    private static RecipeHolder<FusionShrineRecipe> calculateRecipe(@NotNull Level world, FusionShrineBlockEntity fusionShrineBlockEntity) {
        if (fusionShrineBlockEntity.currentRecipe != null && ((FusionShrineRecipe)fusionShrineBlockEntity.currentRecipe.value()).matches(fusionShrineBlockEntity.getRecipeInput(), world)) {
            return fusionShrineBlockEntity.currentRecipe;
        }
        return world.getRecipeManager().getRecipeFor(PastelRecipeTypes.FUSION_SHRINE, fusionShrineBlockEntity.getRecipeInput(), world).orElse(null);
    }

    private static void craft(Level world, BlockPos blockPos, FusionShrineBlockEntity fusionShrineBlockEntity, RecipeHolder<FusionShrineRecipe> recipe) {
        ((FusionShrineRecipe)recipe.value()).craft(world, fusionShrineBlockEntity);
        if (((FusionShrineRecipe)recipe.value()).shouldPlayCraftingFinishedEffects()) {
            PlayFusionCraftingFinishedParticlePayload.sendPlayFusionCraftingFinishedParticles(world, blockPos, ((FusionShrineRecipe)recipe.value()).assemble(fusionShrineBlockEntity.getRecipeInput(), (HolderLookup.Provider)world.registryAccess()));
            fusionShrineBlockEntity.playSound(PastelSounds.FUSION_SHRINE_CRAFTING_FINISHED, 1.4f);
        }
        FusionShrineBlockEntity.scatterContents(world, blockPos.above(), fusionShrineBlockEntity);
        fusionShrineBlockEntity.tank.setFluid(FluidStack.EMPTY);
        world.setBlock(blockPos, (BlockState)world.getBlockState(blockPos).setValue((Property)FusionShrineBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(0)), 3);
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }

    public static void scatterContents(Level world, BlockPos pos, FusionShrineBlockEntity blockEntity) {
        Containers.dropContents((Level)world, (BlockPos)pos, blockEntity.inventory.getInternalList());
        world.updateNeighbourForOutputSignal(pos, world.getBlockState(pos).getBlock());
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.tank.readFromNBT(registryLookup, nbt);
        this.craftingTime = nbt.getShort("CraftingTime");
        this.craftingTimeTotal = nbt.getShort("CraftingTimeTotal");
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.currentRecipe = null;
        this.currentRecipe = MultiblockCrafter.getRecipeEntryFromNbt(this.level, nbt, FusionShrineRecipe.class);
        this.upgrades = nbt.contains("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.getList("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.tank.writeToNBT(registryLookup, nbt);
        nbt.putShort("CraftingTime", (short)this.craftingTime);
        nbt.putShort("CraftingTimeTotal", (short)this.craftingTimeTotal);
        if (this.upgrades != null) {
            nbt.put("Upgrades", (Tag)this.upgrades.toNbt());
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.currentRecipe != null) {
            nbt.putString("CurrentRecipe", this.currentRecipe.id().toString());
        }
    }

    public void playSound(SoundEvent soundEvent, float volume) {
        if (this.level != null) {
            RandomSource random = this.level.random;
            this.level.playSound(null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), soundEvent, SoundSource.BLOCKS, volume, 0.9f + random.nextFloat() * 0.15f);
        }
    }

    public void grantCriterion(ItemStack stack, int experience) {
        Level level;
        Optional required = ((FusionShrineRecipe)this.currentRecipe.value()).requiredAdvancementIdentifier;
        ServerPlayer owner = (ServerPlayer)this.getOwnerIfOnline();
        if (owner != null) {
            PastelCriteria.FUSION_SHRINE_CRAFTING.trigger(owner, stack, experience);
        }
        if ((level = this.level) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            Support.areaCriterion(sl, 16, this.getBlockPos(), required, p -> PastelCriteria.FUSION_SHRINE_CRAFTING.trigger((ServerPlayer)p, stack, experience));
        }
    }

    @NotNull
    public FluidTank getTank() {
        return this.tank;
    }

    void setLightForFluid(BlockPos blockPos, FluidStack fluid) {
        if (this.level == null) {
            return;
        }
        int fluidLight = PastelMiscEvents.getFluidLuminance(fluid);
        this.level.setBlock(blockPos, (BlockState)this.level.getBlockState(blockPos).setValue((Property)FusionShrineBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(fluidLight)), 3);
    }

    public FluidRecipeInput<FluidTank> getRecipeInput() {
        return new FluidRecipeInput<FluidTank>((List<ItemStack>)this.inventory.getInternalList(), this.tank);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.setChanged();
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.setChanged();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods4(this.level, this.worldPosition, 2, 0, this.ownerUUID);
        this.setChanged();
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        if (dir.getAxis().isHorizontal()) {
            return new StackHandlerView(this.inventory).disableInsertion();
        }
        return null;
    }

    @Override
    public IFluidHandler exposeFluidHandlers(Direction dir) {
        return this.tank;
    }
}

