/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fluid;

import earth.terrarium.pastel.blocks.decay.BlackMateriaBlock;
import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.blocks.fluid.PastelFluidBlock;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelFluidTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MidnightSolutionFluidBlock
extends PastelFluidBlock {
    public static final BlockState SPREAD_BLOCKSTATE = (BlockState)((Block)PastelBlocks.BLACK_MATERIA.get()).defaultBlockState().setValue((Property)BlackMateriaBlock.AGE, (Comparable)Integer.valueOf(0));

    public MidnightSolutionFluidBlock(PastelFluid fluid, BlockState ultrawarmReplacementBlockState, BlockBehaviour.Properties settings) {
        super(fluid, ultrawarmReplacementBlockState, settings);
    }

    @Override
    public SimpleParticleType getSplashParticle() {
        return PastelParticleTypes.MIDNIGHT_SOLUTION_SPLASH;
    }

    @Override
    public Tuple<SimpleParticleType, SimpleParticleType> getFishingParticles() {
        return new Tuple((Object)PastelParticleTypes.MIDNIGHT_SOLUTION_SPLASH, (Object)PastelParticleTypes.MIDNIGHT_SOLUTION_FISHING);
    }

    public static boolean tryConvertNeighbor(@NotNull Level world, BlockPos fromPos) {
        FluidState fluidState = world.getFluidState(fromPos);
        if (!fluidState.isEmpty() && fluidState.is(PastelFluidTags.MIDNIGHT_SOLUTION_CONVERTED)) {
            world.setBlockAndUpdate(fromPos, ((Block)PastelBlocks.MIDNIGHT_SOLUTION.get()).defaultBlockState());
            MidnightSolutionFluidBlock.fizz((LevelAccessor)world, fromPos);
            return true;
        }
        return false;
    }

    public static void fizz(@NotNull LevelAccessor world, BlockPos pos) {
        world.levelEvent(1501, pos, 0);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (!world.getBlockState(pos.above()).isRedstoneConductor((BlockGetter)world, pos.above()) && random.nextFloat() < 0.03f) {
            world.addParticle((ParticleOptions)PastelParticleTypes.VOID_FOG, (double)pos.getX() + random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + random.nextDouble(), 0.0, random.nextDouble() * 0.1, 0.0);
        }
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    public boolean shouldSpreadLiquid(Level world, BlockPos pos, BlockState state) {
        FluidState fluidState = state.getFluidState();
        if (fluidState == null || fluidState.isEmpty()) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            FluidState neighborFluidState = world.getFluidState(neighborPos);
            if (neighborFluidState == null || neighborFluidState.isEmpty()) continue;
            BlockState setState = this.handleFluidCollision(world, fluidState, neighborFluidState);
            if (setState != null) {
                this.fireExtinguishEvent((LevelAccessor)world, pos);
                world.setBlockAndUpdate(pos, setState);
                return false;
            }
            boolean isNeighborFluidBlock = world.getBlockState(neighborPos).getBlock() instanceof LiquidBlock;
            boolean doesTickEntities = world.getChunkAt(pos).getFullStatus().isOrAfter(FullChunkStatus.ENTITY_TICKING);
            if (neighborFluidState.isEmpty() || !doesTickEntities) continue;
            if (!isNeighborFluidBlock) {
                world.setBlockAndUpdate(pos, SPREAD_BLOCKSTATE);
                this.fireExtinguishEvent((LevelAccessor)world, pos);
                continue;
            }
            if (neighborFluidState.is((Fluid)this.fluid) || neighborFluidState.is(PastelFluidTags.MIDNIGHT_SOLUTION_CONVERTED) || world.getBlockState(neighborPos).is((Block)this)) continue;
            world.setBlockAndUpdate(pos, SPREAD_BLOCKSTATE);
            this.fireExtinguishEvent((LevelAccessor)world, neighborPos);
        }
        return true;
    }

    @Override
    @Nullable
    public BlockState handleFluidCollision(Level world, @NotNull FluidState state, @NotNull FluidState otherState) {
        if (otherState.is(FluidTags.LAVA)) {
            return Blocks.TERRACOTTA.defaultBlockState();
        }
        return null;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.DAMAGE_OTHER;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return PathType.DAMAGE_OTHER;
    }
}

